/*
 * Decompiled with CFR 0.152.
 */
package firstbaseinstaller;

import firstbaseinstaller.CustomProgress;
import firstbaseinstaller.Delete;
import firstbaseinstaller.Move;
import firstbaseinstaller.MyStream;
import firstbaseinstaller.Undo;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class Main
extends WindowAdapter {
    static String productName;
    static boolean isUpdate;
    static File logFile;
    static final SimpleDateFormat dateFormat;
    boolean userCancel = false;
    List<Undo> undoList = new ArrayList<Undo>();
    ZipInputStream zipStream;
    static String location;
    static String separator;

    protected static void errorDialog(String title, String message) {
        JOptionPane.showMessageDialog(null, message, productName + ": " + title, 0);
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void log(String msg) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(logFile, true);
            fw.write(dateFormat.format(new Date()) + ": " + msg + "\r\n");
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public static void main(String[] args) throws URISyntaxException {
        String updateURI;
        String jarFile = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getName();
        separator = System.getProperty("file.separator");
        jarFile = jarFile.substring(0, jarFile.length() - 4);
        jarFile = Pattern.compile("\\W?[^A-Za-z]*$").split(jarFile)[0];
        if (jarFile.equals("FirstBase_Installer") || jarFile.equals("FirstBase Installer")) {
            isUpdate = false;
            updateURI = "http://dl.skagerraksoftware.com/firstbase/installs/FirstBase_Installer_" + (separator.equals("/") ? "Mac" : "Win") + ".zip";
        } else {
            isUpdate = !jarFile.contains("Installer");
            updateURI = "http://dl.skagerraksoftware.com/firstbase/installs/" + jarFile.replaceAll(" ", "_") + ".zip";
        }
        productName = jarFile.split(" |_")[0];
        if (separator.equals("/")) {
            location = System.getProperty("user.home") + "/Applications/";
            String exeName = location + productName + separator + productName + " For Mac OS X.app";
            String[] shortcut = new String[]{"ln", "-sf", exeName, System.getProperty("user.home") + "/Desktop/"};
            String[] execute = new String[]{"open", exeName};
        } else {
            location = "C:\\";
            String exeName = location + productName + separator + productName + " For Windows.exe";
            String script = "Set sh = CreateObject(\"WScript.Shell\")\nSet shortcut = sh.CreateShortcut(\"" + System.getProperty("user.home") + "\\Desktop\\" + productName + " For Windows.lnk\")" + "\nshortcut.TargetPath = \"" + exeName + "\"" + "\nshortcut.Save";
            try {
                FileOutputStream fo = new FileOutputStream(new File(location + productName + "MakeShortcut.vbs"));
                fo.write(script.getBytes());
                fo.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            String[] shortcut = new String[]{"wscript.exe", location + productName + "MakeShortcut.vbs"};
            String[] execute = new String[]{exeName};
        }
        new Main(jarFile, location + productName, location + productName + separator + "Extensions", updateURI, !separator.equals("/"));
    }

    public Main(String jarName, String installLocation, String extensionFolderLocation, String updateZipURL, boolean windows) {
        String[] shortcut;
        String[] execute;
        String exeName;
        File installFolder = new File(installLocation);
        File extensionFolder = new File(extensionFolderLocation);
        File updateFolder = new File(installFolder.getParent(), productName + "UpdateArchive");
        logFile = new File(updateFolder, "log.txt");
        if (isUpdate) {
            Object[] options = new Object[]{"Start Update", "Do Not Update"};
            int n = JOptionPane.showOptionDialog(null, "Please Wait For " + productName + " To Quit before clicking the buttons below", productName + ": Update System", 0, 3, null, options, options[0]);
            if (n == 1) {
                Main.errorDialog("Update Cancelled", "Update will now close");
            }
        } else {
            File[] files;
            String documents = System.getProperty("user.home") + "/Documents/";
            for (File f : files = new File[]{new File(documents, "FB_Backup"), new File(documents, "FB_PDFs")}) {
                if (f.getParentFile().exists()) continue;
                Main.log(f.getName() + " folder(s) doesn't exist - creating");
                f.getParentFile().mkdirs();
            }
        }
        CustomProgress progressMonitor = new CustomProgress(jarName, "Connecting", this);
        try {
            ZipEntry entry;
            URLConnection connection = new URL(updateZipURL).openConnection();
            int downloadSize = connection.getContentLength();
            MyStream myStream = new MyStream(connection.getInputStream());
            BufferedInputStream in = new BufferedInputStream(myStream);
            this.zipStream = new ZipInputStream(in);
            if (!updateFolder.exists()) {
                updateFolder.mkdir();
            }
            if (!(updateFolder = new File(updateFolder, dateFormat.format(new Date()))).mkdirs()) {
                Main.errorDialog("Folder Creation Error", "Could not create " + productName + "UpdateArchive Folder");
            }
            if (!installFolder.exists()) {
                Main.log(productName + " folder does not exist: Creating");
                if (!installFolder.mkdirs()) {
                    Main.errorDialog("Folder Creation Error", "Could not create " + productName + " Folder");
                }
            }
            progressMonitor.setNote("Downloading and Installing");
            Main.log("Downloading " + updateZipURL + " and installing into " + installLocation);
            while ((entry = this.zipStream.getNextEntry()) != null) {
                File dir;
                File uFolder;
                File folder;
                String eName = entry.getName();
                if (eName.startsWith("__MACOSX") || eName.contains("._") || eName.endsWith(".DS_Store")) continue;
                File extensionsUpdateFolder = new File(updateFolder, "Extensions");
                if (eName.startsWith("Extensions")) {
                    if (!extensionsUpdateFolder.exists()) {
                        Main.log("Creating Extensions Folder inside " + productName + "UpdateArchive Folder");
                        extensionsUpdateFolder.mkdir();
                        this.undoList.add(new Delete(extensionsUpdateFolder));
                    }
                    if (!extensionFolder.exists()) {
                        Main.log("Creating Extensions Folder inside " + productName + " Folder");
                        extensionFolder.mkdir();
                        this.undoList.add(new Delete(extensionFolder));
                    }
                    folder = extensionFolder;
                    uFolder = extensionsUpdateFolder;
                    eName = eName.substring(11);
                } else {
                    folder = installFolder;
                    uFolder = updateFolder;
                }
                if (!entry.isDirectory()) {
                    if (eName.startsWith("_Pictures") && (eName.endsWith(".jpg") || eName.endsWith(".png") || eName.endsWith(".gif"))) {
                        try {
                            Main.log("Adding Image For Display: " + eName);
                            progressMonitor.addImage(ImageIO.read(this.zipStream));
                        }
                        catch (Exception e) {
                            Main.log("Incompatible Image File: " + eName);
                        }
                        continue;
                    }
                    Main.log("Found compressed file: " + eName);
                    File f = new File(folder, eName);
                    if (!f.getParentFile().exists()) {
                        Main.log("Parent folder(s) doesn't exist - creating");
                        f.getParentFile().mkdirs();
                    } else if (f.exists()) {
                        Main.log("File already exists - Preparing to move old file into updateFolder");
                        File b = new File(uFolder, eName);
                        if (!b.getParentFile().exists()) {
                            Main.log("Respective updateFolder path doesn't exist - creating");
                            b.getParentFile().mkdirs();
                            this.undoList.add(new Delete(b.getParentFile()));
                        }
                        Main.log("Moving file: " + f.getAbsolutePath() + " to: " + b.getAbsolutePath());
                        if (!f.renameTo(b)) {
                            throw new Exception("Could not move File: " + f.getAbsolutePath() + " to " + b.getAbsolutePath());
                        }
                        f = new File(folder, eName);
                        this.undoList.add(new Move(new File(uFolder, eName), new File(folder, eName)));
                    }
                    Main.log("Saving compressed file: " + f.getAbsolutePath());
                    FileOutputStream output = new FileOutputStream(f);
                    int len = 0;
                    byte[] buffer = new byte[4096];
                    this.undoList.add(new Delete(f));
                    while ((len = this.zipStream.read(buffer)) > 0) {
                        if (this.userCancel) {
                            return;
                        }
                        output.write(buffer, 0, len);
                        progressMonitor.setProgress((int)(myStream.getTotalBytes() * 100L / (long)downloadSize));
                    }
                    output.close();
                    if (f.length() == 0L) {
                        f.delete();
                        this.undoList.remove(this.undoList.size() - 1);
                        continue;
                    }
                    if (!f.getAbsolutePath().contains("Contents/MacOS/")) continue;
                    f.setExecutable(true, false);
                    continue;
                }
                if (eName.startsWith("_Pictures") || (dir = new File(folder, eName)).exists()) continue;
                dir.mkdir();
                this.undoList.add(new Delete(dir));
            }
            if (!isUpdate) {
                try {
                    String sep = System.getProperty("file.separator");
                    String home = System.getProperty("user.home");
                    boolean mac = sep.equals("/");
                    String oldDir = (mac ? "/" : "C:\\") + "FirstBase V4";
                    this.copyDirectory(new File(oldDir, "Backup"), new File(mac ? home + "/Applications/FirstBase" : "C:\\FirstBase", "Backup"));
                    new File(oldDir).renameTo(new File(oldDir + "_OBSELETE"));
                    new File(home + sep + "Documents" + sep + "FB_PDFs").mkdir();
                    new File(home + sep + "Documents" + sep + "FB_Backup").mkdir();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            progressMonitor.close();
            Main.log("Update finished");
        }
        catch (Exception ex) {
            if (this.userCancel) {
                return;
            }
            ex.printStackTrace();
            try {
                if (logFile != null) {
                    Main.log("ERROR: " + ex.getMessage());
                }
                progressMonitor.setProgress(0);
                progressMonitor.setNote("Rolling Back");
                this.rollBack();
                progressMonitor.close();
                Main.errorDialog("Update Failed", "An error occurred during update, your " + productName + " has been left unchanged.\n" + "Please contact " + productName + " Support on 0800 367 658.\n" + "The error was:\n" + ex.getMessage());
            }
            catch (Exception e) {
                if (logFile != null) {
                    Main.log("Critical Error");
                }
                Main.errorDialog("Critical Error", "Please contact " + productName + " Support on 0800 367 658.  Update Failed: " + ex.getMessage() + "  Rollback Failed: " + e.getMessage());
            }
        }
        if (windows) {
            exeName = location + productName + separator + productName + " For Windows.exe";
            execute = new String[]{exeName};
            String script = "Set sh = CreateObject(\"WScript.Shell\")\nSet shortcut = sh.CreateShortcut(\"" + System.getProperty("user.home") + "\\Desktop\\" + productName + " For Windows.lnk\")" + "\nshortcut.TargetPath = \"" + exeName + "\"" + "\nshortcut.Save";
            try {
                FileOutputStream fo = new FileOutputStream(new File(location + productName + separator + "MakeShortcut.vbs"));
                fo.write(script.getBytes());
                fo.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            shortcut = new String[]{"wscript.exe", location + productName + separator + "MakeShortcut.vbs"};
        } else {
            exeName = location + productName + separator + productName + " For Mac OS X.app";
            shortcut = new String[]{"ln", "-s", exeName, System.getProperty("user.home") + "/Desktop/"};
            execute = new String[]{"open", exeName};
        }
        try {
            Runtime.getRuntime().exec(shortcut);
        }
        catch (Exception ex) {
            Main.errorDialog("Alert", "Could not create Desktop Shortcut: " + ex.getMessage());
        }
        Object[] options = new Object[]{"Open " + productName, "Exit"};
        int n = JOptionPane.showOptionDialog(null, (isUpdate ? "Update" : "Install") + " Complete", productName + " " + (isUpdate ? "Updater" : "Installer"), 0, 3, null, options, options[0]);
        if (n == 1) {
            System.exit(0);
        }
        try {
            Runtime.getRuntime().exec(execute);
        }
        catch (Exception ex) {
            Main.errorDialog("Alert", "Could not open " + productName + ": " + ex.getMessage());
        }
        System.exit(0);
    }

    protected void rollBack() {
        int size = this.undoList.size();
        for (int x = size - 1; x > -1; --x) {
            this.undoList.get(x).execute();
        }
    }

    public void windowClosing(WindowEvent e) {
        this.userCancel = true;
        try {
            this.zipStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Main.log("User Cancelled Install");
        this.rollBack();
        e.getWindow().setVisible(false);
        Main.errorDialog("Update Aborted", "User cancelled during update, your " + productName + " has been left unchanged.\n");
    }

    public void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                this.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    static {
        dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH.mm.ss");
    }
}

