/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.glassfish.pfl.basic.func.UnaryVoidFunction;
import org.glassfish.pfl.dynamic.codegen.impl.ASMUtil;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionFactory;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionInternal;
import org.glassfish.pfl.dynamic.codegen.impl.VariableInternal;
import org.glassfish.pfl.dynamic.codegen.spi.ClassInfo;
import org.glassfish.pfl.dynamic.codegen.spi.FieldInfo;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Variable;
import org.glassfish.pfl.objectweb.asm.MethodVisitor;

public final class EmitterFactory {
    private static final int MAX_OPCODE = 255;
    private static String[] opcodeNames = new String[256];
    private static BitSet visitInsnSet;
    private static BitSet visitIntInsnSet;
    private static BitSet visitVarInsnSet;
    private static BitSet visitFieldInsnSet;
    private static BitSet visitMethodInsnSet;
    private static BitSet visitTypeInsnSet;
    private static BitSet visitJumpInsnSet;
    private static BitSet specialOpcodeSet;
    private static BitSet validOpcodeSet;
    private static final Emitter arrayStore;
    private static final Emitter arrayLoad;
    private static final Emitter arrayLength;

    private EmitterFactory() {
    }

    private static BitSet makeBitSet(int ... args) {
        BitSet result = new BitSet(256);
        for (int value : args) {
            result.set(value);
        }
        return result;
    }

    private static void check(BitSet validOps, int op) {
        if (!validOpcodeSet.get(op)) {
            throw new IllegalArgumentException(op + " is not a valid Bytecode");
        }
        if (!validOps.get(op)) {
            throw new IllegalArgumentException(op + " is not a valid Bytecode for this emitter");
        }
    }

    private static int getVarInsnOpcode(Type type, boolean isStore) {
        if (isStore) {
            if (!type.isPrimitive()) {
                return 58;
            }
            if (type == Type._float()) {
                return 56;
            }
            if (type == Type._double()) {
                return 57;
            }
            if (type == Type._long()) {
                return 55;
            }
            return 54;
        }
        if (!type.isPrimitive()) {
            return 25;
        }
        if (type == Type._float()) {
            return 23;
        }
        if (type == Type._double()) {
            return 24;
        }
        if (type == Type._long()) {
            return 22;
        }
        return 21;
    }

    private static Emitter makeFieldInsnEmitter(boolean isStore, boolean isStatic, Type targetType, String name, Type varType) {
        String owner = ASMUtil.bcName(targetType);
        String descriptor = varType.signature();
        int insn = isStore ? (isStatic ? 179 : 181) : (isStatic ? 178 : 180);
        return new FieldInsnEmitter(insn, owner, name, descriptor);
    }

    public static Emitter makeEmitter(Variable var, boolean isStore) {
        VariableInternal ivar = (VariableInternal)var;
        Integer slot = ASMUtil.stackFrameSlot.get(ivar);
        assert (slot != null);
        return new IntOperandEmitter(EmitterFactory.getVarInsnOpcode(ivar.type(), isStore), slot);
    }

    public static Emitter makeEmitter(ExpressionFactory.NonStaticFieldAccessExpression expr, boolean isStore) {
        Type targetType = ((ExpressionInternal)expr.target()).type();
        ClassInfo cinfo = targetType.classInfo();
        FieldInfo fld = cinfo.fieldInfo().get(expr.fieldName());
        if (fld == null) {
            throw new IllegalArgumentException(expr.fieldName() + " is not a valid field in class " + targetType.name());
        }
        return EmitterFactory.makeFieldInsnEmitter(isStore, false, targetType, expr.fieldName(), fld.type());
    }

    public static Emitter makeEmitter(ExpressionFactory.StaticFieldAccessExpression expr, boolean isStore) {
        Type targetType = (Type)expr.target();
        ClassInfo cinfo = targetType.classInfo();
        FieldInfo fld = cinfo.fieldInfo().get(expr.fieldName());
        if (fld == null) {
            throw new IllegalArgumentException(expr.fieldName() + " is not a valid field in class " + targetType.name());
        }
        return EmitterFactory.makeFieldInsnEmitter(isStore, true, targetType, expr.fieldName(), fld.type());
    }

    public static Emitter makeEmitter(ExpressionFactory.ArrayIndexExpression expr, boolean isStore) {
        if (isStore) {
            return arrayStore;
        }
        return arrayLoad;
    }

    public static Emitter makeEmitter(ExpressionFactory.ArrayLengthExpression expr) {
        return arrayLength;
    }

    static {
        for (int ctr = 0; ctr <= 255; ++ctr) {
            EmitterFactory.opcodeNames[ctr] = "ILLEGAL_" + ctr;
        }
        EmitterFactory.opcodeNames[0] = "NOP";
        EmitterFactory.opcodeNames[1] = "ACONST_NULL";
        EmitterFactory.opcodeNames[2] = "ICONST_M1";
        EmitterFactory.opcodeNames[3] = "ICONST_0";
        EmitterFactory.opcodeNames[4] = "ICONST_1";
        EmitterFactory.opcodeNames[5] = "ICONST_2";
        EmitterFactory.opcodeNames[6] = "ICONST_3";
        EmitterFactory.opcodeNames[7] = "ICONST_4";
        EmitterFactory.opcodeNames[8] = "ICONST_5";
        EmitterFactory.opcodeNames[9] = "LCONST_0";
        EmitterFactory.opcodeNames[10] = "LCONST_1";
        EmitterFactory.opcodeNames[11] = "FCONST_0";
        EmitterFactory.opcodeNames[12] = "FCONST_1";
        EmitterFactory.opcodeNames[13] = "FCONST_2";
        EmitterFactory.opcodeNames[14] = "DCONST_0";
        EmitterFactory.opcodeNames[15] = "DCONST_1";
        EmitterFactory.opcodeNames[16] = "BIPUSH";
        EmitterFactory.opcodeNames[17] = "SIPUSH";
        EmitterFactory.opcodeNames[18] = "LDC";
        EmitterFactory.opcodeNames[19] = "LDC_W";
        EmitterFactory.opcodeNames[20] = "LDC2_W";
        EmitterFactory.opcodeNames[21] = "ILOAD";
        EmitterFactory.opcodeNames[22] = "LLOAD";
        EmitterFactory.opcodeNames[23] = "FLOAD";
        EmitterFactory.opcodeNames[24] = "DLOAD";
        EmitterFactory.opcodeNames[25] = "ALOAD";
        EmitterFactory.opcodeNames[26] = "ILOAD_0";
        EmitterFactory.opcodeNames[27] = "ILOAD_1";
        EmitterFactory.opcodeNames[28] = "ILOAD_2";
        EmitterFactory.opcodeNames[29] = "ILOAD_3";
        EmitterFactory.opcodeNames[30] = "LLOAD_0";
        EmitterFactory.opcodeNames[31] = "LLOAD_1";
        EmitterFactory.opcodeNames[32] = "LLOAD_2";
        EmitterFactory.opcodeNames[33] = "LLOAD_3";
        EmitterFactory.opcodeNames[34] = "FLOAD_0";
        EmitterFactory.opcodeNames[35] = "FLOAD_1";
        EmitterFactory.opcodeNames[36] = "FLOAD_2";
        EmitterFactory.opcodeNames[37] = "FLOAD_3";
        EmitterFactory.opcodeNames[38] = "DLOAD_0";
        EmitterFactory.opcodeNames[39] = "DLOAD_1";
        EmitterFactory.opcodeNames[40] = "DLOAD_2";
        EmitterFactory.opcodeNames[41] = "DLOAD_3";
        EmitterFactory.opcodeNames[42] = "ALOAD_0";
        EmitterFactory.opcodeNames[43] = "ALOAD_1";
        EmitterFactory.opcodeNames[44] = "ALOAD_2";
        EmitterFactory.opcodeNames[45] = "ALOAD_3";
        EmitterFactory.opcodeNames[46] = "IALOAD";
        EmitterFactory.opcodeNames[47] = "LALOAD";
        EmitterFactory.opcodeNames[48] = "FALOAD";
        EmitterFactory.opcodeNames[49] = "DALOAD";
        EmitterFactory.opcodeNames[50] = "AALOAD";
        EmitterFactory.opcodeNames[51] = "BALOAD";
        EmitterFactory.opcodeNames[52] = "CALOAD";
        EmitterFactory.opcodeNames[53] = "SALOAD";
        EmitterFactory.opcodeNames[54] = "ISTORE";
        EmitterFactory.opcodeNames[55] = "LSTORE";
        EmitterFactory.opcodeNames[56] = "FSTORE";
        EmitterFactory.opcodeNames[57] = "DSTORE";
        EmitterFactory.opcodeNames[58] = "ASTORE";
        EmitterFactory.opcodeNames[59] = "ISTORE_0";
        EmitterFactory.opcodeNames[60] = "ISTORE_1";
        EmitterFactory.opcodeNames[61] = "ISTORE_2";
        EmitterFactory.opcodeNames[62] = "ISTORE_3";
        EmitterFactory.opcodeNames[63] = "LSTORE_0";
        EmitterFactory.opcodeNames[64] = "LSTORE_1";
        EmitterFactory.opcodeNames[65] = "LSTORE_2";
        EmitterFactory.opcodeNames[66] = "LSTORE_3";
        EmitterFactory.opcodeNames[67] = "FSTORE_0";
        EmitterFactory.opcodeNames[68] = "FSTORE_1";
        EmitterFactory.opcodeNames[69] = "FSTORE_2";
        EmitterFactory.opcodeNames[70] = "FSTORE_3";
        EmitterFactory.opcodeNames[71] = "DSTORE_0";
        EmitterFactory.opcodeNames[72] = "DSTORE_1";
        EmitterFactory.opcodeNames[73] = "DSTORE_2";
        EmitterFactory.opcodeNames[74] = "DSTORE_3";
        EmitterFactory.opcodeNames[75] = "ASTORE_0";
        EmitterFactory.opcodeNames[76] = "ASTORE_1";
        EmitterFactory.opcodeNames[77] = "ASTORE_2";
        EmitterFactory.opcodeNames[78] = "ASTORE_3";
        EmitterFactory.opcodeNames[79] = "IASTORE";
        EmitterFactory.opcodeNames[80] = "LASTORE";
        EmitterFactory.opcodeNames[81] = "FASTORE";
        EmitterFactory.opcodeNames[82] = "DASTORE";
        EmitterFactory.opcodeNames[83] = "AASTORE";
        EmitterFactory.opcodeNames[84] = "BASTORE";
        EmitterFactory.opcodeNames[85] = "CASTORE";
        EmitterFactory.opcodeNames[86] = "SASTORE";
        EmitterFactory.opcodeNames[87] = "POP";
        EmitterFactory.opcodeNames[88] = "POP2";
        EmitterFactory.opcodeNames[89] = "DUP";
        EmitterFactory.opcodeNames[90] = "DUP_X1";
        EmitterFactory.opcodeNames[91] = "DUP_X2";
        EmitterFactory.opcodeNames[92] = "DUP2";
        EmitterFactory.opcodeNames[93] = "DUP2_X1";
        EmitterFactory.opcodeNames[94] = "DUP2_X2";
        EmitterFactory.opcodeNames[95] = "SWAP";
        EmitterFactory.opcodeNames[96] = "IADD";
        EmitterFactory.opcodeNames[97] = "LADD";
        EmitterFactory.opcodeNames[98] = "FADD";
        EmitterFactory.opcodeNames[99] = "DADD";
        EmitterFactory.opcodeNames[100] = "ISUB";
        EmitterFactory.opcodeNames[101] = "LSUB";
        EmitterFactory.opcodeNames[102] = "FSUB";
        EmitterFactory.opcodeNames[103] = "DSUB";
        EmitterFactory.opcodeNames[104] = "IMUL";
        EmitterFactory.opcodeNames[105] = "LMUL";
        EmitterFactory.opcodeNames[106] = "FMUL";
        EmitterFactory.opcodeNames[107] = "DMUL";
        EmitterFactory.opcodeNames[108] = "IDIV";
        EmitterFactory.opcodeNames[109] = "LDIV";
        EmitterFactory.opcodeNames[110] = "FDIV";
        EmitterFactory.opcodeNames[111] = "DDIV";
        EmitterFactory.opcodeNames[112] = "IREM";
        EmitterFactory.opcodeNames[113] = "LREM";
        EmitterFactory.opcodeNames[114] = "FREM";
        EmitterFactory.opcodeNames[115] = "DREM";
        EmitterFactory.opcodeNames[116] = "INEG";
        EmitterFactory.opcodeNames[117] = "LNEG";
        EmitterFactory.opcodeNames[118] = "FNEG";
        EmitterFactory.opcodeNames[119] = "DNEG";
        EmitterFactory.opcodeNames[120] = "ISHL";
        EmitterFactory.opcodeNames[121] = "LSHL";
        EmitterFactory.opcodeNames[122] = "ISHR";
        EmitterFactory.opcodeNames[123] = "LSHR";
        EmitterFactory.opcodeNames[124] = "IUSHR";
        EmitterFactory.opcodeNames[125] = "LUSHR";
        EmitterFactory.opcodeNames[126] = "IAND";
        EmitterFactory.opcodeNames[127] = "LAND";
        EmitterFactory.opcodeNames[128] = "IOR";
        EmitterFactory.opcodeNames[129] = "LOR";
        EmitterFactory.opcodeNames[130] = "IXOR";
        EmitterFactory.opcodeNames[131] = "LXOR";
        EmitterFactory.opcodeNames[132] = "IINC";
        EmitterFactory.opcodeNames[133] = "I2L";
        EmitterFactory.opcodeNames[134] = "I2F";
        EmitterFactory.opcodeNames[135] = "I2D";
        EmitterFactory.opcodeNames[136] = "L2I";
        EmitterFactory.opcodeNames[137] = "L2F";
        EmitterFactory.opcodeNames[138] = "L2D";
        EmitterFactory.opcodeNames[139] = "F2I";
        EmitterFactory.opcodeNames[140] = "F2L";
        EmitterFactory.opcodeNames[141] = "F2D";
        EmitterFactory.opcodeNames[142] = "D2I";
        EmitterFactory.opcodeNames[143] = "D2L";
        EmitterFactory.opcodeNames[144] = "D2F";
        EmitterFactory.opcodeNames[145] = "I2B";
        EmitterFactory.opcodeNames[146] = "I2C";
        EmitterFactory.opcodeNames[147] = "I2S";
        EmitterFactory.opcodeNames[148] = "LCMP";
        EmitterFactory.opcodeNames[149] = "FCMPL";
        EmitterFactory.opcodeNames[150] = "FCMPG";
        EmitterFactory.opcodeNames[151] = "DCMPL";
        EmitterFactory.opcodeNames[152] = "DCMPG";
        EmitterFactory.opcodeNames[153] = "IFEQ";
        EmitterFactory.opcodeNames[154] = "IFNE";
        EmitterFactory.opcodeNames[155] = "IFLT";
        EmitterFactory.opcodeNames[156] = "IFGE";
        EmitterFactory.opcodeNames[157] = "IFGT";
        EmitterFactory.opcodeNames[158] = "IFLE";
        EmitterFactory.opcodeNames[159] = "IF_ICMPEQ";
        EmitterFactory.opcodeNames[160] = "IF_ICMPNE";
        EmitterFactory.opcodeNames[161] = "IF_ICMPLT";
        EmitterFactory.opcodeNames[162] = "IF_ICMPGE";
        EmitterFactory.opcodeNames[163] = "IF_ICMPGT";
        EmitterFactory.opcodeNames[164] = "IF_ICMPLE";
        EmitterFactory.opcodeNames[165] = "IF_ACMPEQ";
        EmitterFactory.opcodeNames[166] = "IF_ACMPNE";
        EmitterFactory.opcodeNames[167] = "GOTO";
        EmitterFactory.opcodeNames[168] = "JSR";
        EmitterFactory.opcodeNames[169] = "RET";
        EmitterFactory.opcodeNames[170] = "TABLESWITCH";
        EmitterFactory.opcodeNames[171] = "LOOKUPSWITCH";
        EmitterFactory.opcodeNames[172] = "IRETURN";
        EmitterFactory.opcodeNames[173] = "LRETURN";
        EmitterFactory.opcodeNames[174] = "FRETURN";
        EmitterFactory.opcodeNames[175] = "DRETURN";
        EmitterFactory.opcodeNames[176] = "ARETURN";
        EmitterFactory.opcodeNames[177] = "RETURN";
        EmitterFactory.opcodeNames[178] = "GETSTATIC";
        EmitterFactory.opcodeNames[179] = "PUTSTATIC";
        EmitterFactory.opcodeNames[180] = "GETFIELD";
        EmitterFactory.opcodeNames[181] = "PUTFIELD";
        EmitterFactory.opcodeNames[182] = "INVOKEVIRTUAL";
        EmitterFactory.opcodeNames[183] = "INVOKESPECIAL";
        EmitterFactory.opcodeNames[184] = "INVOKESTATIC";
        EmitterFactory.opcodeNames[185] = "INVOKEINTERFACE";
        EmitterFactory.opcodeNames[186] = "UNUSED";
        EmitterFactory.opcodeNames[187] = "NEW";
        EmitterFactory.opcodeNames[188] = "NEWARRAY";
        EmitterFactory.opcodeNames[189] = "ANEWARRAY";
        EmitterFactory.opcodeNames[190] = "ARRAYLENGTH";
        EmitterFactory.opcodeNames[191] = "ATHROW";
        EmitterFactory.opcodeNames[192] = "CHECKCAST";
        EmitterFactory.opcodeNames[193] = "INSTANCEOF";
        EmitterFactory.opcodeNames[194] = "MONITORENTER";
        EmitterFactory.opcodeNames[195] = "MONITOREXIT";
        EmitterFactory.opcodeNames[196] = "WIDE";
        EmitterFactory.opcodeNames[197] = "MULTIANEWARRAY";
        EmitterFactory.opcodeNames[198] = "IFNULL";
        EmitterFactory.opcodeNames[199] = "IFNONNULL";
        EmitterFactory.opcodeNames[200] = "GOTO_W";
        EmitterFactory.opcodeNames[201] = "JSR_W";
        visitInsnSet = EmitterFactory.makeBitSet(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 46, 47, 48, 49, 50, 51, 52, 53, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 172, 173, 174, 175, 176, 177, 190, 191, 194, 195, 190);
        visitIntInsnSet = EmitterFactory.makeBitSet(16, 17, 188);
        visitVarInsnSet = EmitterFactory.makeBitSet(21, 22, 23, 24, 25, 169, 54, 55, 56, 57, 58);
        visitFieldInsnSet = EmitterFactory.makeBitSet(178, 179, 180, 181);
        visitMethodInsnSet = EmitterFactory.makeBitSet(182, 183, 184, 185);
        visitTypeInsnSet = EmitterFactory.makeBitSet(187, 189, 192, 193);
        visitJumpInsnSet = EmitterFactory.makeBitSet(153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 198, 199);
        specialOpcodeSet = EmitterFactory.makeBitSet(132, 18, 170, 171, 197);
        validOpcodeSet = EmitterFactory.makeBitSet(new int[0]);
        validOpcodeSet.or(visitInsnSet);
        validOpcodeSet.or(visitIntInsnSet);
        validOpcodeSet.or(visitVarInsnSet);
        validOpcodeSet.or(visitFieldInsnSet);
        validOpcodeSet.or(visitMethodInsnSet);
        validOpcodeSet.or(visitTypeInsnSet);
        validOpcodeSet.or(visitJumpInsnSet);
        validOpcodeSet.or(specialOpcodeSet);
        arrayStore = new SimpleEmitter(83);
        arrayLoad = new SimpleEmitter(50);
        arrayLength = new SimpleEmitter(190);
    }

    private static class FieldInsnEmitter
    implements Emitter {
        private int opcode;
        private String owner;
        private String name;
        private String desc;

        public FieldInsnEmitter(int opcode, String owner, String name, String desc) {
            EmitterFactory.check(visitFieldInsnSet, opcode);
            this.opcode = opcode;
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        @Override
        public void evaluate(MethodVisitor mv) {
            mv.visitFieldInsn(this.opcode, this.owner, this.name, this.desc);
        }

        public String toString() {
            return "FieldInsnEmitter[" + opcodeNames[this.opcode] + " \"" + this.owner + "\" \"" + this.name + "\" \"" + this.desc + "\"]";
        }

        public int hashCode() {
            return this.opcode * 91 ^ this.owner.hashCode() ^ this.name.hashCode() ^ this.desc.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FieldInsnEmitter)) {
                return false;
            }
            FieldInsnEmitter other = (FieldInsnEmitter)FieldInsnEmitter.class.cast(obj);
            return other.opcode == this.opcode && other.owner.equals(this.owner) && other.name.equals(this.name) && other.desc.equals(this.desc);
        }
    }

    private static class IntOperandEmitter
    implements Emitter {
        private static BitSet validOps = new BitSet();
        private int opcode;
        private int arg;

        public IntOperandEmitter(int opcode, int arg) {
            EmitterFactory.check(IntOperandEmitter.validOps, opcode);
            this.opcode = opcode;
            this.arg = arg;
        }

        @Override
        public void evaluate(MethodVisitor mv) {
            if (visitIntInsnSet.get(this.opcode)) {
                mv.visitIntInsn(this.opcode, this.arg);
            } else {
                assert (visitVarInsnSet.get(this.opcode));
                mv.visitVarInsn(this.opcode, this.arg);
            }
        }

        public String toString() {
            return "IntOperandEmitter[" + opcodeNames[this.opcode] + " " + this.arg + "]";
        }

        public int hashCode() {
            return this.opcode * 91 + this.arg;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IntOperandEmitter)) {
                return false;
            }
            IntOperandEmitter other = (IntOperandEmitter)IntOperandEmitter.class.cast(obj);
            return other.opcode == this.opcode && other.arg == this.arg;
        }

        static {
            validOps.or(visitIntInsnSet);
            validOps.or(visitVarInsnSet);
        }
    }

    public static class SimpleEmitter
    implements Emitter {
        private int opcode;

        public SimpleEmitter(int opcode) {
            EmitterFactory.check(visitInsnSet, opcode);
            this.opcode = opcode;
        }

        @Override
        public void evaluate(MethodVisitor mv) {
            mv.visitInsn(this.opcode);
        }

        public String toString() {
            return "SimpleEmitter[" + opcodeNames[this.opcode] + "]";
        }

        public int hashCode() {
            return this.opcode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SimpleEmitter)) {
                return false;
            }
            SimpleEmitter other = (SimpleEmitter)SimpleEmitter.class.cast(obj);
            return other.opcode == this.opcode;
        }
    }

    public static class CompoundEmitter
    implements Emitter {
        private List<Emitter> emitters = new ArrayList<Emitter>();

        public CompoundEmitter(Emitter ... args) {
            for (Emitter e : args) {
                this.emitters.add(e);
            }
        }

        @Override
        public void evaluate(MethodVisitor mv) {
            for (Emitter e : this.emitters) {
                e.evaluate(mv);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("CompoundEmitter[");
            boolean first = true;
            for (Emitter e : this.emitters) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(e.toString());
            }
            sb.append("]");
            return sb.toString();
        }

        public int hashCode() {
            int hash = 0;
            for (Emitter e : this.emitters) {
                hash ^= e.hashCode();
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CompoundEmitter)) {
                return false;
            }
            CompoundEmitter other = (CompoundEmitter)CompoundEmitter.class.cast(obj);
            Iterator<Emitter> it1 = this.emitters.iterator();
            Iterator<Emitter> it2 = other.emitters.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Emitter e2;
                Emitter e1 = it1.next();
                if (e1.equals(e2 = it2.next())) continue;
                return false;
            }
            return it1.hasNext() == it2.hasNext();
        }
    }

    public static class NullEmitter
    implements Emitter {
        @Override
        public void evaluate(MethodVisitor mv) {
        }

        public String toString() {
            return "NullEmitter[]";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof NullEmitter;
        }
    }

    public static interface Emitter
    extends UnaryVoidFunction<MethodVisitor> {
    }
}

