/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.util;

import com.prosc.thread.ThreadUtil;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class Debounce<T> {
    private static final Logger log = Logger.getLogger(Debounce.class.getName());
    private final int eventDelay;
    private final int maxTotalDelay;
    @NotNull
    private final Consumer<T> eventHandler;
    private T lastPost;
    private Thread timerThread;
    private long nextEventTime;
    private long maxEventTime;

    public Debounce(int eventDelay, int maxTotalDelay, @NotNull Consumer<T> eventHandler) {
        if (eventHandler == null) {
            Debounce.$$$reportNull$$$0(0);
        }
        this.timerThread = null;
        this.nextEventTime = -1L;
        this.maxEventTime = Long.MAX_VALUE;
        this.eventDelay = eventDelay;
        this.maxTotalDelay = maxTotalDelay;
        this.eventHandler = eventHandler;
        if (eventDelay < 0) {
            throw new IllegalArgumentException("eventDelay must be a positive number of milliseconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(T input) {
        boolean startThread;
        Debounce debounce = this;
        synchronized (debounce) {
            this.lastPost = input;
            this.nextEventTime = System.currentTimeMillis() + (long)this.eventDelay;
            if (this.maxEventTime == Long.MAX_VALUE && (long)this.maxTotalDelay != -1L) {
                this.maxEventTime = System.currentTimeMillis() + (long)this.maxTotalDelay;
            }
            startThread = this.timerThread == null;
        }
        if (startThread) {
            this.timerThread = new Thread("Debounce timer thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            long delayAmount;
                            long now = System.currentTimeMillis();
                            1 var5_5 = this;
                            synchronized (var5_5) {
                                delayAmount = Math.min(Debounce.this.nextEventTime - now, Debounce.this.maxEventTime - now);
                            }
                            if (delayAmount > 0L) {
                                ThreadUtil.sleepProduction((int)delayAmount, true);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        log.log(Level.WARNING, "Debounce timer interrupted; proceeding without waiting for further events");
                    }
                    1 var1_3 = this;
                    synchronized (var1_3) {
                        Debounce.this.eventHandler.accept(Debounce.this.lastPost);
                        Debounce.this.timerThread = null;
                        Debounce.this.maxEventTime = Long.MAX_VALUE;
                    }
                }
            };
            this.timerThread.start();
        }
    }

    public void flush() {
        this.timerThread.interrupt();
        try {
            this.timerThread.join();
            this.timerThread = null;
        }
        catch (InterruptedException e) {
            log.warning("Debounce interrupted during close(), it is possible that the last event posted may not be processed");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventHandler", "com/prosc/util/Debounce", "<init>"));
    }
}

