/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.thread;

import com.prosc.core.ExceptionCoreUtils;
import com.prosc.data.tuple.Pair;
import com.prosc.function.FunctionThrowable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class ThreadUtil {
    private static final Logger log = Logger.getLogger(ThreadUtil.class.getName());

    public static Thread getThreadByName(@NotNull String name) {
        if (name == null) {
            ThreadUtil.$$$reportNull$$$0(0);
        }
        Thread returnThread = null;
        ThreadGroup topThreadGroup = null;
        for (ThreadGroup threadGroup = Thread.currentThread().getThreadGroup(); threadGroup != null; threadGroup = threadGroup.getParent()) {
            topThreadGroup = threadGroup;
        }
        if (topThreadGroup != null) {
            Thread[] threads = new Thread[topThreadGroup.activeCount()];
            topThreadGroup.enumerate(threads, true);
            for (Thread thread : threads) {
                if (!thread.getName().equals(name)) continue;
                returnThread = thread;
            }
        }
        return returnThread;
    }

    public static <T> T getNoInterrupt(Future<T> future, boolean cancelOnInterrupt) {
        return ThreadUtil.getNoInterrupt(future, cancelOnInterrupt, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable> T getNoInterrupt(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1) throws E1 {
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(1);
        }
        return ThreadUtil.getNoInterrupt(future, cancelOnInterrupt, exceptionClass1, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> T getNoInterrupt(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2) throws E1, E2 {
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(2);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(3);
        }
        return ThreadUtil.getNoInterrupt(future, cancelOnInterrupt, exceptionClass1, exceptionClass2, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> T getNoInterrupt(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3) throws E1, E2, E3 {
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(4);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(5);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(6);
        }
        return ThreadUtil.getNoInterrupt(future, cancelOnInterrupt, exceptionClass1, exceptionClass2, exceptionClass3, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> T getNoInterrupt(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5, @NotNull Class<E6> exceptionClass6) throws E1, E2, E3, E4, E5, E6 {
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(7);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(8);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(9);
        }
        if (exceptionClass4 == null) {
            ThreadUtil.$$$reportNull$$$0(10);
        }
        if (exceptionClass5 == null) {
            ThreadUtil.$$$reportNull$$$0(11);
        }
        if (exceptionClass6 == null) {
            ThreadUtil.$$$reportNull$$$0(12);
        }
        boolean isInterrupted = false;
        while (true) {
            try {
                T t = ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, exceptionClass5, exceptionClass6);
                return t;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                isInterrupted = true;
                if (cancelOnInterrupt) {
                    future.cancel(true);
                    log.log(Level.WARNING, "Thread " + Thread.currentThread().getName() + " was interrupted, sending cancellation request");
                    continue;
                }
                log.log(Level.WARNING, "Thread " + Thread.currentThread().getName() + " was interrupted, but will be ignored until task completes");
                continue;
            }
            break;
        }
        finally {
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T getInterruptible(Future<T> future) throws InterruptedException {
        return ThreadUtil.getInterruptible(future, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable> T getInterruptible(@NotNull Future<T> future, Class<E1> exceptionClass1) throws E1, InterruptedException {
        if (future == null) {
            ThreadUtil.$$$reportNull$$$0(13);
        }
        return ThreadUtil.getInterruptible(future, exceptionClass1, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> T getInterruptible(@NotNull Future<T> future, Class<E1> exceptionClass1, Class<E2> exceptionClass2) throws E1, E2, InterruptedException {
        if (future == null) {
            ThreadUtil.$$$reportNull$$$0(14);
        }
        return ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> T getInterruptible(@NotNull Future<T> future, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3) throws E1, E2, E3, InterruptedException {
        if (future == null) {
            ThreadUtil.$$$reportNull$$$0(15);
        }
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(16);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(17);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(18);
        }
        return ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, exceptionClass3, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> T getInterruptible(@NotNull Future<T> future, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4) throws E1, E2, E3, E4, InterruptedException {
        if (future == null) {
            ThreadUtil.$$$reportNull$$$0(19);
        }
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(20);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(21);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(22);
        }
        if (exceptionClass4 == null) {
            ThreadUtil.$$$reportNull$$$0(23);
        }
        return ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable> T getInterruptible(@NotNull Future<T> future, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5) throws E1, E2, E3, E4, E5, InterruptedException {
        if (future == null) {
            ThreadUtil.$$$reportNull$$$0(24);
        }
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(25);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(26);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(27);
        }
        if (exceptionClass4 == null) {
            ThreadUtil.$$$reportNull$$$0(28);
        }
        if (exceptionClass5 == null) {
            ThreadUtil.$$$reportNull$$$0(29);
        }
        return ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, exceptionClass5, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> T getInterruptible(@NotNull Future<T> future, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5, @NotNull Class<E6> exceptionClass6) throws E1, E2, E3, E4, E5, E6, InterruptedException {
        if (future == null) {
            ThreadUtil.$$$reportNull$$$0(30);
        }
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(31);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(32);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(33);
        }
        if (exceptionClass4 == null) {
            ThreadUtil.$$$reportNull$$$0(34);
        }
        if (exceptionClass5 == null) {
            ThreadUtil.$$$reportNull$$$0(35);
        }
        if (exceptionClass6 == null) {
            ThreadUtil.$$$reportNull$$$0(36);
        }
        try {
            return future.get();
        }
        catch (CompletionException | ExecutionException e) {
            throw ExceptionCoreUtils.rethrowTypeSafeException(e.getCause(), exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, exceptionClass5, exceptionClass6);
        }
    }

    public static <T> T getOrNull(Future<T> future) {
        try {
            return future.get();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error while getting future result", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, I> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task) throws InterruptedException, ExecutionException, CompletionException {
        if (inputs == null) {
            ThreadUtil.$$$reportNull$$$0(37);
        }
        if (task == null) {
            ThreadUtil.$$$reportNull$$$0(38);
        }
        ArrayList<Future<Pair>> futures = new ArrayList<Future<Pair>>(inputs.size());
        ExecutorService worker = Executors.newFixedThreadPool(inputs.size());
        try {
            int n = 0;
            for (I i : inputs) {
                int index = n++;
                futures.add(worker.submit(() -> new Pair(index, task.apply(input))));
            }
            ArrayList result = new ArrayList(inputs.size());
            for (int n2 = 0; n2 < inputs.size(); ++n2) {
                result.add(null);
            }
            for (Future future : futures) {
                Pair pair = (Pair)future.get();
                result.set((Integer)pair.a, pair.b);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            worker.shutdown();
        }
    }

    public static <T, I, E1 extends Throwable> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task, @NotNull Class<E1> exceptionClass1) throws InterruptedException, E1 {
        if (inputs == null) {
            ThreadUtil.$$$reportNull$$$0(39);
        }
        if (task == null) {
            ThreadUtil.$$$reportNull$$$0(40);
        }
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(41);
        }
        return ThreadUtil.doTasks(inputs, task, exceptionClass1, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, I, E1 extends Throwable, E2 extends Throwable> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2) throws InterruptedException, E1, E2 {
        if (inputs == null) {
            ThreadUtil.$$$reportNull$$$0(42);
        }
        if (task == null) {
            ThreadUtil.$$$reportNull$$$0(43);
        }
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(44);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(45);
        }
        return ThreadUtil.doTasks(inputs, task, exceptionClass1, exceptionClass2, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, I, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3) throws InterruptedException, E1, E2, E3 {
        if (inputs == null) {
            ThreadUtil.$$$reportNull$$$0(46);
        }
        if (task == null) {
            ThreadUtil.$$$reportNull$$$0(47);
        }
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(48);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(49);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(50);
        }
        return ThreadUtil.doTasks(inputs, task, exceptionClass1, exceptionClass2, exceptionClass3, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, I, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4) throws InterruptedException, E1, E2, E3, E4 {
        if (inputs == null) {
            ThreadUtil.$$$reportNull$$$0(51);
        }
        if (task == null) {
            ThreadUtil.$$$reportNull$$$0(52);
        }
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(53);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(54);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(55);
        }
        if (exceptionClass4 == null) {
            ThreadUtil.$$$reportNull$$$0(56);
        }
        return ThreadUtil.doTasks(inputs, task, exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, RuntimeException.class, RuntimeException.class);
    }

    public static <T, I, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5) throws InterruptedException, E1, E2, E3, E4, E5 {
        if (inputs == null) {
            ThreadUtil.$$$reportNull$$$0(57);
        }
        if (task == null) {
            ThreadUtil.$$$reportNull$$$0(58);
        }
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(59);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(60);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(61);
        }
        if (exceptionClass4 == null) {
            ThreadUtil.$$$reportNull$$$0(62);
        }
        if (exceptionClass5 == null) {
            ThreadUtil.$$$reportNull$$$0(63);
        }
        return ThreadUtil.doTasks(inputs, task, exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, exceptionClass5, RuntimeException.class);
    }

    public static <T, I, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5, @NotNull Class<E6> exceptionClass6) throws InterruptedException, E1, E2, E3, E4, E5, E6 {
        if (inputs == null) {
            ThreadUtil.$$$reportNull$$$0(64);
        }
        if (task == null) {
            ThreadUtil.$$$reportNull$$$0(65);
        }
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(66);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(67);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(68);
        }
        if (exceptionClass4 == null) {
            ThreadUtil.$$$reportNull$$$0(69);
        }
        if (exceptionClass5 == null) {
            ThreadUtil.$$$reportNull$$$0(70);
        }
        if (exceptionClass6 == null) {
            ThreadUtil.$$$reportNull$$$0(71);
        }
        try {
            return ThreadUtil.doTasks(inputs, task);
        }
        catch (CompletionException | ExecutionException e) {
            throw ExceptionCoreUtils.rethrowTypeSafeException(e.getCause(), exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, exceptionClass5, exceptionClass6);
        }
    }

    public static void sleepDebug(long milliseconds) {
        ThreadUtil.sleepDebug(milliseconds, false);
    }

    public static void sleepDebug(long milliseconds, boolean suppressMessage) {
        if (milliseconds > 0L) {
            try {
                if (!suppressMessage) {
                    log.warning("There is a debugging delay of " + milliseconds + " milliseconds; this should never happen in production code");
                }
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    public static void sleepProduction(int milliseconds) throws InterruptedException {
        ThreadUtil.sleepProduction(milliseconds, false);
    }

    public static void sleepProduction(int milliseconds, boolean suppressMessage) throws InterruptedException {
        if (milliseconds > 0) {
            if (!suppressMessage) {
                log.config("Sleep called for " + milliseconds + " milliseconds");
            }
            Thread.sleep(milliseconds);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 16: 
            case 20: 
            case 25: 
            case 31: 
            case 41: 
            case 44: 
            case 48: 
            case 53: 
            case 59: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass1";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 17: 
            case 21: 
            case 26: 
            case 32: 
            case 45: 
            case 49: 
            case 54: 
            case 60: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass2";
                break;
            }
            case 6: 
            case 9: 
            case 18: 
            case 22: 
            case 27: 
            case 33: 
            case 50: 
            case 55: 
            case 61: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass3";
                break;
            }
            case 10: 
            case 23: 
            case 28: 
            case 34: 
            case 56: 
            case 62: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass4";
                break;
            }
            case 11: 
            case 29: 
            case 35: 
            case 63: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass5";
                break;
            }
            case 12: 
            case 36: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass6";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 37: 
            case 39: 
            case 42: 
            case 46: 
            case 51: 
            case 57: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputs";
                break;
            }
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 52: 
            case 58: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/prosc/thread/ThreadUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getThreadByName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getNoInterrupt";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "getInterruptible";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[2] = "doTasks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

