/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.thread;

import com.prosc.core.ExceptionCoreUtils;
import com.prosc.thread.MyThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FutureUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletableFuture<Void> runAsyncCancelable(Runnable task, String threadName) {
        ExecutorService worker = Executors.newCachedThreadPool(new MyThreadFactory(threadName));
        try {
            CompletableFuture<Void> completableFuture = FutureUtil.runAsyncCancelable(task, worker);
            return completableFuture;
        }
        finally {
            worker.shutdown();
        }
    }

    public static CompletableFuture<Void> runAsyncCancelable(Runnable task, ExecutorService executorService) {
        final Future[] futureArray = new Future[1];
        CompletableFuture<Void> result = new CompletableFuture<Void>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return futureArray[0].cancel(mayInterruptIfRunning);
            }
        };
        futureArray[0] = executorService.submit(() -> {
            try {
                task.run();
                result.complete(null);
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        });
        return result;
    }

    public static <T, E1 extends Exception> T getInterruptible(Future<T> future, Callable1<T, E1> callable) throws InterruptedException, E1 {
        return FutureUtil.getInterruptible(future);
    }

    public static <T, E1 extends Exception, E2 extends Exception> T getInterruptible(Future<T> future, Callable2<T, E1, E2> callable) throws InterruptedException, E1, E2 {
        return FutureUtil.getInterruptible(future);
    }

    public static <T, E1 extends Exception, E2 extends Exception, E3 extends Exception> T getInterruptible(Future<T> future, Callable3<T, E1, E2, E3> callable) throws InterruptedException, E1, E2, E3 {
        return FutureUtil.getInterruptible(future);
    }

    public static <T, E1 extends Exception, E2 extends Exception, E3 extends Exception, E4 extends Exception> T getInterruptible(Future<T> future, Callable4<T, E1, E2, E3, E4> callable) throws InterruptedException, E1, E2, E3, E4 {
        return FutureUtil.getInterruptible(future);
    }

    public static <T, E1 extends Exception, E2 extends Exception, E3 extends Exception, E4 extends Exception, E5 extends Exception> T getInterruptible(Future<T> future, Callable5<T, E1, E2, E3, E4, E5> callable) throws InterruptedException, E1, E2, E3, E4, E5 {
        return FutureUtil.getInterruptible(future);
    }

    public static <T, E1 extends Exception> T getInterruptible(Future<T> future) throws InterruptedException, E1 {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            Throwable toThrow = e.getCause();
            ExceptionCoreUtils.appendCurrentStackTrace(toThrow);
            throw (Exception)toThrow;
        }
    }

    public static <T, E1 extends Exception> T getCancelable(CompletableFuture<T> future) throws CancellationException, E1 {
        try {
            return future.join();
        }
        catch (CompletionException e) {
            Throwable toThrow = e.getCause();
            if (toThrow instanceof Exception) {
                ExceptionCoreUtils.appendCurrentStackTrace(toThrow);
                throw (Exception)toThrow;
            }
            throw e;
        }
    }

    public static abstract class Callable5<T, E1 extends Exception, E2 extends Exception, E3 extends Exception, E4 extends Exception, E5 extends Exception>
    implements Callable<T> {
        @Override
        public abstract T call() throws E1, E2, E3, E4, E5;
    }

    public static abstract class Callable4<T, E1 extends Exception, E2 extends Exception, E3 extends Exception, E4 extends Exception>
    implements Callable<T> {
        @Override
        public abstract T call() throws E1, E2, E3, E4;
    }

    public static abstract class Callable3<T, E1 extends Exception, E2 extends Exception, E3 extends Exception>
    implements Callable<T> {
        @Override
        public abstract T call() throws E1, E2, E3;
    }

    public static abstract class Callable2<T, E1 extends Exception, E2 extends Exception>
    implements Callable<T> {
        @Override
        public abstract T call() throws E1, E2;
    }

    public static abstract class Callable1<T, E1 extends Exception>
    implements Callable<T> {
        @Override
        public abstract T call() throws E1;
    }
}

