/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.text;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public class QuotedTextTokenizer
implements Iterable<String> {
    private final Iterator<String> iterator;

    public QuotedTextTokenizer(final Reader text, final char openQuote, final char closeQuote, final boolean includeQuotes, final boolean includeDelimiters, final boolean backslashEscape, final char ... delimiters) {
        this.iterator = new Iterator<String>(){
            private String next;
            {
                this.next();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public String next() {
                String result = this.next;
                try {
                    int r;
                    boolean inQuote = false;
                    StringBuilder chunk = new StringBuilder();
                    while ((r = text.read()) != -1) {
                        char c = (char)r;
                        if (c == '\\' && backslashEscape) {
                            chunk.append((char)text.read());
                            continue;
                        }
                        if (!inQuote && c == openQuote) {
                            inQuote = true;
                            if (!includeQuotes) continue;
                            chunk.append(c);
                            continue;
                        }
                        if (inQuote && c == closeQuote) {
                            inQuote = false;
                            if (!includeQuotes) continue;
                            chunk.append(c);
                            continue;
                        }
                        boolean foundDelimiter = false;
                        if (!inQuote) {
                            for (char delimiter : delimiters) {
                                if (delimiter != c) continue;
                                foundDelimiter = true;
                                if (!includeDelimiters) break;
                                chunk.append(c);
                                break;
                            }
                        }
                        if (foundDelimiter) break;
                        chunk.append(c);
                    }
                    this.next = chunk.length() > 0 ? chunk.toString() : null;
                    return result;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Stream<String> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        Iterator<String> iterator = this.iterator;
        if (iterator == null) {
            QuotedTextTokenizer.$$$reportNull$$$0(0);
        }
        return iterator;
    }

    @Override
    public Spliterator<String> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator, 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/text/QuotedTextTokenizer", "iterator"));
    }
}

