/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.shared.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class DebugTimer
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(DebugTimer.class.getName());
    private static final String CR = System.getProperty("line.separator");
    private final List<TimeMark> timeMarks = new ArrayList<TimeMark>(1);
    private final Level logLevel;
    private ThreadLocal<TimeMark> mark = ThreadLocal.withInitial(() -> {
        TimeMark result = new TimeMark();
        result.startTime = System.currentTimeMillis();
        result.threadName = Thread.currentThread().getName();
        DebugTimer debugTimer = this;
        synchronized (debugTimer) {
            this.timeMarks.add(result);
        }
        return result;
    });
    protected final boolean enabled;
    private boolean stopped = false;

    @Override
    public void close() {
        this.stop();
    }

    public DebugTimer(String debugMessage) {
        this(debugMessage, true);
    }

    public DebugTimer(String debugMessage, boolean enabled) {
        this(debugMessage, enabled, Level.INFO);
    }

    public DebugTimer(String debugMessage, boolean enabled, Level logLevel) {
        this.enabled = enabled;
        this.logLevel = logLevel;
        this.markTime("Starting timer: " + debugMessage);
    }

    public void markTime(@Nullable String markMessage) {
        if (!this.enabled) {
            return;
        }
        if (this.stopped) {
            log.warning("markTime was called after DebugTimer was stopped. This message will not be included in the output logs. Message: " + markMessage);
        } else {
            long timestamp = System.currentTimeMillis();
            this.mark.get().markTime(markMessage, timestamp);
        }
    }

    public void stop() {
        this.stop(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int threshold) {
        if (this.mark == null) {
            log.log(Level.WARNING, "Stop was called more than once", new RuntimeException("Stop was called more than once"));
            return;
        }
        if (this.enabled) {
            long timestamp = System.currentTimeMillis();
            DebugTimer debugTimer = this;
            synchronized (debugTimer) {
                int totalTime;
                boolean shouldLog = true;
                if (threshold >= 0 && threshold >= (totalTime = (int)(timestamp - this.timeMarks.get((int)0).startTime))) {
                    shouldLog = false;
                }
                if (shouldLog) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("  DebugTimer stopped on thread ").append(Thread.currentThread().getName()).append(CR);
                    for (TimeMark timeMark : this.timeMarks) {
                        timeMark.markTime(null, timestamp);
                        sb.append("    Thread ").append(timeMark.threadName).append(":").append(StringUtils.CR).append((CharSequence)timeMark.progressMessage).append(CR);
                    }
                    log.log(this.logLevel, sb.toString());
                }
            }
        }
        this.mark.remove();
        this.mark = null;
        DebugTimer debugTimer = this;
        synchronized (debugTimer) {
            this.stopped = true;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TimeMark timeMark : this.timeMarks) {
            sb.append("    Thread " + timeMark.threadName + ":" + StringUtils.CR + timeMark.progressMessage + CR);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try (DebugTimer testTimer = new DebugTimer("Counting to 5,000,000");){
            int counter;
            for (counter = 0; counter < 5000000; ++counter) {
            }
            testTimer.markTime("Counting to 100,000");
            for (counter = 0; counter < 100000; ++counter) {
            }
            testTimer.markTime("Counting  to 20,000,000");
            for (counter = 0; counter < 20000000; ++counter) {
            }
            testTimer.stop();
        }
    }

    static class TimeMark {
        private long startTime;
        private long currentTime;
        private long lastMark;
        private final StringBuilder progressMessage = new StringBuilder();
        private String lastMessage = null;
        private String threadName;

        TimeMark() {
        }

        void markTime(@Nullable String markMessage, long timestamp) {
            this.currentTime = timestamp;
            if (this.lastMessage != null) {
                long markTime = this.currentTime - this.lastMark;
                long totalTime = this.currentTime - this.startTime;
                this.progressMessage.append("        " + markTime + "ms / " + totalTime + "ms: " + this.lastMessage + CR);
            }
            this.lastMessage = markMessage;
            this.lastMark = this.currentTime;
        }

        public String toString() {
            return "TimeMark{startTime=" + this.startTime + ", currentTime=" + this.currentTime + ", lastMark=" + this.lastMark + ", progressMessage=" + this.progressMessage + ", lastMessage='" + this.lastMessage + "', threadName='" + this.threadName + "'}";
        }
    }
}

