/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtils {
    private static final Logger log = Logger.getLogger(EncryptionUtils.class.getName());
    private static final int ZERO_CHAR = 48;
    private static final int A_CHAR = 65;
    private static final int SPACE_CHAR = 32;

    public static byte[] md5digestForString(String input) {
        byte[] byArray;
        ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        try {
            byArray = EncryptionUtils.generateMD5Hash(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return byArray;
    }

    public static byte[] convertByteArrayToNewBase(byte[] bytes, short newBase) {
        BigInteger source = new BigInteger(1, bytes);
        BigInteger radix = new BigInteger(String.valueOf(newBase));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (!BigInteger.ZERO.equals(source)) {
            BigInteger[] tempResult = source.divideAndRemainder(radix);
            source = tempResult[0];
            out.write(tempResult[1].intValue());
        }
        byte[] reverseBytes = out.toByteArray();
        int length = reverseBytes.length;
        byte[] result = new byte[length];
        for (int n = 0; n < length; ++n) {
            result[length - n - 1] = reverseBytes[n];
        }
        return result;
    }

    public static String bytesToString(byte[] input, ByteConverter conversionMode) {
        byte[] rawData = EncryptionUtils.convertByteArrayToNewBase(input, conversionMode.characterRange());
        char[] result = new char[rawData.length];
        for (int n = 0; n < rawData.length; ++n) {
            result[n] = conversionMode.charForByte(rawData[n]);
        }
        return new String(result);
    }

    public static void main(String[] args) {
        byte[] testBytes = new byte[]{-96, -76, -1};
        System.out.println(EncryptionUtils.bytesToString(testBytes, new DigitConverter()));
    }

    public static String toHex(byte[] hash) {
        StringBuilder buf = new StringBuilder(hash.length * 2);
        for (byte element : hash) {
            int intVal = element & 0xFF;
            if (intVal < 16) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(intVal));
        }
        return buf.toString().toLowerCase();
    }

    public static byte[] fromHex(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    public static byte[] generateMD5Hash(byte[] input) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            log.warning("MD5 is a valid algorithm, so this exception should never be thrown.");
            throw new RuntimeException(e);
        }
        digest.update(input);
        byte[] hash = digest.digest();
        return hash;
    }

    public static byte[] generateMD5Hash(InputStream input) throws IOException {
        try {
            int length;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[65536];
            while ((length = input.read(buffer)) != -1) {
                digest.update(buffer, 0, length);
            }
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            log.warning("MD5 is a valid algorithm, so this exception should never be thrown.");
            throw new RuntimeException(e);
        }
    }

    public static byte[] generateSHA256Digest(InputStream byteStream) throws IOException {
        try {
            int bytesRead;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[65536];
            while ((bytesRead = byteStream.read(buffer)) != -1) {
                md.update(buffer, 0, bytesRead);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        finally {
            byteStream.close();
        }
    }

    public static byte[] HmacSHA256(byte[] data, byte[] key) {
        String algorithm = "HmacSHA256";
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface ByteConverter {
        public short characterRange();

        public char charForByte(byte var1);
    }

    public static class DigitConverter
    implements ByteConverter {
        @Override
        public short characterRange() {
            return 10;
        }

        @Override
        public char charForByte(byte input) {
            return (char)(48 + input);
        }
    }

    public static class PrintableAsciiConverter
    implements ByteConverter {
        @Override
        public short characterRange() {
            return 95;
        }

        @Override
        public char charForByte(byte input) {
            return (char)(32 + input);
        }
    }

    public static class UpperLowerDigitConverter
    implements ByteConverter {
        @Override
        public short characterRange() {
            return 62;
        }

        @Override
        public char charForByte(byte input) {
            int result = 48 + input;
            if (input > 36) {
                result += 13;
            } else if (input > 10) {
                result += 7;
            }
            return (char)result;
        }
    }

    public static class UpperLowercaseConverter
    implements ByteConverter {
        @Override
        public short characterRange() {
            return 52;
        }

        @Override
        public char charForByte(byte input) {
            int result = 65 + input;
            if (input > 26) {
                result += 6;
            }
            return (char)result;
        }
    }

    public static class UppercaseConverter
    implements ByteConverter {
        @Override
        public short characterRange() {
            return 26;
        }

        @Override
        public char charForByte(byte input) {
            return (char)(65 + input);
        }
    }
}

