/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.net;

import com.prosc.infrastructure.LogUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalhostLookup {
    private static final Logger log = Logger.getLogger(LocalhostLookup.class.getName());

    public static String getLocalhostName() {
        String result = null;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            result = localhost.getHostName();
            log.info("localhost.getHostName() is " + result);
            if (result.indexOf(46) == -1) {
                result = null;
            }
            if (result == null) {
                result = localhost.getCanonicalHostName();
                log.info("localhost.getCanonicalHostName() is " + result);
            }
            if (result.indexOf(46) == -1) {
                result = LogUtils.getExternalAddress(false);
                log.info("External IP address is " + result);
                String[] octets = result.split("\\.");
                if (octets.length == 4) {
                    byte[] ipAddressBytes = new byte[4];
                    for (int n = 0; n < 4; ++n) {
                        int i = Integer.parseInt(octets[n]);
                        ipAddressBytes[n] = (byte)(i <= 128 ? i : i - 256);
                    }
                    result = InetAddress.getByAddress(ipAddressBytes).getCanonicalHostName();
                    log.info("Reverse DNS lookup is " + result);
                }
            }
        }
        catch (UnknownHostException e) {
            log.log(Level.WARNING, "Could not get localhost address", e);
        }
        if (result == null) {
            log.warning("Could not determine real address for local machine, using 'localhost'");
            result = "localhost";
        }
        return result;
    }
}

