/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public abstract class TimedCollection<E>
implements Collection<E> {
    private static final Logger log = Logger.getLogger(TimedCollection.class.getName());
    private final Collection<E> delegate;
    private final LinkedHashMap<E, Long> triggers = new LinkedHashMap();
    private final long triggerTime;
    private final TriggerThread triggerThread;

    public TimedCollection(Collection<E> delegate, long triggerTime) {
        this.delegate = delegate;
        this.triggerTime = triggerTime;
        this.triggerThread = new TriggerThread();
        this.triggerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E o) {
        boolean result = this.delegate.add(o);
        long newTrigger = System.currentTimeMillis() + this.triggerTime;
        LinkedHashMap<E, Long> linkedHashMap = this.triggers;
        synchronized (linkedHashMap) {
            this.triggers.put(o, newTrigger);
        }
        this.triggersChanged();
        return result;
    }

    public abstract void onTrigger(E var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        boolean result = this.delegate.remove(o);
        LinkedHashMap<E, Long> linkedHashMap = this.triggers;
        synchronized (linkedHashMap) {
            if (this.triggers.remove(o) != null) {
                this.triggersChanged();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = this.delegate.addAll(c);
        long newTrigger = System.currentTimeMillis() + this.triggerTime;
        LinkedHashMap<E, Long> linkedHashMap = this.triggers;
        synchronized (linkedHashMap) {
            for (E o : c) {
                this.triggers.put(o, newTrigger);
            }
        }
        this.triggersChanged();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.delegate.removeAll(c);
        LinkedHashMap<E, Long> linkedHashMap = this.triggers;
        synchronized (linkedHashMap) {
            for (Object o : c) {
                this.triggers.remove(o);
            }
        }
        this.triggersChanged();
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.delegate.clear();
        LinkedHashMap<E, Long> linkedHashMap = this.triggers;
        synchronized (linkedHashMap) {
            this.triggers.clear();
        }
        this.triggersChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggersChanged() {
        LinkedHashMap<E, Long> linkedHashMap = this.triggers;
        synchronized (linkedHashMap) {
            this.triggers.notifyAll();
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    private class TriggerThread
    extends Thread {
        public TriggerThread() {
            super("TimedCollection trigger thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LinkedHashMap linkedHashMap = TimedCollection.this.triggers;
                synchronized (linkedHashMap) {
                    while (!Thread.currentThread().isInterrupted()) {
                        Iterator it = TimedCollection.this.triggers.entrySet().iterator();
                        if (it.hasNext()) {
                            Map.Entry firstEntry = it.next();
                            long firstTrigger = firstEntry.getValue();
                            long timeToWait = firstTrigger - System.currentTimeMillis();
                            if (timeToWait > 0L) {
                                TimedCollection.this.triggers.wait(timeToWait);
                                continue;
                            }
                            TimedCollection.this.onTrigger(firstEntry.getKey());
                            TimedCollection.this.triggers.remove(firstEntry.getKey());
                            continue;
                        }
                        TimedCollection.this.triggers.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.info("TimedCollection trigger thread was interrupted; exiting.");
            }
        }
    }
}

