/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class JarUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getJarSize(File whichFile) throws IOException {
        byte[] END_OF_FILE = JarUtils.int2bytes(101010256);
        int directoryBufferSize = 65558;
        if ((long)directoryBufferSize > whichFile.length()) {
            directoryBufferSize = (int)whichFile.length();
        }
        byte[] directoryBuffer = new byte[directoryBufferSize];
        long pos = whichFile.length() - (long)directoryBuffer.length;
        int fileOffset = 0;
        try (FileInputStream fileIn = new FileInputStream(whichFile);){
            while ((long)fileOffset < pos) {
                fileOffset = (int)((long)fileOffset + fileIn.skip(pos - (long)fileOffset));
            }
            for (int bytesRead = 0; bytesRead < directoryBuffer.length; bytesRead += fileIn.read(directoryBuffer, bytesRead, directoryBuffer.length - bytesRead)) {
            }
        }
        for (int n = directoryBufferSize - 4; n >= 0; --n) {
            if (directoryBuffer[n] != END_OF_FILE[3] || directoryBuffer[n + 1] != END_OF_FILE[2] || directoryBuffer[n + 2] != END_OF_FILE[1] || directoryBuffer[n + 3] != END_OF_FILE[0]) continue;
            int recordLength = (int)whichFile.length() - fileOffset - n;
            byte[] archiveDirectory = new byte[recordLength];
            System.arraycopy(directoryBuffer, n, archiveDirectory, 0, recordLength);
            int directorySize = JarUtils.bytes2int(archiveDirectory[15], archiveDirectory[14], archiveDirectory[13], archiveDirectory[12]);
            int offsetToEntryDirectoryStart = JarUtils.bytes2int(archiveDirectory[19], archiveDirectory[18], archiveDirectory[17], archiveDirectory[16]);
            return recordLength + directorySize + offsetToEntryDirectoryStart;
        }
        throw new RuntimeException("getJarSize failed, could not find zip file signature");
    }

    private static byte[] int2bytes(int input) {
        return new byte[]{(byte)(input >> 24), (byte)(input >> 16), (byte)(input >> 8), (byte)input};
    }

    private static int bytes2int(byte input0, byte input1, byte input2, byte input3) {
        int result = ((0xFF & input0) << 24) + ((0xFF & input1) << 16) + ((0xFF & input2) << 8) + (0xFF & input3);
        return result;
    }

    public static Collection<X509Certificate> verifyJar(File jarFile, boolean onlyTrusted) throws IOException, GeneralSecurityException {
        return JarUtils.verifyJar(new JarInputStream((InputStream)new FileInputStream(jarFile), true), onlyTrusted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<X509Certificate> verifyJar(JarInputStream jarStream, boolean onlyTrusted) throws IOException, GeneralSecurityException {
        try {
            JarEntry eachEntry;
            HashSet<X509Certificate> result = new HashSet<X509Certificate>();
            HashMap<String, PublicKey> publicKeysByIssuerName = new HashMap<String, PublicKey>();
            if (onlyTrusted) {
                try {
                    KeyStore cacerts = KeyStore.getInstance(KeyStore.getDefaultType());
                    File cacertsFile = new File(System.getProperty("java.home"), "lib" + File.separator + "security" + File.separator + "cacerts");
                    try (FileInputStream fileIn = new FileInputStream(cacertsFile);){
                        cacerts.load(fileIn, null);
                    }
                    Enumeration<String> en = cacerts.aliases();
                    while (en.hasMoreElements()) {
                        String alias = en.nextElement();
                        X509Certificate caCert = (X509Certificate)cacerts.getCertificate(alias);
                        publicKeysByIssuerName.put(caCert.getIssuerDN().getName(), caCert.getPublicKey());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not get list of trusted certificate issuers: " + e.toString(), e);
                }
            }
            byte[] buffer = new byte[8192];
            Map.Entry trustedCert = null;
            while ((eachEntry = jarStream.getNextJarEntry()) != null) {
                if (eachEntry.isDirectory()) continue;
                try {
                    while (jarStream.read(buffer, 0, buffer.length) != -1) {
                    }
                    Certificate[] certs = eachEntry.getCertificates();
                    if (eachEntry.getName().startsWith("META-INF")) continue;
                    if (certs == null || certs.length == 0) {
                        throw new CertificateException("The jar file contains one or more unsigned class files. First unsigned class is " + eachEntry.getName());
                    }
                    if (onlyTrusted) {
                        X509Certificate endOfChain = (X509Certificate)certs[certs.length - 1];
                        String issuer = endOfChain.getIssuerDN().getName();
                        if (trustedCert == null || !((String)trustedCert.getKey()).equals(issuer)) {
                            trustedCert = null;
                            for (Map.Entry keyEntry : publicKeysByIssuerName.entrySet()) {
                                if (!((String)keyEntry.getKey()).equals(issuer)) continue;
                                trustedCert = keyEntry;
                                break;
                            }
                            if (trustedCert == null) {
                                throw new CertificateException("This certificate was not signed by a trusted CA certificate");
                            }
                        }
                        endOfChain.verify((PublicKey)trustedCert.getValue());
                    }
                    result.add((X509Certificate)certs[0]);
                }
                finally {
                    jarStream.closeEntry();
                }
            }
            HashSet<X509Certificate> hashSet = result;
            return hashSet;
        }
        finally {
            jarStream.close();
        }
    }
}

