/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.office.xlsx;

import com.prosc.io.IOUtils;
import com.prosc.misc.office.xlsx.FlatColumn;
import com.prosc.misc.office.xlsx.IColumn;
import com.prosc.misc.office.xlsx.ReferenceColumn;
import com.prosc.misc.office.xlsx.Row;
import com.prosc.misc.office.xlsx.Sheet;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XLSXReader
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(XLSXReader.class.getName());
    private static final Pattern NUMERIC = Pattern.compile("^[\\-0-9.eE]+$");
    private final ZipInputStream stream;
    private SAXParserFactory factory;
    private ArrayList<String> sharedStrings = new ArrayList();
    private List<Sheet> sheets = new ArrayList<Sheet>();
    private transient boolean didRead;
    private Map<Integer, String> sheetNamesByNumber = new HashMap<Integer, String>(3);

    public XLSXReader(ZipInputStream stream) throws FileNotFoundException {
        this.stream = stream;
        this.factory = SAXParserFactory.newInstance();
        this.factory.setValidating(false);
    }

    public List<Sheet> getSheets() throws IOException {
        if (!this.didRead) {
            try {
                this._read();
                Collections.sort(this.sheets);
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e);
            }
        }
        return this.sheets;
    }

    private void _read() throws IOException, SAXException, ParserConfigurationException {
        ZipEntry eachEntry;
        Pattern sheetPattern = Pattern.compile("^xl/worksheets/sheet([0-9]+)\\.xml$");
        while ((eachEntry = this.stream.getNextEntry()) != null) {
            if (eachEntry.getName().equals("xl/sharedStrings.xml")) {
                this._parseSharedStrings();
                continue;
            }
            if (eachEntry.getName().equals("xl/workbook.xml")) {
                this._parseWorkbookXml();
                continue;
            }
            Matcher sheetMatcher = sheetPattern.matcher(eachEntry.getName());
            if (!sheetMatcher.find()) continue;
            this._parseSheet(Integer.parseInt(sheetMatcher.group(1)));
        }
        this.didRead = true;
    }

    private void _parseWorkbookXml() throws IOException, SAXException, ParserConfigurationException {
        this.parseXML(new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equals("sheet")) {
                    String sheetName = attributes.getValue("name");
                    String sheetId = attributes.getValue("sheetId");
                    XLSXReader.this.sheetNamesByNumber.put(Integer.parseInt(sheetId), sheetName);
                }
            }
        });
    }

    private void _parseSheet(int sheetNumber) throws SAXException, ParserConfigurationException, IOException {
        final ArrayList<Row> rows = new ArrayList<Row>();
        final ArrayList columns = new ArrayList();
        this.parseXML(new DefaultHandler(){
            public IColumn columnValue;
            public String columnType;
            public long columnStyle;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if ("c".equals(qName)) {
                    this.columnType = attributes.getValue("t");
                    String styleValue = attributes.getValue("s");
                    long l = this.columnStyle = styleValue == null ? 0L : Long.parseLong(styleValue);
                    if (this.columnType == null) {
                        this.columnType = "";
                    }
                    this.columnValue = null;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.columnType != null) {
                    String v = new String(ch, start, length);
                    this.columnValue = "s".equals(this.columnType) ? new ReferenceColumn(XLSXReader.this.sharedStrings, Integer.parseInt(v)) : ("str".equals(this.columnType) ? new FlatColumn(v) : new FlatColumn(this.objectFor(v, this.columnStyle)));
                }
            }

            private Object objectFor(String v, long columnStyle) {
                if (v == null || v.isEmpty()) {
                    return null;
                }
                switch ((int)columnStyle) {
                    case 37: {
                        return Integer.valueOf(v);
                    }
                    case 38: {
                        return Integer.valueOf(v);
                    }
                }
                if (NUMERIC.matcher(v).matches()) {
                    try {
                        return new BigDecimal(v);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Could not parse '" + v + "' as BigDecimal", e);
                    }
                }
                return v;
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if ("row".equals(qName)) {
                    rows.add(new Row(new ArrayList<IColumn>(columns)));
                    columns.clear();
                } else if ("c".equals(qName)) {
                    this.columnType = null;
                    columns.add(this.columnValue == null ? new FlatColumn(null) : this.columnValue);
                }
            }
        });
        this.sheets.add(new Sheet(this.sheetNamesByNumber.get(sheetNumber), rows, sheetNumber));
    }

    private void _parseSharedStrings() throws SAXException, ParserConfigurationException, IOException {
        this.parseXML(new DefaultHandler(){
            StringBuilder tmpString = new StringBuilder();

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                this.tmpString.append(ch, start, length);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if ("si".equals(qName)) {
                    XLSXReader.this.sharedStrings.add(this.tmpString.toString());
                    this.tmpString.setLength(0);
                }
            }
        });
    }

    private void parseXML(DefaultHandler t) throws IOException, SAXException, ParserConfigurationException {
        SAXParser saxParser = this.factory.newSAXParser();
        saxParser.parse((InputStream)new FilterInputStream(this.stream){

            @Override
            public void close() throws IOException {
                log.log(Level.FINE, "Not closing");
            }
        }, t);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly(this.stream);
    }
}

