/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.io;

import com.prosc.misc.io.FileDescription;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class DirectoryLister
implements Serializable {
    private boolean filterInvisibles = false;
    private String filterSuffix = null;
    private List dirList = new Vector(1);
    private String rootDirectory = "";
    private FilenameFilter fileFilter = null;
    private List files;
    private List fileNames;
    private List fileDescriptions;
    private boolean needs_scan;

    public DirectoryLister() {
        this.dirList.add("");
        this.needs_scan = true;
    }

    public void scan() {
        if (this.fileFilter == null && (this.filterInvisibles || this.filterSuffix != null)) {
            this.fileFilter = new CustomNameFilter(this.filterInvisibles, this.filterSuffix);
        }
        this.files = new Vector();
        this.fileNames = new Vector();
        this.fileDescriptions = new Vector();
        for (String subfolder : this.dirList) {
            File[] fileArray = new File(this.rootDirectory + subfolder).listFiles(this.fileFilter);
            if (fileArray == null) continue;
            for (int n = 0; n < fileArray.length; ++n) {
                this.fileDescriptions.add(new FileDescription(fileArray[n], subfolder));
                this.files.add(fileArray[n]);
                this.fileNames.add(fileArray[n].getName());
            }
        }
        this.needs_scan = false;
    }

    public boolean filterInvisibles() {
        return this.filterInvisibles;
    }

    public void setFilterInvisibles(boolean input) {
        this.filterInvisibles = input;
        this.needs_scan = true;
    }

    public String filterSuffix() {
        return this.filterSuffix;
    }

    public void setFilterSuffix(String input) {
        this.filterSuffix = input;
        this.needs_scan = true;
    }

    public String rootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(String input) {
        this.rootDirectory = input;
        this.needs_scan = true;
    }

    public List dirList() {
        return this.dirList;
    }

    public void setDirList(List input) {
        this.dirList = input;
        this.needs_scan = true;
    }

    public List files() {
        if (this.needs_scan) {
            this.scan();
        }
        return this.files;
    }

    public List fileNames() {
        if (this.needs_scan) {
            this.scan();
        }
        return this.fileNames;
    }

    public List fileDescriptions() {
        if (this.needs_scan) {
            this.scan();
        }
        return this.fileDescriptions;
    }

    private static class CustomNameFilter
    implements FileFilter,
    FilenameFilter,
    Serializable {
        boolean stripInvisibles = false;
        String suffixFilter = null;
        boolean hasSuffix = false;

        public CustomNameFilter(boolean stripInvisibles, String suffixFilter) {
            this.stripInvisibles = stripInvisibles;
            if (suffixFilter != null) {
                this.suffixFilter = suffixFilter.toLowerCase();
                this.hasSuffix = true;
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.stripInvisibles && name.charAt(0) == '.') {
                return false;
            }
            if (this.hasSuffix) {
                return name.toLowerCase().endsWith(this.suffixFilter);
            }
            return true;
        }

        @Override
        public boolean accept(File pathname) {
            return this.accept(pathname.getParentFile(), pathname.getName());
        }
    }
}

