/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CompressionUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZip(ZipInputStream zipStream, File destinationDirectory) throws IOException {
        ZipEntry eachEntry;
        while ((eachEntry = zipStream.getNextEntry()) != null) {
            File theFile = new File(destinationDirectory, eachEntry.getName());
            if (eachEntry.isDirectory()) {
                theFile.mkdirs();
                continue;
            }
            File parentFile = theFile.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new IOException("Could not create directory: " + parentFile);
            }
            try (FileOutputStream out = new FileOutputStream(theFile);){
                CompressionUtils.writeInputToOutput(zipStream, out);
            }
        }
    }

    private static void writeInputToOutput(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }
}

