/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.infrastructure;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class VersionItem
implements Comparable<VersionItem> {
    private String versionString;
    private float versionNumber;
    private String description;
    private Date versionDate;
    protected static final Format dateFormat = new SimpleDateFormat("M/d/y");
    private int updateExecutionOrder;
    public static final int DO_UPDATE_FIRST = 0;
    public static final int DO_UPDATE_LAST = 100;
    public static final int DO_UPDATE_MIDDLE = 50;

    public VersionItem(String versionString, float versionNumber, Calendar versionDate, String description) {
        this(versionString, versionNumber, versionDate.getTime(), description);
    }

    public VersionItem(String versionString, float versionNumber, Date versionDate, String description) {
        this(versionString, versionNumber, versionDate, description, 50);
    }

    public VersionItem(String versionString, float versionNumber, Date versionDate, String description, int updateExecutionOrder) {
        System.out.println("Instantiating version " + versionString);
        this.versionString = versionString;
        this.versionNumber = versionNumber;
        this.versionDate = versionDate;
        this.description = description;
        this.updateExecutionOrder = updateExecutionOrder;
    }

    public void doUpdate() throws Exception {
    }

    public String getVersionString() {
        return this.versionString;
    }

    public float getVersionNumber() {
        return this.versionNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getVersionDate() {
        return this.versionDate;
    }

    public String userPresentableDescription() {
        return this.getVersionString() + "; " + dateFormat.format(this.getVersionDate()) + " (" + this.getVersionNumber() + ") - " + this.getDescription();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionItem)) {
            return false;
        }
        return this.versionNumber != ((VersionItem)o).versionNumber;
    }

    public int hashCode() {
        return this.versionNumber != 0.0f ? Float.floatToIntBits(this.versionNumber) : 0;
    }

    @Override
    public int compareTo(@NotNull VersionItem otherVersionItem) {
        float difference;
        if (otherVersionItem == null) {
            VersionItem.$$$reportNull$$$0(0);
        }
        if ((difference = this.getVersionNumber() - otherVersionItem.getVersionNumber()) != 0.0f) {
            return difference > 0.0f ? 1 : -1;
        }
        return this.getVersionDate().compareTo(otherVersionItem.getVersionDate());
    }

    public String toString() {
        return this.getVersionString() + " (v" + this.getVersionNumber() + ")";
    }

    public int getUpdateExecutionOrder() {
        return this.updateExecutionOrder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherVersionItem", "com/prosc/misc/infrastructure/VersionItem", "compareTo"));
    }
}

