/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.infrastructure;

import com.prosc.shared.StringUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.NumberFormat;

public class ThreadDumpUtil {
    public static String dumpThreadStackTrace() {
        ThreadMXBean threadMX = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMX.dumpAllThreads(false, false);
        NumberFormat numberFormat = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append("isThreadContentionMonitoringSupported: " + threadMX.isThreadContentionMonitoringSupported() + " / isThreadContentionMonitoringEnabled: " + threadMX.isThreadContentionMonitoringEnabled() + "\n");
        String delim = "";
        for (ThreadInfo info : threadInfos) {
            sb.append(delim).append("ID: ").append(info.getThreadId()).append(" / state: ").append(info.getThreadState().name()).append(" / name: ").append(info.getThreadName()).append(StringUtils.CR);
            if (threadMX.isThreadContentionMonitoringSupported() && threadMX.isThreadContentionMonitoringEnabled()) {
                sb.append("Milliseconds spent waiting: " + numberFormat.format(info.getWaitedTime()) + " / blocked: " + numberFormat.format(info.getBlockedTime())).append(StringUtils.CR);
            }
            if (info.getThreadState() == Thread.State.BLOCKED) {
                sb.append("Currently waiting for lock " + info.getLockName() + " owned by " + info.getLockOwnerName() + " / thread ID " + info.getLockOwnerId() + "\n");
            }
            for (StackTraceElement traceElement : info.getStackTrace()) {
                sb.append("    " + traceElement.toString() + StringUtils.CR);
            }
            delim = StringUtils.CR;
        }
        return sb.toString();
    }
}

