/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.infrastructure;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.apache.commons.lang3.time.FastDateFormat;

public class SimpleFormatterThreadsafe
extends Formatter {
    FastDateFormat dateFormat = FastDateFormat.getDateInstance(2);
    FastDateFormat timeFormat = FastDateFormat.getTimeInstance(0);
    private static final String lineSeparator = AccessController.doPrivileged(() -> System.getProperty("line.separator"));

    public static void enableThreadsafeLogging() {
        LogManager manager = LogManager.getLogManager();
        ArrayList<String> loggerNames = Collections.list(manager.getLoggerNames());
        for (String loggerName : loggerNames) {
            for (Handler handler : manager.getLogger(loggerName).getHandlers()) {
                if (!(handler.getFormatter() instanceof SimpleFormatter)) continue;
                handler.setFormatter(new SimpleFormatterThreadsafe());
            }
        }
    }

    @Override
    public String format(LogRecord record) {
        Date date = new Date();
        String message = this.formatMessage(record);
        if (message == null) {
            message = "<No message>";
        }
        String stacktrace = null;
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                stacktrace = sw.toString();
            }
            catch (Exception sw) {
                // empty catch block
            }
        }
        StringBuilder text = new StringBuilder(message.length() + 300 + (stacktrace == null ? 0 : stacktrace.length()));
        text.append(this.dateFormat.format(date)).append(" ").append(this.timeFormat.format(date));
        text.append(" ");
        if (record.getSourceClassName() != null) {
            text.append(record.getSourceClassName());
        } else {
            text.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            text.append(" ");
            text.append(record.getSourceMethodName());
        }
        text.append(lineSeparator);
        text.append(record.getLevel().getLocalizedName());
        text.append(": ");
        text.append(message);
        message = null;
        text.append(lineSeparator);
        if (stacktrace != null) {
            text.append(stacktrace);
        }
        return text.toString();
    }
}

