/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.image;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class BigImage
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(BigImage.class.getName());
    Dimension tileSize = new Dimension(1024, 1024);
    final RandomAccessFile file;
    private String formatName;
    private int width;
    private int height;
    private ArrayList<Tile> tiles;
    private transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ImageReader reader;
    private String name;

    public BigImage(RandomAccessFile file, String name) throws IOException {
        this.file = file;
        this.name = name;
    }

    public BigImage(File input) throws IOException {
        this(new RandomAccessFile(input, "r"), input.getName());
    }

    private void _init() throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(this.file);
        this.formatName = this.name != null && this.name.toLowerCase().endsWith(".gif") ? "GIF" : (this.name != null && this.name.toLowerCase().endsWith(".png") ? "PNG" : "JPG");
        Iterator<ImageReader> allReaders = ImageIO.getImageReadersByFormatName(this.formatName);
        this.reader = allReaders.next();
        this.reader.setInput(iis);
        this.formatName = this.reader.getFormatName();
        this.width = this.reader.getWidth(0);
        this.height = this.reader.getHeight(0);
    }

    public int getTileCount() {
        return this.tiles == null ? 0 : this.tiles.size();
    }

    public int getWidth() throws IOException {
        this._init();
        return this.width;
    }

    public int getHeight() throws IOException {
        this._init();
        return this.height;
    }

    public String getFormatName() throws IOException {
        this._init();
        return this.formatName;
    }

    public Iterable<Tile> tiles() throws IOException {
        this._init();
        if (this.tiles == null) {
            this.tiles = new ArrayList();
            int row = 0;
            while (row * this.tileSize.height < this.height) {
                int col = 0;
                while (col * this.tileSize.width < this.width) {
                    Tile eachTile = new Tile(row, col);
                    this.tiles.add(eachTile);
                    ++col;
                }
                ++row;
            }
        }
        return this.tiles;
    }

    public BufferedImage scaledImage(Rectangle fullResBounds, float scale) throws IOException {
        if (scale <= 0.0f || scale > 1.0f) {
            throw new IllegalStateException("Invalid scale: " + scale);
        }
        this._init();
        BufferedImage result = new BufferedImage(Math.round((float)fullResBounds.width * scale), Math.round((float)fullResBounds.height * scale), 1);
        Graphics2D d = result.createGraphics();
        int xOffset = Math.round((float)fullResBounds.x * scale);
        int yOffset = Math.round((float)fullResBounds.y * scale);
        double scaledWidth = Math.ceil((double)this.tileSize.width * (double)scale);
        double scaledHeight = Math.ceil((double)this.tileSize.height * (double)scale);
        ArrayList<Tile> tilesUsedInRendering = new ArrayList<Tile>();
        for (Tile eachTile : this.tiles()) {
            if (!fullResBounds.intersects(eachTile.getBounds())) continue;
            tilesUsedInRendering.add(eachTile);
        }
        for (int i = 0; i < tilesUsedInRendering.size(); ++i) {
            Tile eachTile;
            eachTile = (Tile)tilesUsedInRendering.get(i);
            int eachX = Math.round((float)eachTile.getBounds().x * scale);
            int eachY = Math.round((float)eachTile.bounds.y * scale);
            d.drawImage(eachTile.getImage(), eachX - xOffset, eachY - yOffset, (int)scaledWidth, (int)scaledHeight, null);
            if (Thread.interrupted()) {
                throw new RuntimeException("Interrupted");
            }
            this.pcs.firePropertyChange("renderProgress", Float.valueOf((float)tilesUsedInRendering.size() / (float)i), Float.valueOf((float)tilesUsedInRendering.size() / (float)i + 1.0f));
        }
        d.dispose();
        return result;
    }

    @Override
    public void close() throws IOException {
        this.tiles = null;
        this.file.close();
    }

    public void setTileSize(Dimension tileSize) {
        if (this.tiles != null) {
            throw new IllegalStateException("You must set tile size before tiles are initialized");
        }
        this.tileSize = tileSize;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public class Tile {
        private final int row;
        private final int col;
        private final Rectangle bounds;
        SoftReference<BufferedImage> bufferedImageRef = new SoftReference<Object>(null);

        private Tile(int row, int col) {
            this.row = row;
            this.col = col;
            int x = col * BigImage.this.tileSize.width;
            int y = row * BigImage.this.tileSize.height;
            int rightEdge = Math.min(BigImage.this.width, x + BigImage.this.tileSize.width);
            int bottomEdge = Math.min(BigImage.this.height, y + BigImage.this.tileSize.height);
            this.bounds = new Rectangle(x, y, rightEdge - x, bottomEdge - y);
        }

        BufferedImage getImage() throws IOException {
            BufferedImage result = this.bufferedImageRef.get();
            if (result == null) {
                log.log(Level.INFO, "Reading " + this + " from master image");
                ImageReadParam param = BigImage.this.reader.getDefaultReadParam();
                Rectangle sourceRegion = new Rectangle(new Point(this.col * BigImage.this.tileSize.width, this.row * BigImage.this.tileSize.height), BigImage.this.tileSize);
                param.setSourceRegion(sourceRegion);
                result = BigImage.this.reader.read(0, param);
                this.bufferedImageRef = new SoftReference<BufferedImage>(result);
            }
            return result;
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public String toString() {
            return "Tile{bounds=" + this.bounds + ", row=" + this.row + ", col=" + this.col + "}";
        }
    }
}

