/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.regex.Pattern;

public class SmartHTMLFormatter
extends Format {
    private boolean doesConvertLineBreaks = true;
    private boolean doesConvertParagraphs = true;
    private static Pattern lineBreakToParagraphPattern = Pattern.compile("\n\r?[\n\r]+");
    private static Pattern lineBreakToBRPattern = Pattern.compile("([^>])[\n\r]");
    private boolean doesLinkifyEmailAddresses = true;
    private static Pattern emailAddressToMailtoPattern = Pattern.compile("([^:])([\\w\\.\\-]+@[\\w\\.\\-]+[\\w])");
    private boolean doesLinkifyURLs = true;
    private static Pattern wwwToHTTPPattern = Pattern.compile("([^/])www.");
    private String linkBodyReplacementPattern = "$3$4";
    private String linkTarget;
    private static Pattern httpToHyperlinkPattern = Pattern.compile("(^|\\G|[^\"'=])([a-z]{3,6}://)(\\w[\\w-.]+\\w)(/[\\w\\.\\-/\\_\\~:]+[\\w/])?([\\?\\#][\\w&;#=%]*)?([,. <\n\r\t]?([ <\n\r\t]|\\z))");

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        Object out = (String)obj;
        if (out == null || ((String)out).length() == 0) {
            return toAppendTo;
        }
        if (this.doesLinkifyEmailAddresses) {
            out = emailAddressToMailtoPattern.matcher((CharSequence)out).replaceAll("$1<a href=\"mailto:$2\">$2</a>");
        }
        if (this.doesConvertParagraphs) {
            out = "<p>" + lineBreakToParagraphPattern.matcher((CharSequence)out).replaceAll("</p>\n<p>") + "</p>";
        }
        if (this.doesConvertLineBreaks) {
            out = this.doesConvertParagraphs ? lineBreakToBRPattern.matcher((CharSequence)out).replaceAll("$1<br />\n") : ((String)out).replaceAll("\n", "<br />\n");
        }
        if (this.doesLinkifyURLs) {
            out = wwwToHTTPPattern.matcher((CharSequence)out).replaceAll("$1http://www.");
            StringBuffer replacePattern = new StringBuffer("$1<a href=\"$2$3$4$5\" title=\"$2$3$4$5\"");
            if (this.linkTarget != null) {
                replacePattern.append(" target=\"").append(SmartHTMLFormatter.quoteReplaceString(this.linkTarget)).append("\"");
            }
            replacePattern.append(">").append(this.linkBodyReplacementPattern).append("</a>$6");
            out = httpToHyperlinkPattern.matcher((CharSequence)out).replaceAll(replacePattern.toString());
        }
        out = ((String)out).replaceAll("<([^/a-zA-Z])", "&lt;$1");
        return toAppendTo.append((String)out);
    }

    private static String quoteReplaceString(String s) {
        return s.replaceAll("\\$", "\\\\\\$");
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("ParsePosition was null.");
        }
        return null;
    }

    public boolean doesConvertLineBreaks() {
        return this.doesConvertLineBreaks;
    }

    public void setDoesConvertParagraphs(boolean doesConvertParagraphs) {
        this.doesConvertParagraphs = doesConvertParagraphs;
    }

    public boolean doesConvertParagraphs() {
        return this.doesConvertParagraphs;
    }

    public void setDoesConvertLineBreaks(boolean doesConvertLineBreaks) {
        this.doesConvertLineBreaks = doesConvertLineBreaks;
    }

    public boolean doesLinkifyEmailAddresses() {
        return this.doesLinkifyEmailAddresses;
    }

    public void setDoesLinkifyEmailAddresses(boolean doesLinkifyEmailAddresses) {
        this.doesLinkifyEmailAddresses = doesLinkifyEmailAddresses;
    }

    public boolean doesLinkifyURLs() {
        return this.doesLinkifyURLs;
    }

    public void setDoesLinkifyURLs(boolean doesLinkifyURLs) {
        this.doesLinkifyURLs = doesLinkifyURLs;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkTarget(String linkTarget) {
        this.linkTarget = linkTarget;
    }

    public static void main(String[] args) {
        SmartHTMLFormatter instance = new SmartHTMLFormatter();
        instance.setLinkTarget("_new");
        String text = "This is some HTML text.\n\nThis is a new paragraph.\nA line break.\n\nThis has a link in it to www.slashdot.org.  And an email address: sam@yahoo.com.\n\nAnother link: http://mysite.com/test.php?index=123&that=the_other.\n\nbye.Were <em>you</em> aware that a < b?  Me neither...\n\nAlso visit www.cnn.com\nthis\nis\nthe\nend.";
        String out = instance.format(text);
        System.out.println(out);
    }

    public String getLinkBodyReplacementPattern() {
        return this.linkBodyReplacementPattern;
    }

    public void setLinkBodyReplacementPattern(String linkBodyReplacementPattern) {
        this.linkBodyReplacementPattern = linkBodyReplacementPattern;
    }
}

