/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;

public class HTMLFormatter
extends Format {
    private int appendIndex;
    private int parseIndex;
    private StringBuffer _parseBuffer;
    private String _parseInput;
    private String _parseCode;

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null || obj.toString().length() == 0) {
            return new StringBuffer();
        }
        if (!(obj instanceof String)) {
            obj = obj.toString();
        }
        int size = ((String)obj).length();
        toAppendTo.ensureCapacity(size + size / 50);
        char[] charArray = ((String)obj).toCharArray();
        block14: for (int index = 0; index < size; ++index) {
            char currentChar = charArray[index];
            switch (currentChar) {
                case '<': {
                    toAppendTo.append("&lt;");
                    continue block14;
                }
                case '>': {
                    toAppendTo.append("&gt;");
                    continue block14;
                }
                default: {
                    if (currentChar > '\u001f' && currentChar < '\u0080') {
                        toAppendTo.append(currentChar);
                        continue block14;
                    }
                    switch (currentChar) {
                        case '\n': 
                        case '\r': {
                            toAppendTo.append("<br>");
                            toAppendTo.append(currentChar);
                            continue block14;
                        }
                        case '\u2022': {
                            toAppendTo.append("&#149;");
                            continue block14;
                        }
                        case '\u2018': {
                            toAppendTo.append("&lsquo;");
                            continue block14;
                        }
                        case '\u2019': {
                            toAppendTo.append("&rsquo;");
                            continue block14;
                        }
                        case '\u201c': {
                            toAppendTo.append("&ldquo;");
                            continue block14;
                        }
                        case '\u201d': {
                            toAppendTo.append("&rdquo;");
                            continue block14;
                        }
                        case '\u2014': {
                            toAppendTo.append("&mdash;");
                            continue block14;
                        }
                        case '\"': {
                            toAppendTo.append("&quot;");
                            continue block14;
                        }
                    }
                    toAppendTo.append(currentChar);
                }
            }
        }
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition status) {
        if (source == null) {
            return null;
        }
        this._parseInput = source;
        this._parseBuffer = new StringBuffer(source.length());
        this.appendIndex = 0;
        char[] chars = source.toCharArray();
        int lastAmp = -1;
        int lastLT = -1;
        this.parseIndex = 0;
        while (this.parseIndex < source.length()) {
            switch (chars[this.parseIndex]) {
                case '&': {
                    lastAmp = this.parseIndex;
                    lastLT = -1;
                    break;
                }
                case ';': {
                    if (lastAmp >= 0 && this.parseIndex - lastAmp < 8) {
                        this._parseCode = source.substring(lastAmp + 1, this.parseIndex);
                        if (this._parseCode.equals("gt")) {
                            this.didParseChar(62);
                        } else if (this._parseCode.equals("lt")) {
                            this.didParseChar(60);
                        } else if (this._parseCode.equals("#149")) {
                            this.didParseChar(8226);
                        } else if (this._parseCode.equals("&lsquo")) {
                            this.didParseChar(8216);
                        } else if (this._parseCode.equals("rsquo")) {
                            this.didParseChar(8217);
                        } else if (this._parseCode.equals("ldquo")) {
                            this.didParseChar(8220);
                        } else if (this._parseCode.equals("rdquo")) {
                            this.didParseChar(8221);
                        } else if (this._parseCode.equals("mdash")) {
                            this.didParseChar(8212);
                        }
                    }
                    lastAmp = -1;
                    break;
                }
                case '<': {
                    lastLT = this.parseIndex;
                    lastAmp = -1;
                    break;
                }
                case '>': {
                    if (lastLT >= 0 && this.parseIndex - lastLT < 7) {
                        this._parseCode = source.substring(lastLT + 1, this.parseIndex);
                        if (this._parseCode.equals("br")) {
                            this._parseBuffer.append(this._parseInput.substring(this.appendIndex, lastLT));
                            this.appendIndex = this.parseIndex + 1;
                        }
                    }
                    lastLT = -1;
                }
            }
            ++this.parseIndex;
        }
        this._parseBuffer.append(this._parseInput.substring(this.appendIndex, this.parseIndex));
        return this._parseBuffer.toString();
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        return this.parseObject(source, null);
    }

    private void didParseChar(int parsed) {
        this._parseBuffer.append(this._parseInput.substring(this.appendIndex, this.parseIndex - 1 - this._parseCode.length()));
        this._parseBuffer.append((char)parsed);
        this.appendIndex = this.parseIndex + 1;
    }
}

