/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client.network;

import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.License;
import com.prosc.license.client.Registration;
import com.prosc.license.client.network.LicenseParams;
import com.prosc.license.client.network.OfflineModel;
import com.prosc.license.client.network.OnlineModel;
import com.prosc.shared.StringUtils;
import com.prosc.thread.TimeoutTask;
import com.prosc.util.PropertiesHolder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.Nullable;

public class LicensePluginModel {
    private static final Logger log = Logger.getLogger(LicensePluginModel.class.getName());
    private static final Map<Integer, Long> offlineOrderIds = new HashMap<Integer, Long>();
    private final LicenseParams params;
    private KeepAliveThread _keepAliveThread;
    private String sessionId;
    private volatile int heartbeat = 0;
    private final Object heartbeatLock = new Object();
    private OnlineModel onlineModel;
    private final PropertiesHolder props;
    private Short productCode;
    private static LicensePluginModel sharedModel = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LicensePluginModel getLicensePluginModel(LicenseParams params, PropertiesHolder props) {
        Class<LicensePluginModel> clazz = LicensePluginModel.class;
        synchronized (LicensePluginModel.class) {
            if (sharedModel != null && !LicensePluginModel.sharedModel.params.equals(params)) {
                sharedModel.close(6000);
                sharedModel = null;
            }
            if (sharedModel == null) {
                sharedModel = new LicensePluginModel(params, props);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sharedModel;
        }
    }

    public static LicensePluginModel getLicensePluginModel(LicenseParams params, String packageName) throws BackingStoreException {
        return LicensePluginModel.getLicensePluginModel(params, new PropertiesHolder(Preferences.userRoot().node(packageName)));
    }

    private LicensePluginModel(LicenseParams params, PropertiesHolder props) {
        this.props = props;
        this.params = params;
        log.info("Creating new OnlineModel for LicensePluginModel " + System.identityHashCode(this));
        this.onlineModel = new OnlineModel(params);
        try {
            this.productCode = params.registration.getStoreNumber();
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Couldn't get productId from params: " + params, e);
        }
    }

    public String checkLicense() throws InvalidLicenseException {
        log.info("Checking license key: " + this.params.registration.getLicenseKey() + " / registered to: " + this.params.registration.getCompanyName());
        if (this.params.registration.isDemo()) {
            return "demo";
        }
        License unverifiedLicense = this.params.registration.getLicense(false);
        Integer orderId = unverifiedLicense.getOrderID();
        if (offlineOrderIds.containsKey((int)orderId)) {
            log.log(Level.INFO, orderId + " is set to use offline verification");
            this.sessionId = UUID.randomUUID().toString();
            Long replacementMaxReleaseDate = offlineOrderIds.get((int)orderId);
            if (replacementMaxReleaseDate != null) {
                License replacementLicense = new License(unverifiedLicense.getOrderID(), unverifiedLicense.getProductCode(), unverifiedLicense.getVersion(), unverifiedLicense.getVariant(), unverifiedLicense.getOrderDate(), unverifiedLicense.getExpirationDate(), replacementMaxReleaseDate, unverifiedLicense.getEncryptedKey(), unverifiedLicense.getRegisteredTo());
                this.params.registration.setCachedLicense(replacementLicense);
            }
            this.params.registration.checkLicense();
        } else {
            log.fine("Online license verification for orderId " + orderId);
            if (this.sessionId == null) {
                try {
                    this.checkLicenseOnServer();
                }
                catch (IOException e) {
                    log.log(Level.INFO, "Online server access failed; will do an offline check instead: " + e, e);
                    try {
                        this.sessionId = this.checkOffline();
                    }
                    catch (InvalidLicenseException e1) {
                        e1.setPossibleToRetry(true);
                        throw e1;
                    }
                }
            }
            if (this.params.keepConnectionOpen) {
                this.getLicenseThread();
            }
            if (!StringUtils.isEmpty(this.onlineModel.getLicenseKey())) {
                this.params.registration.setLicenseKey(this.onlineModel.getLicenseKey());
            }
            this.params.registration.checkLicense();
        }
        return this.sessionId;
    }

    private void checkLicenseOnServer() throws IOException, InvalidLicenseException {
        this.sessionId = this.onlineModel.contactServer(this.sessionId);
        this.heartbeat = this.onlineModel.getHeartbeat();
        OfflineModel offlineModel = new OfflineModel(this.params, this.props);
        try {
            offlineModel.cacheLicense(this.onlineModel.getLicenseKey());
        }
        catch (BackingStoreException e) {
            log.log(Level.SEVERE, "Could not cache license key to disk", e);
        }
        try {
            offlineModel.checkRegistration(this.params.requireNetworkOnActivation);
        }
        catch (InvalidLicenseException e) {
            this.onlineModel.sendServerDisconnect(this.sessionId);
            throw e;
        }
    }

    public String getLastResponse() {
        return this.onlineModel.getLastResponse();
    }

    private String checkOffline() throws InvalidLicenseException {
        OfflineModel offlineModel = new OfflineModel(this.params, this.props);
        offlineModel.checkRegistration(this.params.requireNetworkOnActivation);
        String sessionId = UUID.randomUUID().toString();
        this.heartbeat = 60000;
        return sessionId;
    }

    public void close(final int closeWaitTime) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!LicensePluginModel.this.shutdownLicenseThread(closeWaitTime)) {
                    LicensePluginModel.this.sendServerDisconnect(LicensePluginModel.this.sessionId);
                }
            }
        };
        log.info("Closing LicensePluginModel with timeout " + closeWaitTime);
        if (closeWaitTime == 0) {
            new Thread(runnable, "Close license server connection").start();
        } else {
            try {
                new TimeoutTask().doWithTimeout(runnable, closeWaitTime, "Close license server connection");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.log(Level.INFO, "Thread was interrupted while waiting for license server disconnection");
            }
            catch (TimeoutException e) {
                log.log(Level.INFO, "Thread timed out while waiting for license server disconnection");
            }
        }
        if (this.onlineModel != null) {
            this.onlineModel.close(null);
        }
    }

    private void sendServerDisconnect(String sessionId) {
        if (sessionId != null && !"demo".equals(sessionId)) {
            this.onlineModel.sendServerDisconnect(sessionId);
        }
    }

    private void setHeartAttack(@Nullable InvalidLicenseException heartAttack) {
        this.params.registration.storeLicenseError(heartAttack);
    }

    public Registration getRegistration() {
        return this.params.registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdate() throws IOException {
        if (!StringUtils.isEmpty(this.onlineModel.getLicenseKey())) {
            this.getLicenseThread();
            Object object = this.heartbeatLock;
            synchronized (object) {
                this.heartbeatLock.notifyAll();
                try {
                    this.heartbeatLock.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException("User canceled while waiting to update license limits");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeepAliveThread getLicenseThread() {
        Class<LicensePluginModel> clazz = LicensePluginModel.class;
        synchronized (LicensePluginModel.class) {
            if (this._keepAliveThread == null) {
                this._keepAliveThread = new KeepAliveThread();
                this._keepAliveThread.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._keepAliveThread;
        }
    }

    private boolean shutdownLicenseThread(int closeWaitTime) {
        if (this._keepAliveThread == null || !this._keepAliveThread.isAlive()) {
            return false;
        }
        this._keepAliveThread.interrupt();
        try {
            if (closeWaitTime < 0) {
                closeWaitTime = 0;
            }
            this._keepAliveThread.join(closeWaitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._keepAliveThread = null;
        return true;
    }

    public void registrationDidChange() {
        if (this.onlineModel != null) {
            this.onlineModel.close(this.sessionId);
        }
        log.info("Creating new OnlineModel because registration did change");
        this.onlineModel = new OnlineModel(this.params);
        this.sessionId = null;
    }

    public static void addOfflineOrderId(Integer offlineOrderId) {
        LicensePluginModel.addOfflineOrderId(offlineOrderId, null);
    }

    public static void addOfflineOrderId(Integer offlineOrderId, @Nullable Long replacementMaxReleaseDate) {
        offlineOrderIds.put(offlineOrderId, replacementMaxReleaseDate);
    }

    public void setOfflineOrderIds(Set<Integer> orderIDs) {
        offlineOrderIds.clear();
        for (Integer orderID : orderIDs) {
            LicensePluginModel.addOfflineOrderId(orderID);
        }
    }

    static {
        LicensePluginModel.addOfflineOrderId(36299);
        LicensePluginModel.addOfflineOrderId(57798);
        LicensePluginModel.addOfflineOrderId(59082);
        LicensePluginModel.addOfflineOrderId(63837);
        LicensePluginModel.addOfflineOrderId(63838);
        LicensePluginModel.addOfflineOrderId(63839);
        LicensePluginModel.addOfflineOrderId(63840);
        LicensePluginModel.addOfflineOrderId(63841);
        LicensePluginModel.addOfflineOrderId(53734);
        LicensePluginModel.addOfflineOrderId(0);
        LicensePluginModel.addOfflineOrderId(62527);
        LicensePluginModel.addOfflineOrderId(61277);
        LicensePluginModel.addOfflineOrderId(64887);
        LicensePluginModel.addOfflineOrderId(40024);
        LicensePluginModel.addOfflineOrderId(11086);
        LicensePluginModel.addOfflineOrderId(14155);
        LicensePluginModel.addOfflineOrderId(65782);
        LicensePluginModel.addOfflineOrderId(37554);
        LicensePluginModel.addOfflineOrderId(52218);
        LicensePluginModel.addOfflineOrderId(63933);
        LicensePluginModel.addOfflineOrderId(63934);
        LicensePluginModel.addOfflineOrderId(67398);
        LicensePluginModel.addOfflineOrderId(34459);
        LicensePluginModel.addOfflineOrderId(63189);
        LicensePluginModel.addOfflineOrderId(67720);
        LicensePluginModel.addOfflineOrderId(44160);
        LicensePluginModel.addOfflineOrderId(67534);
        LicensePluginModel.addOfflineOrderId(69277);
        LicensePluginModel.addOfflineOrderId(69753);
        LicensePluginModel.addOfflineOrderId(67028);
        LicensePluginModel.addOfflineOrderId(44711);
        LicensePluginModel.addOfflineOrderId(58866);
        LicensePluginModel.addOfflineOrderId(88304);
        LicensePluginModel.addOfflineOrderId(62308);
        LicensePluginModel.addOfflineOrderId(8988);
        LicensePluginModel.addOfflineOrderId(54680);
        LicensePluginModel.addOfflineOrderId(55067);
        LicensePluginModel.addOfflineOrderId(70510);
        LicensePluginModel.addOfflineOrderId(74861);
        LicensePluginModel.addOfflineOrderId(76455);
        LicensePluginModel.addOfflineOrderId(81505);
        LicensePluginModel.addOfflineOrderId(78534);
        LicensePluginModel.addOfflineOrderId(77030);
        LicensePluginModel.addOfflineOrderId(77819);
        LicensePluginModel.addOfflineOrderId(73810);
        LicensePluginModel.addOfflineOrderId(80394);
        LicensePluginModel.addOfflineOrderId(34835);
        LicensePluginModel.addOfflineOrderId(81300);
        LicensePluginModel.addOfflineOrderId(82645);
        LicensePluginModel.addOfflineOrderId(83159);
        LicensePluginModel.addOfflineOrderId(79272);
        LicensePluginModel.addOfflineOrderId(83537);
        LicensePluginModel.addOfflineOrderId(72594);
        LicensePluginModel.addOfflineOrderId(85731);
        LicensePluginModel.addOfflineOrderId(59767);
        LicensePluginModel.addOfflineOrderId(85650);
        LicensePluginModel.addOfflineOrderId(42751);
        LicensePluginModel.addOfflineOrderId(86744);
        LicensePluginModel.addOfflineOrderId(44160);
        LicensePluginModel.addOfflineOrderId(90976);
        LicensePluginModel.addOfflineOrderId(91561);
        LicensePluginModel.addOfflineOrderId(90283);
        LicensePluginModel.addOfflineOrderId(92961);
        LicensePluginModel.addOfflineOrderId(90392);
        LicensePluginModel.addOfflineOrderId(86019);
        LicensePluginModel.addOfflineOrderId(64238);
        LicensePluginModel.addOfflineOrderId(90253);
        LicensePluginModel.addOfflineOrderId(93889);
        LicensePluginModel.addOfflineOrderId(96865);
        LicensePluginModel.addOfflineOrderId(95188);
        LicensePluginModel.addOfflineOrderId(99189);
        LicensePluginModel.addOfflineOrderId(99231);
        LicensePluginModel.addOfflineOrderId(99468);
        LicensePluginModel.addOfflineOrderId(100007);
        LicensePluginModel.addOfflineOrderId(100009);
        LicensePluginModel.addOfflineOrderId(106873);
        LicensePluginModel.addOfflineOrderId(107378);
        LicensePluginModel.addOfflineOrderId(107026);
        LicensePluginModel.addOfflineOrderId(107635);
        LicensePluginModel.addOfflineOrderId(109124);
        LicensePluginModel.addOfflineOrderId(110328);
        LicensePluginModel.addOfflineOrderId(111580);
        LicensePluginModel.addOfflineOrderId(107551);
        LicensePluginModel.addOfflineOrderId(111554);
        LicensePluginModel.addOfflineOrderId(113036);
        LicensePluginModel.addOfflineOrderId(107284);
        LicensePluginModel.addOfflineOrderId(101060);
        LicensePluginModel.addOfflineOrderId(106019);
        LicensePluginModel.addOfflineOrderId(113365);
        LicensePluginModel.addOfflineOrderId(114338);
        LicensePluginModel.addOfflineOrderId(114591);
        LicensePluginModel.addOfflineOrderId(111300);
        LicensePluginModel.addOfflineOrderId(114947);
        LicensePluginModel.addOfflineOrderId(114186);
        LicensePluginModel.addOfflineOrderId(115622);
        LicensePluginModel.addOfflineOrderId(112188);
        LicensePluginModel.addOfflineOrderId(113804);
        LicensePluginModel.addOfflineOrderId(117677);
        LicensePluginModel.addOfflineOrderId(117968);
        LicensePluginModel.addOfflineOrderId(107428);
        LicensePluginModel.addOfflineOrderId(119296);
        LicensePluginModel.addOfflineOrderId(119417);
        LicensePluginModel.addOfflineOrderId(119418);
        LicensePluginModel.addOfflineOrderId(116217);
        LicensePluginModel.addOfflineOrderId(117161);
        LicensePluginModel.addOfflineOrderId(100112);
        LicensePluginModel.addOfflineOrderId(121254);
        LicensePluginModel.addOfflineOrderId(106328);
        LicensePluginModel.addOfflineOrderId(107653);
        LicensePluginModel.addOfflineOrderId(122398);
        LicensePluginModel.addOfflineOrderId(105151);
        LicensePluginModel.addOfflineOrderId(107365);
        LicensePluginModel.addOfflineOrderId(122947);
        LicensePluginModel.addOfflineOrderId(122971);
        LicensePluginModel.addOfflineOrderId(125356);
        LicensePluginModel.addOfflineOrderId(124776);
        LicensePluginModel.addOfflineOrderId(123931);
        LicensePluginModel.addOfflineOrderId(124776);
        LicensePluginModel.addOfflineOrderId(123931);
        LicensePluginModel.addOfflineOrderId(127258);
        LicensePluginModel.addOfflineOrderId(127416);
        LicensePluginModel.addOfflineOrderId(123323);
        LicensePluginModel.addOfflineOrderId(129462);
        LicensePluginModel.addOfflineOrderId(104195);
        LicensePluginModel.addOfflineOrderId(130279);
        LicensePluginModel.addOfflineOrderId(132050);
        LicensePluginModel.addOfflineOrderId(131629);
        LicensePluginModel.addOfflineOrderId(133606);
        LicensePluginModel.addOfflineOrderId(137222);
        LicensePluginModel.addOfflineOrderId(133606);
        LicensePluginModel.addOfflineOrderId(134995);
        LicensePluginModel.addOfflineOrderId(135397);
        LicensePluginModel.addOfflineOrderId(105572);
        LicensePluginModel.addOfflineOrderId(137220);
        LicensePluginModel.addOfflineOrderId(138922);
        LicensePluginModel.addOfflineOrderId(140647);
        LicensePluginModel.addOfflineOrderId(140226);
        LicensePluginModel.addOfflineOrderId(137788);
        LicensePluginModel.addOfflineOrderId(121326);
        LicensePluginModel.addOfflineOrderId(141405);
        LicensePluginModel.addOfflineOrderId(142831);
        LicensePluginModel.addOfflineOrderId(121545);
        LicensePluginModel.addOfflineOrderId(144167);
        LicensePluginModel.addOfflineOrderId(125745);
        LicensePluginModel.addOfflineOrderId(137306);
        LicensePluginModel.addOfflineOrderId(127334);
    }

    public class KeepAliveThread
    extends Thread {
        private KeepAliveThread() {
            super("LicensePlugin KeepaliveThread " + LicensePluginModel.this.productCode + "/" + LicensePluginModel.this.sessionId);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info("LicensePluginModel: Started heartbeat thread for product " + LicensePluginModel.this.productCode + " / session " + LicensePluginModel.this.sessionId);
            Object object = LicensePluginModel.this.heartbeatLock;
            synchronized (object) {
                while (true) {
                    try {
                        LicensePluginModel.this.heartbeatLock.wait(LicensePluginModel.this.heartbeat);
                        log.fine("Sending keepalive request");
                        LicensePluginModel.this.onlineModel.contactServer(LicensePluginModel.this.sessionId);
                        LicensePluginModel.this.heartbeat = LicensePluginModel.this.onlineModel.getHeartbeat();
                        LicensePluginModel.this.setHeartAttack(null);
                        continue;
                    }
                    catch (IOException e) {
                        log.log(Level.FINE, "IOException while running heartbeat, will try again in " + LicensePluginModel.this.heartbeat + "ms", e);
                        continue;
                    }
                    catch (InvalidLicenseException e) {
                        LicensePluginModel.this.setHeartAttack(e);
                    }
                    catch (InterruptedException e) {
                        log.info("heartbeat thread was interrupted; exiting");
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Unexpected exception while sending heartbeat: " + e + ", cancelling heartbeat thread", e);
                    }
                    finally {
                        LicensePluginModel.this.heartbeat = Math.max(LicensePluginModel.this.heartbeat, 30000);
                        LicensePluginModel.this.heartbeatLock.notifyAll();
                        continue;
                    }
                    break;
                }
                try {
                    LicensePluginModel.this.onlineModel.sendServerDisconnect(LicensePluginModel.this.sessionId);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Failed to send license server disconnect message", e);
                }
                finally {
                    LicensePluginModel.this.heartbeatLock.notifyAll();
                }
            }
            log.info("LicensePluginModel: Finished heartbeat thread for product " + LicensePluginModel.this.productCode + " / session " + LicensePluginModel.this.sessionId);
        }
    }
}

