/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client;

import com.prosc.deployment.DeploymentInfo;
import com.prosc.license.client.BlacklistedLicenseException;
import com.prosc.license.client.ExpiredLicenseException;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.License;
import com.prosc.shared.StringUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Registration
implements Serializable {
    private static final Logger log = Logger.getLogger(Registration.class.getName());
    private static final long DEMO_TIMEOUT_MILLIS = 0x6DDD00L;
    private static final String INIT_TIME = "initTime";
    private final byte majorVersion;
    private final byte minimumMajorVersion;
    private final short storeNumber;
    private final Date majorReleaseDate;
    private final Date buildDate;
    private final String versionName;
    private String licenseKey;
    private String companyName;
    @Nullable
    private License cachedLicense;
    private boolean didSetExpirationDate = false;
    private long expirationDate = 0L;
    private boolean requireLicenseKey = false;
    private boolean portfolioAllowed = true;
    private boolean fbaPortfolioAllowed = true;
    private InvalidLicenseException storedLicenseError;
    private boolean networkLicenseCheckRequired = true;
    private long demoTimeoutMillis = 0x6DDD00L;

    public Registration(byte majorVersion, byte minimumMajorVersion, String versionName, short storeNumber, Date majorReleaseDate, Date buildDate) {
        if (storeNumber <= 0) {
            throw new IllegalArgumentException("storeNumber must be greater than zero.");
        }
        if (majorVersion <= 0) {
            throw new IllegalArgumentException("majorVersion must be greater than zero.");
        }
        this.majorVersion = majorVersion;
        this.minimumMajorVersion = minimumMajorVersion;
        this.versionName = versionName;
        this.storeNumber = storeNumber;
        this.majorReleaseDate = majorReleaseDate;
        this.buildDate = buildDate;
    }

    public Registration(byte majorVersion, byte minimumMajorVersion, String versionName, short storeNumber, String majorReleaseDate, Date buildDateParam) {
        this(majorVersion, minimumMajorVersion, versionName, storeNumber, Registration.dateFor(majorReleaseDate), buildDateParam);
    }

    public Registration(DeploymentInfo instance) {
        this((byte)instance.getMajorVersion(), instance.getMinimumMajorVersion(), instance.getVersion(), instance.getStoreNumber(), instance.getMajorReleaseDate(), instance.getLicenseCutoffDate());
    }

    private static Date dateFor(String majorReleaseDate) {
        try {
            return DateFormat.getDateInstance(3, Locale.US).parse(majorReleaseDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setInfo(String registeredTo, String licenseKey) {
        Registration registration = this;
        synchronized (registration) {
            if (this.storedLicenseError != null && registeredTo.equals(this.storedLicenseError.getLicensedTo()) && licenseKey.equals(this.storedLicenseError.getLicenseKey())) {
                return false;
            }
            if (this.companyName != null && this.companyName.equals(registeredTo) && this.licenseKey != null && this.licenseKey.equals(licenseKey)) {
                return false;
            }
            this.setCompanyName(registeredTo);
            this.setLicenseKey(licenseKey);
            return true;
        }
    }

    public String getCompanyName() {
        return this.companyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
        this.setCachedLicense(null);
        Registration registration = this;
        synchronized (registration) {
            this.storedLicenseError = null;
        }
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLicenseKey(String key) {
        this.licenseKey = key;
        this.setCachedLicense(null);
        Registration registration = this;
        synchronized (registration) {
            this.storedLicenseError = null;
        }
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public Date getMajorReleaseDate() {
        return this.majorReleaseDate;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }

    public short getStoreNumber() {
        return this.storeNumber;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public long getDemoTimeoutMillis() {
        return this.demoTimeoutMillis;
    }

    public void setDemoTimeoutMillis(long demoTimeoutMillis) {
        this.demoTimeoutMillis = demoTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLicense() throws InvalidLicenseException {
        Date buildDate;
        boolean isExpired;
        Registration registration = this;
        synchronized (registration) {
            if (this.storedLicenseError != null) {
                throw this.storedLicenseError;
            }
        }
        String licenseKey = this.getLicenseKey();
        String companyName = this.getCompanyName();
        if ((licenseKey == null || licenseKey.length() == 0) && this.requireLicenseKey) {
            throw new InvalidLicenseException("This product must be registered with a valid license key.", licenseKey);
        }
        if (this.cachedLicense == null) {
            this.cachedLicense = !(licenseKey != null && licenseKey.length() != 0 || companyName != null && companyName.length() != 0) ? this.createDemoLicense() : this.createLicense(licenseKey, companyName);
        }
        if (!this.didSetExpirationDate) {
            if (this.cachedLicense.getVariant() == 0) {
                log.info("Registered successfully with demo license; will run for two hours after launch. (Registration object " + System.identityHashCode(this) + ")");
                if (this.getExpirationDate() == 0L) {
                    this.setExpirationDate(this.getInitTime() + this.getDemoTimeoutMillis());
                    log.log(Level.INFO, "Expiration date " + new Date(this.getExpirationDate()));
                }
                if (this.cachedLicense.getExpirationDate() < this.getExpirationDate()) {
                    this.setExpirationDate(this.cachedLicense.getExpirationDate());
                }
            } else {
                log.fine("Registered successfully.");
                this.setExpirationDate(this.cachedLicense.getExpirationDate());
            }
            this.didSetExpirationDate = true;
        }
        boolean bl = isExpired = System.currentTimeMillis() > this.expirationDate || this.cachedLicense.getVariant() == 0 && System.currentTimeMillis() < this.getInitTime();
        if (this.cachedLicense.isPortfolio()) {
            if (this.cachedLicense.getVariant() == 5 && !this.isFbaPortfolioAllowed()) {
                throw new InvalidLicenseException("This product is not covered by the FBA Portfolio license.", this.cachedLicense);
            }
            if (this.cachedLicense.getVariant() != 5 && !this.isPortfolioAllowed()) {
                throw new InvalidLicenseException("This product is not covered by the 360Works Portfolio license.", this.cachedLicense);
            }
            if (this.cachedLicense.getVariant() == 0) {
                throw new InvalidLicenseException("Portfolio licenses cannot use DEMO variants", this.cachedLicense);
            }
            if (this.cachedLicense.getVersion() != 1) {
                throw new InvalidLicenseException("This Portfolio license has an embedded version of '" + this.cachedLicense.getVersion() + "'; version must be '1' for Portfolio licenses.", this.cachedLicense);
            }
        } else {
            if (this.storeNumber != this.cachedLicense.getProductCode()) {
                throw new InvalidLicenseException("License key provided is for a different product (expected " + this.storeNumber + "; found " + this.cachedLicense.getProductCode() + ")", licenseKey, companyName);
            }
            if (this.cachedLicense.getVersion() > 0 && this.cachedLicense.getVersion() < this.getMinimumMajorVersion()) {
                throw new InvalidLicenseException("License is for an older product version.", licenseKey, companyName);
            }
            if (isExpired) {
                if (this.cachedLicense.getVariant() == 0) {
                    throw new ExpiredLicenseException("DEMO mode expired! (" + this.storeNumber + ") You can continue to run in demo mode by restarting FileMaker, or you can register with a valid license key from http://www.360works.com.", this.cachedLicense.getEncryptedKey());
                }
                throw new ExpiredLicenseException("This license key expired on " + new Date(this.getExpirationDate()), this.cachedLicense.getEncryptedKey());
            }
        }
        if ((buildDate = this.buildDate) != null && this.cachedLicense.getMaxReleaseDate() != 0L && buildDate.getTime() > this.cachedLicense.getMaxReleaseDate()) {
            DateFormat df = DateFormat.getDateInstance();
            throw new ExpiredLicenseException("Your license covers products released up to " + df.format(new Date(this.cachedLicense.getMaxReleaseDate())) + ", but the release date is " + df.format(buildDate) + ". Renew your license at http://360works.com/renew (order ID " + this.cachedLicense.getOrderID() + " / registered to " + companyName + ")", this.cachedLicense.getEncryptedKey());
        }
        if (this.cachedLicense.getVariant() == 127) {
            throw new BlacklistedLicenseException("This license has been deactivated.", this.cachedLicense);
        }
    }

    protected License createLicense(String licenseKey, String companyName) throws InvalidLicenseException {
        return new License(licenseKey, companyName);
    }

    protected License createDemoLicense() {
        long initTime = this.getInitTime();
        return new License(0, this.storeNumber, this.majorVersion, 0, initTime, initTime + this.getDemoTimeoutMillis(), Long.MAX_VALUE, null, null);
    }

    private String initTimePrefKey() {
        return Registration.class.getName() + INIT_TIME;
    }

    private long getInitTime() {
        Properties p = System.getProperties();
        Long initTime = (Long)p.get(this.initTimePrefKey());
        if (initTime == null) {
            long currentTimeMillis = System.currentTimeMillis();
            p.put(this.initTimePrefKey(), (Object)currentTimeMillis);
            return currentTimeMillis;
        }
        return initTime;
    }

    public final String getLicenseInfo() {
        try {
            this.checkLicense();
            return this.getLicenseInfo(this.cachedLicense, this.expirationDate);
        }
        catch (InvalidLicenseException e) {
            log.log(Level.WARNING, "Invalid license", e);
            return e.getMessage();
        }
    }

    public String getLicenseInfo(License license, long expirationDate) {
        StringBuilder result = new StringBuilder();
        result.append("Major Version: ").append(this.getMajorVersion()).append(StringUtils.CR);
        result.append("Type: ").append(license.getVariantName()).append(StringUtils.CR);
        result.append("Registered To: ").append(license.getRegisteredTo()).append(StringUtils.CR);
        if (expirationDate != Long.MAX_VALUE) {
            String expirationLabel = license.isPortfolio() ? "Portfolio renewal date: " : "Expires on: ";
            result.append(expirationLabel).append(DateFormat.getDateTimeInstance().format(new Date(expirationDate))).append(StringUtils.CR);
        }
        return result.toString();
    }

    public License getLicense() throws InvalidLicenseException {
        return this.getLicense(true);
    }

    @NotNull
    public License getLicense(boolean runChecks) throws InvalidLicenseException {
        if (this.cachedLicense == null) {
            if (runChecks) {
                this.checkLicense();
            } else {
                License license = this.createLicense(this.getLicenseKey(), this.getCompanyName());
                if (license == null) {
                    Registration.$$$reportNull$$$0(0);
                }
                return license;
            }
        }
        License license = this.cachedLicense;
        if (license == null) {
            Registration.$$$reportNull$$$0(1);
        }
        return license;
    }

    public void setCachedLicense(License cachedLicense) {
        this.cachedLicense = cachedLicense;
        this.didSetExpirationDate = false;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    private void setExpirationDate(long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean isRequireLicenseKey() {
        return this.requireLicenseKey;
    }

    public void setRequireLicenseKey(boolean requireLicenseKey) {
        this.requireLicenseKey = requireLicenseKey;
    }

    private boolean isPortfolioAllowed() {
        return this.portfolioAllowed;
    }

    public void setPortfolioAllowed(boolean portfolioAllowed) {
        this.portfolioAllowed = portfolioAllowed;
    }

    public boolean isFbaPortfolioAllowed() {
        return this.fbaPortfolioAllowed;
    }

    public void setFbaPortfolioAllowed(boolean fbaPortfolioAllowed) {
        this.fbaPortfolioAllowed = fbaPortfolioAllowed;
    }

    public synchronized void storeLicenseError(@Nullable InvalidLicenseException e) {
        this.storedLicenseError = e;
    }

    public boolean isDemo() {
        return this.cachedLicense != null && this.cachedLicense.getVariant() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Registration that = (Registration)o;
        if (this.fbaPortfolioAllowed != that.fbaPortfolioAllowed) {
            return false;
        }
        if (this.majorVersion != that.majorVersion) {
            return false;
        }
        if (this.minimumMajorVersion != that.minimumMajorVersion) {
            return false;
        }
        if (this.networkLicenseCheckRequired != that.networkLicenseCheckRequired) {
            return false;
        }
        if (this.portfolioAllowed != that.portfolioAllowed) {
            return false;
        }
        if (this.requireLicenseKey != that.requireLicenseKey) {
            return false;
        }
        if (this.storeNumber != that.storeNumber) {
            return false;
        }
        if (!Objects.equals(this.companyName, that.companyName)) {
            return false;
        }
        if (!Objects.equals(this.licenseKey, that.licenseKey)) {
            return false;
        }
        if (!Objects.equals(this.majorReleaseDate, that.majorReleaseDate)) {
            return false;
        }
        return Objects.equals(this.versionName, that.versionName);
    }

    public int hashCode() {
        int result = this.majorVersion;
        result = 31 * result + this.minimumMajorVersion;
        result = 31 * result + this.storeNumber;
        result = 31 * result + (this.majorReleaseDate != null ? this.majorReleaseDate.hashCode() : 0);
        result = 31 * result + (this.versionName != null ? this.versionName.hashCode() : 0);
        result = 31 * result + (this.licenseKey != null ? this.licenseKey.hashCode() : 0);
        result = 31 * result + (this.companyName != null ? this.companyName.hashCode() : 0);
        result = 31 * result + (this.requireLicenseKey ? 1 : 0);
        result = 31 * result + (this.portfolioAllowed ? 1 : 0);
        result = 31 * result + (this.fbaPortfolioAllowed ? 1 : 0);
        result = 31 * result + (this.networkLicenseCheckRequired ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Registration{storeNumber=" + this.storeNumber + ", majorVersion=" + this.majorVersion + ", versionName='" + this.versionName + "', companyName='" + this.companyName + "'}";
    }

    public boolean isNetworkLicenseCheckRequired() {
        return this.networkLicenseCheckRequired;
    }

    public void setNetworkLicenseCheckRequired(boolean networkLicenseCheckRequired) {
        this.networkLicenseCheckRequired = networkLicenseCheckRequired;
    }

    public byte getMinimumMajorVersion() {
        return this.minimumMajorVersion <= 0 ? this.majorVersion : this.minimumMajorVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/license/client/Registration", "getLicense"));
    }
}

