/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.io.ZipArchiver;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class ZipUnarchiver
implements FileVisitor<Path>,
Closeable {
    private static final Logger log = Logger.getLogger(ZipArchiver.class.getName());
    private static final String JAR_FILE_PROTOCOL = "jar:file:";
    private static final HashMap<String, String> options = new HashMap();
    private Path workingDirectory;
    private Path zipFileParent;
    private FileSystem zipFileSystem;

    public ZipUnarchiver(Path zipFilePath) throws IOException {
        this.zipFileParent = zipFilePath.getParent();
        boolean needsLeadingSlash = !zipFilePath.startsWith("/");
        String jarFilePath = JAR_FILE_PROTOCOL + (needsLeadingSlash ? "/" : "") + zipFilePath.toString().replace("\\", "/").replace(" ", "%20");
        log.info("JAR file path: " + jarFilePath);
        this.zipFileSystem = FileSystems.newFileSystem(URI.create(jarFilePath), options);
    }

    @Override
    public void close() throws IOException {
        this.zipFileSystem.close();
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path relativePath = Paths.get("/", new String[0]).relativize(Paths.get(dir.toString(), new String[0]));
        Path to = this.workingDirectory.resolve(relativePath);
        Files.createDirectories(to, new FileAttribute[0]);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path relativePath = Paths.get("/", new String[0]).relativize(Paths.get(file.toString(), new String[0]));
        Path to = this.workingDirectory.resolve(relativePath);
        Files.copy(file, to, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        if (exc != null) {
            log.log(Level.SEVERE, "Visit to file " + file.toString() + " failed", exc);
            throw exc;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (exc != null) {
            log.log(Level.SEVERE, "An error occurred after visiting directory " + dir.toString(), exc);
            throw exc;
        }
        return FileVisitResult.CONTINUE;
    }

    public void unzipFilePath(@NotNull Path workingDirectory) throws IOException {
        if (workingDirectory == null) {
            ZipUnarchiver.$$$reportNull$$$0(0);
        }
        this.workingDirectory = workingDirectory;
        Files.walkFileTree(this.zipFileSystem.getPath("/", new String[0]), this);
    }

    public void unzipFilePath() throws IOException {
        this.workingDirectory = this.zipFileParent;
        Files.walkFileTree(this.zipFileSystem.getPath("/", new String[0]), this);
    }

    static {
        options.put("create", "false");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirectory", "com/prosc/io/ZipUnarchiver", "unzipFilePath"));
    }
}

