/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.io.IOUtils;
import com.prosc.shared.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipExtractor {
    public File[] extractZip(ZipInputStream zipStream, File destinationDirectory) throws IOException {
        return this.extractZip(zipStream, destinationDirectory, false);
    }

    public File[] extractZip(ZipInputStream zipStream, File destinationDirectory, boolean omitEnclosingDirectory) throws IOException {
        ZipEntry eachEntry;
        LinkedList<File> result = new LinkedList<File>();
        while ((eachEntry = zipStream.getNextEntry()) != null) {
            String destPath = eachEntry.getName();
            if (omitEnclosingDirectory) {
                int mark1 = destPath.indexOf(47);
                destPath = mark1 == -1 ? null : destPath.substring(mark1 + 1);
            }
            if (StringUtils.isEmpty(destPath)) continue;
            File theFile = new File(destinationDirectory, destPath);
            if (eachEntry.isDirectory()) {
                IOUtils.ensureDirectoryIsReady(theFile);
            } else {
                IOUtils.ensureDirectoryIsReady(theFile.getParentFile());
                try (FileOutputStream out = new FileOutputStream(theFile);){
                    IOUtils.writeInputToOutput((InputStream)zipStream, (OutputStream)out, 8192);
                }
            }
            if (!theFile.getParentFile().equals(destinationDirectory)) continue;
            result.add(theFile);
        }
        return result.toArray(new File[0]);
    }
}

