/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class ZipArchiver
implements FileVisitor<Path>,
Closeable {
    private static final Logger log = Logger.getLogger(ZipArchiver.class.getName());
    private static final String JAR_FILE_PROTOCOL = "jar:file:";
    private static final HashMap<String, String> options = new HashMap();
    private Path workingDirectory;
    private FileSystem zipFileSystem;

    public ZipArchiver(Path zipFilePath) throws IOException {
        boolean needsLeadingSlash = !zipFilePath.startsWith("/");
        String jarFilePath = JAR_FILE_PROTOCOL + (needsLeadingSlash ? "/" : "") + zipFilePath.toString().replace("\\", "/").replace(" ", "%20");
        log.info("JAR file path: " + jarFilePath);
        this.zipFileSystem = FileSystems.newFileSystem(URI.create(jarFilePath), options);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path to = this.zipFileSystem.getPath(this.workingDirectory.relativize(dir).toString(), new String[0]);
        Files.createDirectories(to, new FileAttribute[0]);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        block2: {
            Path to = this.zipFileSystem.getPath(this.workingDirectory.relativize(file).toString(), new String[0]);
            try {
                Files.copy(file, to, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (NoSuchFileException e) {
                if (e.getMessage() == null || !e.getMessage().endsWith(this.zipFileSystem.getSeparator())) break block2;
                Files.createDirectories(this.zipFileSystem.getPath(e.getMessage(), new String[0]), new FileAttribute[0]);
                Files.copy(file, to, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        if (exc != null) {
            log.log(Level.SEVERE, "Visit to file " + file.toString() + " failed", exc);
            throw exc;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (exc != null) {
            log.log(Level.SEVERE, "An error occurred after visiting directory " + dir.toString(), exc);
            throw exc;
        }
        return FileVisitResult.CONTINUE;
    }

    public void zipFilePath(@NotNull Path filePathToZip, @NotNull Path workingDirectory) throws IOException {
        if (filePathToZip == null) {
            ZipArchiver.$$$reportNull$$$0(0);
        }
        if (workingDirectory == null) {
            ZipArchiver.$$$reportNull$$$0(1);
        }
        this.workingDirectory = workingDirectory;
        Files.walkFileTree(filePathToZip, this);
    }

    public void zipFilePath(@NotNull Path filePathToZip) throws IOException {
        if (filePathToZip == null) {
            ZipArchiver.$$$reportNull$$$0(2);
        }
        this.workingDirectory = filePathToZip.getParent();
        Files.walkFileTree(filePathToZip, this);
    }

    @Override
    public void close() throws IOException {
        this.zipFileSystem.close();
    }

    static {
        options.put("create", "true");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "filePathToZip";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "workingDirectory";
                break;
            }
        }
        objectArray[1] = "com/prosc/io/ZipArchiver";
        objectArray[2] = "zipFilePath";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

