/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public class RecursiveDirectoryScanner
implements Iterator<File> {
    private LinkedList<FolderContext> folderContexts = new LinkedList();
    @Nullable
    private FileFilter filter;
    private File nextItem;
    private boolean followSymLinks = false;

    public RecursiveDirectoryScanner(File folder, @Nullable FileFilter filter) {
        if (!folder.exists()) {
            throw new IllegalArgumentException("Folder " + folder + " does not exist");
        }
        this.filter = filter;
        this.folderContexts.addLast(new FolderContext(folder));
        this.getNextItem();
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    @Override
    public File next() {
        File result = this.nextItem;
        this.getNextItem();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("You cannot remove files from this iterator");
    }

    private void getNextItem() {
        if (this.nextItem != null && this.nextItem.isDirectory() && (this.followSymLinks || !Files.isSymbolicLink(this.nextItem.toPath()))) {
            this.folderContexts.addLast(new FolderContext(this.nextItem));
        }
        FolderContext context = this.folderContexts.getLast();
        while (context.isFinished()) {
            this.folderContexts.removeLast();
            if (this.folderContexts.size() == 0) {
                this.nextItem = null;
                return;
            }
            context = this.folderContexts.getLast();
        }
        this.nextItem = context.getNext();
    }

    private class FolderContext {
        private final File[] items;
        private int index;

        public FolderContext(File dir) {
            if (!dir.exists()) {
                throw new IllegalArgumentException(dir.toString() + " does not exist");
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException(dir.toString() + " exists, but it is not a directory");
            }
            if (!dir.canRead()) {
                throw new IllegalArgumentException(dir.toString() + " is not readable.");
            }
            this.items = RecursiveDirectoryScanner.this.filter == null ? dir.listFiles() : dir.listFiles(RecursiveDirectoryScanner.this.filter);
            if (this.items == null) {
                throw new IllegalArgumentException(dir.toString() + " exists, but is not a valid folder");
            }
            this.index = 0;
        }

        public boolean isFinished() {
            return this.index == this.items.length;
        }

        public File getNext() {
            return this.items[this.index++];
        }
    }
}

