/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.format.ByteLengthFormat;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class ProgressLogInputStream
extends FilterInputStream {
    private static final Logger log = Logger.getLogger(ProgressLogInputStream.class.getName());
    private final int progressInterval;
    private final Logger delegate;
    private final Level whatLevel;
    private final ByteLengthFormat format = new ByteLengthFormat();
    private long bytesRead = 0L;
    private long nextUpdate;
    private long chunkStartTimestamp;
    private long chunkStartBytes = 0L;

    public ProgressLogInputStream(InputStream in, int progressInterval) {
        this(in, progressInterval, log, Level.INFO);
    }

    public ProgressLogInputStream(InputStream in, int progressInterval, Logger log, Level logLevel) {
        super(in);
        this.progressInterval = progressInterval;
        this.nextUpdate = progressInterval;
        this.chunkStartTimestamp = System.currentTimeMillis();
        this.delegate = log;
        this.whatLevel = logLevel;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result != -1) {
            ++this.bytesRead;
            this.logProgress();
        }
        return result;
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        int result;
        if (b == null) {
            ProgressLogInputStream.$$$reportNull$$$0(0);
        }
        if ((result = super.read(b)) != -1) {
            this.bytesRead += (long)result;
            this.logProgress();
        }
        return result;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        int result;
        if (b == null) {
            ProgressLogInputStream.$$$reportNull$$$0(1);
        }
        if ((result = super.read(b, off, len)) != -1) {
            this.bytesRead += (long)result;
            this.logProgress();
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.bytesRead != this.chunkStartBytes) {
            this.nextUpdate = this.bytesRead;
            this.logProgress();
        }
    }

    private void logProgress() {
        if (this.bytesRead >= this.nextUpdate) {
            long now = System.currentTimeMillis();
            long duration = now - this.chunkStartTimestamp;
            long bytesInChunk = this.bytesRead - this.chunkStartBytes;
            long bytesPerSecond = bytesInChunk * 1000L / Math.max(1L, duration);
            this.delegate.log(this.whatLevel, "Streamed " + this.format.format(bytesInChunk) + " from InputStream in " + duration + " milliseconds ( " + this.format.format(bytesPerSecond) + " per second ) / total read: " + this.format.format(this.bytesRead));
            this.chunkStartBytes = this.bytesRead;
            this.nextUpdate = this.bytesRead + (long)this.progressInterval;
            this.chunkStartTimestamp = now;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/prosc/io/ProgressLogInputStream", "read"));
    }
}

