/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.exception.UserCanceledException;
import com.prosc.infrastructure.Platform;
import com.prosc.io.IOUtils;
import com.prosc.io.ProcessExecutionException;
import com.prosc.shared.StringUtils;
import com.prosc.thread.MyThreadFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class ProcessUtils {
    private static final Logger log = Logger.getLogger(ProcessUtils.class.getName());

    private ProcessUtils() {
    }

    public static byte[] doShellCommand(String[] commandArray, @Nullable Map<String, String> env, @Nullable File workingDir) throws ProcessExecutionException, UserCanceledException {
        try {
            return ProcessUtils.doShellCommand(commandArray, env, workingDir, 0, true);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] doShellCommand(String[] commandArray, @Nullable Map<String, String> env, @Nullable File workingDir, boolean redirectStdErr) throws ProcessExecutionException, IOException, UserCanceledException {
        try {
            return ProcessUtils.doShellCommand(commandArray, env, workingDir, 0, redirectStdErr);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] doShellCommand(String[] commandArray, @Nullable Map<String, String> env, @Nullable File workingDir, int timeout) throws ProcessExecutionException, IOException, UserCanceledException, TimeoutException {
        return ProcessUtils.doShellCommand(commandArray, env, workingDir, timeout, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] doShellCommand(String[] commandArray, @Nullable Map<String, String> env, @Nullable File workingDir, int timeout, boolean redirectStdErr) throws ProcessExecutionException, TimeoutException, UserCanceledException {
        Callable<byte[]> callable = () -> {
            Process process;
            String[] convertedCommands = new String[commandArray.length];
            for (int n = 0; n < commandArray.length; ++n) {
                convertedCommands[n] = commandArray[n] == null ? "" : commandArray[n];
            }
            LinkedHashMap<String, String> envMap = new LinkedHashMap<String, String>(System.getenv());
            if (env != null) {
                envMap.putAll(env);
            }
            ProcessBuilder builder = new ProcessBuilder(convertedCommands);
            if (workingDir != null) {
                builder.directory(workingDir);
            }
            if (env != null) {
                for (Map.Entry entry : envMap.entrySet()) {
                    builder.environment().put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            builder.redirectErrorStream(redirectStdErr);
            try {
                process = builder.start();
            }
            catch (IOException e) {
                ProcessExecutionException processExecutionException = new ProcessExecutionException(null, e.getMessage(), -1);
                processExecutionException.initCause(e);
                throw processExecutionException;
            }
            try {
                int exitStatus;
                byte[] data;
                InputStream errorStream;
                InputStream inputStream;
                block30: {
                    byte[] e2222;
                    block32: {
                        block31: {
                            inputStream = process.getInputStream();
                            errorStream = process.getErrorStream();
                            data = IOUtils.inputStreamAsBytes(inputStream);
                            try {
                                exitStatus = process.waitFor();
                            }
                            catch (InterruptedException e2222) {
                                log.info("ProcessUtils was interrupted; destroying subprocess");
                                process.destroy();
                                log.info("Process " + process + " was destroyed");
                                throw e2222;
                            }
                            if (exitStatus != 0) break block30;
                            e2222 = data;
                            if (errorStream == null) break block31;
                            errorStream.close();
                        }
                        if (inputStream == null) break block32;
                        inputStream.close();
                    }
                    return e2222;
                }
                try {
                    try {
                        String errReturned;
                        String[] commandCopy = new String[commandArray.length];
                        System.arraycopy(commandArray, 0, commandCopy, 0, commandArray.length);
                        for (int m = 0; m < commandCopy.length; ++m) {
                            if (commandCopy[m] == null || !commandCopy[m].toLowerCase().contains("pass") || m + 1 >= commandCopy.length) continue;
                            commandCopy[m + 1] = "xxxxx";
                        }
                        String errorMessage = "Command " + Arrays.asList(commandCopy) + " failed with exit status " + exitStatus;
                        if (data.length > 0) {
                            errorMessage = errorMessage + "\nCommand output:\n" + new String(data, StandardCharsets.UTF_8).trim();
                        }
                        if (StringUtils.nonEmpty(errReturned = IOUtils.inputStreamAsString(errorStream, StandardCharsets.UTF_8))) {
                            errorMessage = errorMessage + "\nError output: " + errReturned;
                        }
                        throw new ProcessExecutionException(data, errorMessage, exitStatus);
                        {
                            catch (Throwable throwable) {
                                if (errorStream != null) {
                                    try {
                                        errorStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                process.destroy();
            }
        };
        try {
            if (timeout <= 0) {
                return callable.call();
            }
            ExecutorService service = Executors.newSingleThreadExecutor(new MyThreadFactory("ProcessUtils"));
            Future<byte[]> future = service.submit(callable);
            try {
                byte[] byArray = future.get(timeout, TimeUnit.MILLISECONDS);
                return byArray;
            }
            catch (TimeoutException e) {
                log.info("Process exceeded timeout; will cancel it.");
                future.cancel(true);
                throw e;
            }
            catch (InterruptedException e) {
                future.cancel(true);
                throw e;
            }
            finally {
                service.shutdown();
            }
        }
        catch (Throwable t) {
            if (t instanceof ExecutionException) {
                log.log(Level.WARNING, "Exception in ProcessUtils, stack trace up to this point: " + new RuntimeException("Stack trace only"));
                t = t.getCause();
            }
            if (t instanceof ProcessExecutionException) {
                throw (ProcessExecutionException)t;
            }
            if (t instanceof InterruptedException) {
                throw new UserCanceledException("User canceled '" + commandArray[0] + "' command", t);
            }
            if (t instanceof TimeoutException) {
                throw (TimeoutException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (!(t instanceof RuntimeException)) throw new RuntimeException(t);
            throw (RuntimeException)t;
        }
    }

    public static Collection<String> findPids(String processName, String commandSearch) throws TimeoutException {
        String[] lines;
        String[] cmd = Platform.isWin() ? new String[]{"wmic", "PROCESS", "where", "name like '%" + processName + "%'", "GET", "Processid,Caption,Commandline"} : new String[]{"ps", "axwww"};
        try {
            byte[] bytes = ProcessUtils.doShellCommand(cmd, null, null, 15000);
            String searchIn = new String(bytes, StandardCharsets.UTF_8);
            lines = searchIn.split(System.getProperty("line.separator"));
        }
        catch (TimeoutException e) {
            log.log(Level.SEVERE, "Process timed out: " + Arrays.asList(cmd), e);
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LinkedList<String> result = new LinkedList<String>();
        for (String line : lines) {
            if (!line.contains(processName) || !line.contains(commandSearch)) continue;
            if (Platform.isWin()) {
                line = line.trim();
                result.add(line.substring(line.lastIndexOf(32) + 1));
                continue;
            }
            result.add(line.substring(0, line.indexOf(" ")));
        }
        return result;
    }

    public static String getJavaPath() {
        File result;
        Object pathToExecutable = System.getenv("_RUNJAVA");
        if (pathToExecutable == null || !new File((String)pathToExecutable).exists()) {
            pathToExecutable = System.getenv("_EXECJAVA");
        }
        if (pathToExecutable == null || !new File((String)pathToExecutable).exists()) {
            String javaHome = System.getProperty("java.home");
            pathToExecutable = javaHome + File.separator + "bin" + File.separator + "java";
            if (Platform.isWin()) {
                pathToExecutable = (String)pathToExecutable + ".exe";
            }
            if (!(result = new File((String)pathToExecutable)).exists()) {
                throw new IllegalStateException("No file found at " + (String)pathToExecutable);
            }
        } else {
            result = new File((String)pathToExecutable);
        }
        if (result.canExecute()) {
            return result.getAbsolutePath();
        }
        throw new IllegalStateException("A file exists at '" + result.getPath() + "', but it is not executable");
    }
}

