/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InterruptibleInputStream
extends FilterInputStream {
    private static final Logger log = Logger.getLogger(InterruptibleInputStream.class.getName());
    private int bytesTransferred;
    private volatile boolean interrupted;

    public InterruptibleInputStream(InputStream in) {
        super(in);
    }

    public void interrupt() {
        this.interrupted = true;
    }

    private void checkInterruptStatus() throws InterruptedIOException {
        if (Thread.currentThread().isInterrupted()) {
            this.interrupt();
        }
        if (this.interrupted) {
            log.log(Level.INFO, this.toString() + " interrupted!");
            InterruptedIOException interruptedIOException = new InterruptedIOException("Interrupted");
            interruptedIOException.bytesTransferred = this.bytesTransferred;
            throw interruptedIOException;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkInterruptStatus();
        int result = super.read(b, off, len);
        this.bytesTransferred += result;
        return result;
    }

    public int getBytesTransferred() {
        return this.bytesTransferred;
    }
}

