/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpServer {
    private static final Logger log = Logger.getLogger(HttpServer.class.getName());
    private Socket theSocket;
    private Map<String, String> headerMap = null;
    private Map<String, String> parameterMap = null;
    private int timeout = 0;
    private String responseHeader = null;
    private String mimeType;
    private InputStream responseStream;
    private long contentLength = 0L;
    private BufferedInputStream in = null;
    private Map<String, String> customResponseHeaders;
    private String statusMessage = "200 OK";
    private boolean headersWritten;

    public HttpServer(Socket input) {
        this.theSocket = input;
    }

    public void setTimeout(int milliseconds) {
        this.timeout = milliseconds;
    }

    public Map getParameters() {
        this.readRequest();
        return this.parameterMap;
    }

    public Map<String, String> getHeaders() {
        this.readRequest();
        return this.headerMap;
    }

    public String getUsername() {
        return HttpServer.usernameAndPasswordForEncodedAuthHeader(this.getHeaders().get("authorization"))[0];
    }

    public String getPassword() {
        return HttpServer.usernameAndPasswordForEncodedAuthHeader(this.getHeaders().get("authorization"))[1];
    }

    public BufferedInputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new BufferedInputStream(this.theSocket.getInputStream());
        }
        return this.in;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setResponseStream(InputStream responseStream) {
        this.responseStream = responseStream;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public void setResponseString(String responseString) {
        if (responseString == null) {
            responseString = "";
        }
        this.setResponseStream(new ByteArrayInputStream(responseString.getBytes()));
        this.setContentLength(responseString.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse() throws IOException {
        try (OutputStream out = this.getOutputStream();){
            if (this.responseStream != null) {
                IOUtils.writeInputToOutput(this.responseStream, out, 65536);
                this.responseStream.close();
            }
        }
        finally {
            this.close();
        }
    }

    public void sendMissingResponse() throws IOException {
        OutputStream out = null;
        try {
            out = this.theSocket.getOutputStream();
            String missingMessage = "HTTP/1.1 404 NotFound\r\nConnection: close\r\nContent-Type: text/html; charset=iso-8859-1\r\nContent-Length: 0\r\n\r\n";
            out.write(missingMessage.getBytes());
        }
        finally {
            if (out != null) {
                out.close();
            }
            this.close();
        }
    }

    public void sendNoResponse() throws IOException {
        OutputStream out = null;
        try {
            out = this.theSocket.getOutputStream();
            String missingMessage = "HTTP/1.1 204 No Response\r\nContent-Length: 0\r\n\r\n";
            out.write(missingMessage.getBytes());
        }
        finally {
            if (out != null) {
                out.close();
            }
            this.close();
        }
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.theSocket.close();
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream out = this.theSocket.getOutputStream();
        if (!this.headersWritten) {
            out.write(this.responseHeader().getBytes());
            this.headersWritten = true;
        }
        return out;
    }

    public void closeSocket() throws IOException {
        this.theSocket.close();
    }

    public void setFullResponseHeader(String header) {
        this.responseHeader = header;
    }

    public void setResponseHeader(String headerKey, String headerValue) {
        if (this.customResponseHeaders == null) {
            this.customResponseHeaders = new HashMap<String, String>();
        }
        this.customResponseHeaders.put(headerKey, headerValue);
    }

    public String getMethod() {
        return this.getHeaders().get("method");
    }

    public String getPath() {
        return this.getHeaders().get("path");
    }

    public String getRequest() {
        return this.getHeaders().get("request");
    }

    public String getProtocol() {
        return this.getHeaders().get("protocol");
    }

    private String responseHeader() {
        if (this.responseHeader != null) {
            return this.responseHeader;
        }
        return this.defaultResponseHeader();
    }

    private String defaultResponseHeader() {
        StringBuilder response = new StringBuilder();
        response.append("HTTP/1.1 " + this.statusMessage + "\r\n");
        if (this.getCustomResponseHeader("Content-Length") == null && this.contentLength > 0L) {
            response.append("Content-Length: " + this.contentLength + "\r\n");
        }
        if (this.getCustomResponseHeader("Content-Type") == null) {
            response.append("Content-Type: " + this.mimeType() + "\r\n");
        }
        if (this.customResponseHeaders != null) {
            for (Map.Entry<String, String> entry : this.customResponseHeaders.entrySet()) {
                String eachKey = entry.getKey();
                String eachValue = entry.getValue();
                response.append(eachKey + ": " + eachValue + "\r\n");
            }
        }
        response.append("\r\n");
        return response.toString();
    }

    public void setStatusCode(int code) {
        this.statusMessage = String.valueOf(code);
    }

    private Object getCustomResponseHeader(String key) {
        if (this.customResponseHeaders == null) {
            return null;
        }
        return this.customResponseHeaders.get(key);
    }

    private String mimeType() {
        if (this.mimeType != null) {
            return this.mimeType;
        }
        return "text/html";
    }

    private void readRequest() {
        if (this.parameterMap == null) {
            this.customResponseHeaders = new HashMap<String, String>();
            try {
                if (this.timeout != 0) {
                    this.theSocket.setSoTimeout(this.timeout);
                }
                this.in = new BufferedInputStream(this.theSocket.getInputStream());
                this.readHeaders(this.in);
            }
            catch (SocketException err) {
                log.log(Level.WARNING, "Timed out waiting for socket!", err);
            }
            catch (InterruptedIOException err) {
                log.log(Level.WARNING, "Interrupted while waiting for socket!", err);
            }
            catch (IOException err) {
                log.log(Level.WARNING, "IOException while waiting for socket!", err);
            }
        }
    }

    private void readHeaders(BufferedInputStream stream) throws IOException {
        String eachLine;
        StringTokenizer st;
        this.headerMap = new HashMap<String, String>();
        this.parameterMap = new HashMap<String, String>();
        ByteArrayOutputStream headerBytes = new ByteArrayOutputStream(600);
        byte[] delimiter = "\r\n\r\n".getBytes();
        IOUtils.writeInputToOutput((InputStream)stream, (OutputStream)headerBytes, delimiter);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(headerBytes.toByteArray())));
        String firstLine = reader.readLine();
        if (firstLine == null) {
            firstLine = "";
        }
        if (!(st = new StringTokenizer(firstLine, " ")).hasMoreTokens()) {
            throw new IOException("No method specified in HTTP request: " + firstLine);
        }
        this.headerMap.put("method", st.nextToken());
        if (!st.hasMoreTokens()) {
            throw new IOException("No path specified in HTTP request: " + firstLine);
        }
        String request = st.nextToken();
        this.headerMap.put("request", request);
        if (!st.hasMoreTokens()) {
            throw new IOException("No protocol specified in HTTP request: " + firstLine);
        }
        this.headerMap.put("protocol", st.nextToken());
        int marker = request.indexOf(63);
        if (marker == -1) {
            this.headerMap.put("path", request);
        } else {
            this.headerMap.put("path", request.substring(0, marker));
            String queryString = request.substring(marker + 1);
            this.addStringToParameterMap(queryString);
        }
        String eachKey = null;
        while ((eachLine = reader.readLine()).length() > 0) {
            try {
                if (eachLine.startsWith("\t")) {
                    String partialValue = this.headerMap.get(eachKey);
                    this.headerMap.put(eachKey, partialValue + eachLine.substring(1));
                    continue;
                }
                marker = eachLine.indexOf(58);
                eachKey = eachLine.substring(0, marker).trim().toLowerCase();
                String eachValue = eachLine.substring(marker + 1).trim();
                this.headerMap.put(eachKey, eachValue);
            }
            catch (StringIndexOutOfBoundsException e) {
                log.warning(e.toString() + " while reading this line: " + eachLine);
            }
        }
        String contentLengthString = this.headerMap.get("content-length");
        if (contentLengthString != null) {
            String postString = IOUtils.inputStreamAsString(stream);
            this.addStringToParameterMap(postString);
        }
    }

    private void addStringToParameterMap(String queryString) {
        StringTokenizer st = new StringTokenizer(queryString, "&");
        while (st.hasMoreElements()) {
            String eachValue;
            String eachKey;
            String argument = (String)st.nextElement();
            int marker = argument.indexOf(61);
            if (marker == -1) {
                eachKey = IOUtils.decode(argument);
                eachValue = "";
            } else {
                eachKey = IOUtils.decode(argument.substring(0, marker));
                eachValue = IOUtils.decode(argument.substring(marker + 1));
            }
            this.parameterMap.put(eachKey, eachValue);
        }
    }

    public static void main(String[] args) throws Exception {
        int whichPort = 4060;
        try (ServerSocket serverSocket = new ServerSocket(whichPort);){
            HttpServer server = new HttpServer(serverSocket.accept());
            server.setFullResponseHeader("HTTP/1.1 204 No Response\r\n\r\n");
            server.sendResponse();
        }
    }

    public static String[] usernameAndPasswordForEncodedAuthHeader(String encodedAuth) {
        if (encodedAuth == null || encodedAuth.indexOf(32) == -1) {
            return new String[]{"", ""};
        }
        encodedAuth = encodedAuth.substring(encodedAuth.indexOf(32) + 1);
        String decodedAuth = new String(IOUtils.base64Decode(encodedAuth));
        String username = null;
        String password = null;
        StringTokenizer st = new StringTokenizer(decodedAuth, ":");
        if (decodedAuth.startsWith(":")) {
            if (st.hasMoreElements()) {
                password = st.nextToken();
            }
        } else {
            if (st.hasMoreElements()) {
                username = st.nextToken();
            }
            if (st.hasMoreElements()) {
                password = st.nextToken();
            }
        }
        return new String[]{username, password};
    }
}

