/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientUtils {
    private static final Logger log;
    private static final SSLSocketFactory noCheckFactory;
    private static final SSLSocketFactory standardFactory;
    private static final HostnameVerifier nonVerifier;

    public static void trustSelfSignedCertificates(HttpsURLConnection connection) {
        connection.setSSLSocketFactory(noCheckFactory);
    }

    public static void trustMismatchedHostname(HttpsURLConnection connection) {
        connection.setHostnameVerifier(nonVerifier);
    }

    public static void trustInvalidCertificates(@Nullable URLConnection connection, boolean trustMismatchedHostname, boolean trustSelfSignedCertificates) {
        if (connection instanceof HttpsURLConnection || connection == null) {
            HttpsURLConnection sslConnection = (HttpsURLConnection)connection;
            if (trustSelfSignedCertificates) {
                if (sslConnection == null) {
                    HttpsURLConnection.setDefaultSSLSocketFactory(noCheckFactory);
                } else {
                    sslConnection.setSSLSocketFactory(noCheckFactory);
                }
            } else if (sslConnection == null) {
                HttpsURLConnection.setDefaultSSLSocketFactory(standardFactory);
            } else {
                sslConnection.setSSLSocketFactory(standardFactory);
            }
            if (trustMismatchedHostname) {
                if (sslConnection == null) {
                    HttpsURLConnection.setDefaultHostnameVerifier(nonVerifier);
                } else {
                    sslConnection.setHostnameVerifier(nonVerifier);
                }
            } else {
                log.warning("In Java 17, once the trustMismtachedHostname has been set to true, it can't be set to false, because there is no default hostname verifier in Java 17");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getCertificateHostnames(URL url) throws IOException {
        HttpsURLConnection sslConnection = (HttpsURLConnection)url.openConnection();
        sslConnection.setUseCaches(false);
        HttpClientUtils.trustInvalidCertificates(sslConnection, true, true);
        sslConnection.connect();
        try {
            X509Certificate[] certificates;
            HashSet<String> sslNames = new HashSet<String>();
            sslConnection.getResponseCode();
            for (X509Certificate certificate : certificates = (X509Certificate[])sslConnection.getServerCertificates()) {
                try {
                    Collection<List<?>> alternativeNames = certificate.getSubjectAlternativeNames();
                    if (alternativeNames == null) continue;
                    for (List<?> alternativeNameObjects : alternativeNames) {
                        for (Object object : alternativeNameObjects) {
                            String hostname;
                            if (!(object instanceof String) || !(hostname = (String)object).startsWith("*.") && sslNames.contains("*." + hostname)) continue;
                            sslNames.add(hostname);
                        }
                    }
                }
                catch (CertificateParsingException e) {
                    log.log(Level.WARNING, "Could not parse hostnames from SSL certificate for server " + url, e);
                }
            }
            HashSet<String> hashSet = sslNames;
            return hashSet;
        }
        finally {
            sslConnection.disconnect();
        }
    }

    public static Reader getReader(URLConnection connection) throws IOException {
        return new InputStreamReader(connection.getInputStream(), HttpClientUtils.getContentEncoding(connection));
    }

    @NotNull
    public static String getContentEncoding(URLConnection connection) {
        String result = connection.getContentEncoding();
        if (result == null && connection.getContentType() != null) {
            result = StringUtils.textAfter(connection.getContentType(), "charset=").orElse(connection.getContentType());
        }
        if (result == null) {
            result = "UTF-8";
        }
        String string = result;
        if (string == null) {
            HttpClientUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    static {
        SSLSocketFactory _standardFactory;
        SSLContext context;
        log = Logger.getLogger(HttpClientUtils.class.getName());
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            context = SSLContext.getInstance("SSL");
            context.init(null, trustManagers, null);
            _standardFactory = context.getSocketFactory();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not create a standard SSL socket factory; will use the default. This will have the side effect that if trustMismatchedHostnames is called for a URL, it will be trusted for all other URLConnections to that same URL.", e);
            _standardFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        standardFactory = _standardFactory;
        try {
            context = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        X509TrustManager gullible = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        try {
            context.init(null, new TrustManager[]{gullible}, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        noCheckFactory = context.getSocketFactory();
        nonVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/io/HttpClientUtils", "getContentEncoding"));
    }
}

