/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;

public class DirectoryUtils {
    public static String uniquePathForPath(String inputPath) {
        File theFile = new File((String)inputPath);
        if (!theFile.exists()) {
            return inputPath;
        }
        String parentPath = theFile.getParent();
        int indexOfSuffix = theFile.getName().indexOf(46);
        if (indexOfSuffix == -1) {
            indexOfSuffix = theFile.getName().length();
        }
        String prefix = theFile.getName().substring(0, indexOfSuffix);
        String suffix = theFile.getName().substring(indexOfSuffix);
        int increment = 0;
        while ((theFile = new File((String)(inputPath = parentPath + "/" + prefix + ++increment + suffix))).exists()) {
        }
        return inputPath;
    }

    public static String[] directoryContents(String inputPath) {
        File theFile = new File(inputPath);
        return theFile.list();
    }

    public static File[] listRecursive(File whichFolder, FileFilter filter) {
        LinkedList<File> result = new LinkedList<File>();
        DirectoryUtils.listRecursive(whichFolder, filter, result);
        return result.toArray(new File[result.size()]);
    }

    private static void listRecursive(File whichFolder, FileFilter filter, LinkedList<File> result) {
        File[] items = whichFolder.listFiles();
        if (items != null) {
            for (File item : items) {
                if (item.isDirectory()) {
                    DirectoryUtils.listRecursive(item, filter, result);
                    continue;
                }
                if (filter != null && !filter.accept(item)) continue;
                result.add(item);
            }
        }
    }
}

