/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.QuadChar;
import com.prosc.fmkit.types.FMBinaryInterface;
import com.prosc.fmkit.types.InputStreamInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class FileReference
implements FMBinaryInterface {
    @Nullable
    private final PluginContext context;
    private short width;
    private short height;
    private String genericPath;
    private String macPath;
    private String winPath;
    private int type;
    private File file;
    public static final int TYPE_FILE = 0;
    public static final int TYPE_IMAGE = 1;
    public static final int TYPE_MOVIE = 2;
    private static final String[] TYPE_CODES = new String[]{"file", "image", "movie"};
    private static final Logger log = Logger.getLogger(FileReference.class.getName());
    private List streamTypes = null;
    private String referenceInfo;

    public FileReference(String referenceInfo, @Nullable PluginContext context) {
        int comma;
        if (referenceInfo == null) {
            throw new IllegalArgumentException("referenceInfo must not be null.");
        }
        this.context = context;
        this.referenceInfo = referenceInfo;
        Properties properties = new Properties();
        if (PluginUtils.isMac()) {
            referenceInfo = referenceInfo.replaceAll("\\%2F", ":");
        }
        try {
            PluginUtils.loadUnicodeProperties(properties, referenceInfo);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String size = properties.getProperty("size");
        if (size != null && (comma = size.indexOf(44)) != -1) {
            this.width = Short.parseShort(size.substring(0, comma));
            this.height = Short.parseShort(size.substring(comma + 1));
        }
        this.extractPathInfo(properties);
        this.streamTypes = this.type != -1 ? Collections.singletonList(QuadChar.FileData) : Collections.EMPTY_LIST;
    }

    private void extractPathInfo(Properties properties) {
        for (int i = 0; i < TYPE_CODES.length; ++i) {
            String eachType = TYPE_CODES[i];
            this.genericPath = properties.getProperty(eachType);
            if (this.genericPath != null) {
                String tmpPath;
                this.macPath = properties.getProperty(eachType + "mac");
                this.winPath = properties.getProperty(eachType + "win");
                this.type = i;
                if (this.referenceInfo != null && this.referenceInfo.startsWith("file:") && this.macPath == null && this.winPath == null && !new File(this.genericPath).exists() && !this.genericPath.equals(tmpPath = this.genericPath.replace("%20", " "))) {
                    log.log(Level.INFO, "URLDecoding genericPath '" + this.genericPath + "' to '" + tmpPath + "'");
                    this.genericPath = tmpPath;
                }
                return;
            }
            this.type = -1;
        }
    }

    @Override
    public short getWidth(PluginContext context) {
        return this.width;
    }

    @Override
    public short getHeight(PluginContext context) {
        return this.height;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public InputStreamInfo getInputStreamInfo(PluginContext context) throws FileNotFoundException {
        File file = this.getFile(context);
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("File not found");
        }
        if (file.isDirectory()) {
            throw new IllegalStateException("File " + file + " is a directory");
        }
        return new InputStreamInfo(file);
    }

    public int getType() {
        return this.type;
    }

    public File getFile(@Nullable PluginContext context) {
        File result;
        if (this.file == null) {
            File result11 = null;
            boolean isMac = PluginUtils.isMac();
            if (this.genericPath != null && this.genericPath.startsWith("/")) {
                result11 = new File(this.genericPath);
                if (isMac && !result11.exists()) {
                    result11 = new File("/Volumes" + this.genericPath);
                }
            }
            if (result11 == null || !result11.exists()) {
                if (isMac && this.macPath != null && this.macPath.startsWith("/")) {
                    result11 = new File(this.macPath);
                    if (!result11.exists()) {
                        result11 = new File("/Volumes" + this.macPath);
                    }
                } else if (!isMac && this.winPath != null && this.winPath.startsWith("/")) {
                    result11 = new File(this.winPath.replace('/', '\\'));
                }
            }
            this.file = result11;
        }
        if ((result = this.file) == null || !result.exists()) {
            if (context == null) {
                log.log(Level.WARNING, "Cannot resolve relative file path " + result + ", context is null");
                return null;
            }
            try {
                Object dbFilePath = context.evaluateExpression("Get(FilePath)").getStringData(context);
                if (dbFilePath == null || !((String)dbFilePath).startsWith("file:")) {
                    return null;
                }
                dbFilePath = ((String)dbFilePath).substring(5);
                if (PluginUtils.isMac()) {
                    dbFilePath = "/Volumes" + (String)dbFilePath;
                }
                File dbDir = new File((String)dbFilePath).getParentFile();
                result = new File(dbDir, this.genericPath);
                log.log(Level.FINE, "Resolving file reference using dbFilePath {0} and relative path {1}, result is {2}", new Object[]{dbFilePath, this.genericPath, result});
            }
            catch (FmCalculationException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public List getStreamTypes(PluginContext context) {
        return this.streamTypes;
    }

    @Override
    public QuadChar getBestQuadChar(PluginContext context) {
        return this.streamTypes.isEmpty() ? null : this.streamTypes.get(0);
    }

    @Override
    public InputStream getBestInputStream(PluginContext context) {
        File file = this.getFile(this.context);
        try {
            return file == null ? null : new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String asString() {
        return this.referenceInfo;
    }

    @Override
    public InputStream getStreamForType(QuadChar type, PluginContext context) {
        return this.getBestInputStream(this.context);
    }

    @Override
    public long getTotalSize(PluginContext context) {
        File file = this.getFile(this.context);
        return file == null ? 0L : file.length();
    }

    @Override
    public void setSoundData(byte[] data, PluginContext context) {
        throw new AbstractMethodError("com.prosc.fmkit.types.FileReference.setSoundData method not implemented.");
    }

    @Override
    public void addDataStream(byte[] data, QuadChar type, PluginContext context) {
        throw new AbstractMethodError("com.prosc.fmkit.types.FileReference.addDataStream method not implemented.");
    }

    @Override
    public String getFileName(PluginContext context) {
        File file = this.getFile(this.context);
        return file == null ? null : file.getName();
    }

    public static boolean isValidReferenceString(String s) {
        if (s == null || s.length() < 5) {
            return false;
        }
        if (s.startsWith("size:")) {
            return true;
        }
        for (int i = 0; i < TYPE_CODES.length; ++i) {
            String eachCode = TYPE_CODES[i];
            if (!s.startsWith(eachCode + ":") && !s.startsWith(eachCode + "mac:") && !s.startsWith(eachCode + "win:")) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "FileReference{width=" + this.width + ", height=" + this.height + ", genericPath='" + this.genericPath + "', macPath='" + this.macPath + "', winPath='" + this.winPath + "', type=" + this.type + ", file=" + this.file + "}";
    }
}

