/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.FMException;
import com.prosc.fmkit.FMTypeConverter;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.Environment;
import com.prosc.fmkit.types.FMBinary;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMDictConverter;
import com.prosc.fmkit.types.FMNumber;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMTimestamp;
import com.prosc.fmkit.types.FileConverter;
import com.prosc.fmkit.types.InputStreamInfo;
import com.prosc.io.IOUtils;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.xml.datatype.XMLGregorianCalendar;

public abstract class FMType {
    public static Environment ENVIRONMENT = Environment.Plugin;
    private static List converters = new LinkedList();
    private static final Logger log = Logger.getLogger(FMType.class.getName());

    private static void registerConverters() {
        FMType.addConverter(new FMTypeConverter());
        FMType.addConverter(new ColorConverter());
        FMType.addConverter(new InetAddressConverter());
        FMType.addConverter(new ListConverter());
        FMType.addConverter(new PointConverter());
    }

    public abstract void writeToData(PluginContext var1, FMData var2);

    public abstract String getAsString(PluginContext var1);

    public static void addConverter(Converter theConverter) {
        converters.add(theConverter);
    }

    public static Converter converterForClass(Class targetClass) throws UnsupportedTypeConversionException {
        for (Converter eachConverter : converters) {
            if (!eachConverter.canConvertTo(targetClass)) continue;
            return eachConverter;
        }
        throw new UnsupportedTypeConversionException(targetClass);
    }

    public static Class classForFMType(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName must not be null.");
        }
        if ("text".equals(typeName = typeName.toLowerCase())) {
            return String.class;
        }
        if ("number".equals(typeName)) {
            return BigDecimal.class;
        }
        if ("date".equals(typeName) || "time".equals(typeName) || "timestamp".equals(typeName)) {
            return Date.class;
        }
        if ("container".equals(typeName)) {
            return FMData.class;
        }
        throw new IllegalArgumentException("Unknown FM type '" + typeName + "'");
    }

    public static FMType bestTypeForJavaObject(PluginContext context, Object in) {
        if (in == null) {
            return null;
        }
        FMType result = null;
        Class<?> inClass = in.getClass();
        if (in instanceof FMType) {
            result = (FMType)in;
        } else if (String.class == inClass) {
            result = new FMText(context, (String)in);
        } else {
            if (in instanceof Reader) {
                try {
                    return new FMText(context, (Reader)in);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (Number.class.isAssignableFrom(inClass)) {
                result = new FMNumber((Number)in);
            } else {
                if (in instanceof Boolean) {
                    return (Boolean)in != false ? new FMNumber(1) : new FMNumber(0);
                }
                if (in instanceof File) {
                    try {
                        result = FMBinary.fmBinaryForFile((File)in, context);
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Unable to convert file {0} to FMBinary", e);
                        throw new RuntimeException(e);
                    }
                } else if (in instanceof URL) {
                    try {
                        result = FMBinary.fmBinaryForUrl((URL)in, context);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else if (in instanceof Color) {
                    Color color = (Color)in;
                    int unsigned = ColorConverter.convertToUnsignedInt(color);
                    result = new FMNumber(unsigned);
                } else if (in instanceof BufferedImage) {
                    try {
                        return FMBinary.fmBinaryForImage((BufferedImage)in, null, context);
                    }
                    catch (IOException e) {
                        log.log(Level.INFO, "Unable to convert " + in + " to image", e);
                    }
                } else if (in instanceof RenderedImage) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
                    try {
                        String format = "jpg";
                        ImageIO.write((RenderedImage)in, format, baos);
                        byte[] bytes = baos.toByteArray();
                        result = FMBinary.fmBinaryForData(bytes, "image." + format, null, context);
                    }
                    catch (IOException e) {
                        log.log(Level.INFO, "Unable to convert " + in + " to byte array", e);
                    }
                } else {
                    if (in instanceof DataSource) {
                        DataSource ds = (DataSource)in;
                        try {
                            return FMBinary.fmBinaryForData(IOUtils.inputStreamAsBytes(ds.getInputStream()), ds.getName(), ds.getContentType(), context);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (in instanceof InputStreamInfo) {
                        InputStreamInfo info = (InputStreamInfo)in;
                        try {
                            return FMBinary.fmBinaryForData(IOUtils.inputStreamAsBytes(info.getStream()), info.getName(), info.getContentType(), context);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (in instanceof Object[]) {
                        String stringValue = FMType.arrayToString((Object[])in);
                        result = new FMText(context, stringValue);
                    } else if (in instanceof Collection) {
                        StringBuilder sb = new StringBuilder();
                        for (Object o : (Collection)in) {
                            if (sb.length() != 0) {
                                sb.append("\r");
                            }
                            sb.append(o);
                        }
                        result = new FMText(context, sb.toString());
                    } else {
                        if (in instanceof Date) {
                            return new FMTimestamp((Date)in);
                        }
                        if (in instanceof XMLGregorianCalendar) {
                            Date time = ((XMLGregorianCalendar)in).toGregorianCalendar().getTime();
                            return new FMTimestamp(time);
                        }
                    }
                }
            }
        }
        if (result == null) {
            log.log(Level.FINE, "Unknown object type {0}, will use String.valueOf()", in.getClass().getName());
            result = new FMText(context, String.valueOf(in));
        }
        log.log(Level.FINER, "best type for {0} \"{1}\" is {2}", new Object[]{in.getClass().getName(), in, result});
        return result;
    }

    private static String arrayToString(Object[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            Object eachValue;
            if (i != 0) {
                sb.append("\r");
            }
            if ((eachValue = array[i]) instanceof Object[]) {
                Object[] subArray = (Object[])eachValue;
                for (int j = 0; j < subArray.length; ++j) {
                    Object eachSubValue = subArray[j];
                    if (j != 0) {
                        sb.append("\t");
                    }
                    sb.append(eachSubValue);
                }
                continue;
            }
            sb.append(eachValue);
        }
        return sb.toString();
    }

    static {
        FMNumber.registerConverters();
        FMText.registerConverters();
        FMTimestamp.registerConverters();
        FMBinary.registerConverters();
        FMDictConverter.registerConverters();
        FMData.registerConverters();
        FMType.registerConverters();
        FileConverter.registerConverters();
        InputStreamInfo.registerConverters();
    }

    public static final class ColorConverter
    implements Converter {
        public boolean canConvertTo(Class targetClass) {
            return targetClass == Color.class;
        }

        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            if (param.isEmpty(context)) {
                return null;
            }
            return this.convertString(param.getStringData(context));
        }

        public Color convertString(String stringData) {
            String upperStringData;
            String string = upperStringData = stringData == null ? null : ((String)stringData).toUpperCase();
            if (stringData == null || ((String)stringData).length() == 0) {
                return null;
            }
            if (((String)stringData).charAt(0) == '#') {
                if (((String)stringData).length() == 4) {
                    stringData = "#" + ((String)stringData).charAt(1) + ((String)stringData).charAt(1) + ((String)stringData).charAt(2) + ((String)stringData).charAt(2) + ((String)stringData).charAt(3) + ((String)stringData).charAt(3);
                }
                try {
                    return Color.decode((String)stringData);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((String)stringData + " is not a valid color format", e);
                }
            }
            if (Character.isDigit(((String)stringData).charAt(0))) {
                try {
                    return Color.decode((String)stringData);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((String)stringData + " is not a valid color format", e);
                }
            }
            if (((String)stringData).toLowerCase().startsWith("rgb")) {
                String[] parts = ((String)stringData).split("[^0-9]+");
                return new Color(Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]), 0);
            }
            Field[] fields = Color.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field eachField = fields[i];
                if (eachField.getType() != Color.class || !Modifier.isStatic(eachField.getModifiers()) || !eachField.getName().equals(upperStringData)) continue;
                try {
                    return (Color)eachField.get(Color.class);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalArgumentException("Unable to convert '" + (String)stringData + "' to a Color");
        }

        public static int convertToUnsignedInt(Color color) {
            int rgb = color.getRGB();
            return rgb & 0xFFFFFF;
        }
    }

    static class InetAddressConverter
    implements Converter {
        InetAddressConverter() {
        }

        public boolean canConvertTo(Class targetClass) {
            return InetAddress.class.isAssignableFrom(targetClass);
        }

        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            String stringData = param.getStringData(context);
            try {
                return InetAddress.getByName(stringData);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Unknown/invalid host name or IP address: " + stringData);
            }
        }
    }

    static class ListConverter
    implements Converter {
        ListConverter() {
        }

        public boolean canConvertTo(Class targetClass) {
            return targetClass.isAssignableFrom(List.class);
        }

        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            String stringData = param.getStringData(context);
            return Arrays.asList(stringData.split("\\r?\\n|\\r"));
        }
    }

    public static final class PointConverter
    implements Converter<Point> {
        @Override
        public boolean canConvertTo(Class<Point> targetClass) {
            return targetClass.isAssignableFrom(Point.class);
        }

        @Override
        public Point convertData(FMData param, Class<Point> targetClass, PluginContext context) {
            String stringData = param.getStringData(context);
            return PointConverter.getPoint(stringData);
        }

        public static Point getPoint(String stringData) {
            if (stringData == null || stringData.isEmpty()) {
                return null;
            }
            String[] coords = stringData.split(",");
            if (coords.length != 2) {
                throw new IllegalArgumentException("Expected xy coordinates of the form x,y");
            }
            int x = Integer.parseInt(coords[0].trim());
            int y = Integer.parseInt(coords[1].trim());
            return new Point(x, y);
        }
    }

    public static class UnsupportedTypeConversionException
    extends FMException {
        public UnsupportedTypeConversionException(Class whichClass) {
            super((short)-2, "No conversion capability for class " + whichClass.getName());
        }
    }
}

