/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.CodeToParent;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.types.Environment;
import com.prosc.fmkit.types.FMType;
import java.io.DataInputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FMCharacterStyle {
    public static final int Face_Plain = 0;
    public static final int Face_Bold = 256;
    public static final int Face_Italic = 512;
    public static final int Face_Underline = 1024;
    public static final int Face_Outline = 2048;
    public static final int Face_Shadow = 4096;
    public static final int Face_Condense = 8192;
    public static final int Face_Extend = 16384;
    public static final int Face_Strikethrough = 1;
    public static final int Face_SmallCaps = 2;
    public static final int Face_Superscript = 4;
    public static final int Face_Subscript = 8;
    public static final int Face_Uppercase = 16;
    public static final int Face_Lowercase = 32;
    public static final int Face_Titlecase = 48;
    public static final int Face_WordUnderline = 64;
    public static final int Face_DoubleUnderline = 128;
    public static final int Face_AllStyles = Short.MAX_VALUE;
    private static HashMap<String, Integer> textStylesByName = new HashMap();
    private int face;
    private int fontID;
    private int fontSize;
    private int red;
    private int green;
    private int blue;
    private int alpha;
    long cToken;
    private static final Logger log;

    public FMCharacterStyle(PluginContext context) {
        if (FMType.ENVIRONMENT == Environment.WebService) {
            return;
        }
        this.cToken = this._createCharacterStyle(context);
    }

    public FMCharacterStyle(int fontID, int face, int fontSize, PluginContext context) {
        this(context);
        this.setFontID(fontID, context);
        this.setFace(face, context);
        this.setFontSize(fontSize, context);
    }

    public FMCharacterStyle(long cToken) {
        this.cToken = cToken;
    }

    private long _createCharacterStyle(PluginContext context) {
        return context.callback(CodeToParent.createCharStyle, null, DataInputStream::readLong);
    }

    public void setFace(int face, PluginContext context) {
        this.face = face;
        this.setFace(this.cToken, face, context);
    }

    public void setFaces(String styles, PluginContext context) {
        if (styles == null) {
            styles = "";
        }
        this.setFace(this.parseStyles(styles), context);
    }

    public void setSize(int fontSize, PluginContext context) {
        this.fontSize = fontSize;
        this.setFontSize(this.cToken, fontSize, context);
    }

    private void setFace(long cToken, int face, PluginContext context) {
        if (FMType.ENVIRONMENT == Environment.WebService) {
            return;
        }
        context.callback(CodeToParent.setFace, out -> {
            out.writeLong(cToken);
            out.writeInt(face);
        }, null);
    }

    public void setFontID(int fontID, PluginContext context) {
        this.fontID = fontID;
        if (FMType.ENVIRONMENT == Environment.WebService) {
            return;
        }
        this.setFontID(this.cToken, fontID, context);
    }

    private void setFontID(long cToken, int fontID, PluginContext context) {
        context.callback(CodeToParent.setFontID, out -> {
            out.writeLong(cToken);
            out.writeInt(fontID);
        }, null);
    }

    public void setFontSize(int fontSize, PluginContext context) {
        this.fontSize = fontSize;
        if (FMType.ENVIRONMENT == Environment.WebService) {
            return;
        }
        this.setFontSize(this.cToken, fontSize, context);
    }

    private void setFontSize(long cToken, int fontSize, PluginContext context) {
        context.callback(CodeToParent.setFontSize, out -> {
            out.writeLong(cToken);
            out.writeInt(fontSize);
        }, null);
    }

    public void setColor(int red, int green, int blue, int alpha, PluginContext context) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.setColor(this.cToken, red, green, blue, alpha, context);
    }

    private void setColor(long cToken, int red, int green, int blue, int alpha, PluginContext context) {
        if (FMType.ENVIRONMENT == Environment.WebService) {
            return;
        }
        context.callback(CodeToParent.setColor, out -> {
            out.writeLong(cToken);
            out.writeInt(red);
            out.writeInt(green);
            out.writeInt(blue);
            out.writeInt(alpha);
        }, null);
    }

    public int getFace(PluginContext context) {
        return this.getFace(this.cToken, context);
    }

    private int getFontID(long cToken, PluginContext context) {
        return context.callback(CodeToParent.getFontID, out -> out.writeLong(cToken), DataInputStream::readInt);
    }

    public int getFontID(PluginContext context) {
        if (FMType.ENVIRONMENT == Environment.WebService) {
            return this.fontID;
        }
        return this.getFontID(this.cToken, context);
    }

    private int getFace(long cToken, PluginContext context) {
        if (FMType.ENVIRONMENT == Environment.WebService) {
            return this.face;
        }
        return context.callback(CodeToParent.getFace, out -> out.writeLong(cToken), DataInputStream::readInt);
    }

    public int getFontSize(PluginContext context) {
        if (FMType.ENVIRONMENT == Environment.WebService) {
            return this.fontSize;
        }
        return this.getFontSize(this.cToken, context);
    }

    private int getFontSize(long cToken, PluginContext context) {
        return context.callback(CodeToParent.getFontSize, out -> out.writeLong(cToken), DataInputStream::readInt);
    }

    private int parseStyles(String styles_str) {
        int styles = 0;
        if (styles_str != null && styles_str.length() > 0) {
            String[] styleList;
            for (String aStyleList : styleList = styles_str.split("[\\+ ]+")) {
                Integer keyValue = textStylesByName.get(aStyleList.toLowerCase());
                try {
                    if (keyValue == null) {
                        styles += Integer.valueOf(aStyleList).intValue();
                        continue;
                    }
                    styles += keyValue.intValue();
                }
                catch (NumberFormatException nfe) {
                    log.log(Level.WARNING, "Invalid style: " + aStyleList);
                }
            }
        }
        return styles;
    }

    public String toString() {
        return "FMCharacterStyle{face=" + this.face + ", fontID=" + this.fontID + ", fontSize=" + this.fontSize + ", red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + ", cToken=" + this.cToken + "}";
    }

    public int getColor() {
        return (this.red << 16) + (this.green << 8) + this.blue;
    }

    static {
        textStylesByName.put("plain", 0);
        textStylesByName.put("strikethrough", 1);
        textStylesByName.put("smallcaps", 2);
        textStylesByName.put("superscript", 4);
        textStylesByName.put("subscript", 8);
        textStylesByName.put("uppercase", 16);
        textStylesByName.put("lowercase", 32);
        textStylesByName.put("titlecase", 48);
        textStylesByName.put("wordunderline", 64);
        textStylesByName.put("doubleunderline", 128);
        textStylesByName.put("bold", 256);
        textStylesByName.put("italic", 512);
        textStylesByName.put("underline", 1024);
        textStylesByName.put("condense", 8192);
        textStylesByName.put("extend", 16384);
        textStylesByName.put("outline", 2048);
        textStylesByName.put("shadow", 4096);
        textStylesByName.put("highlight", 4096);
        log = Logger.getLogger(FMCharacterStyle.class.getName());
    }
}

