/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fm.FMFileUtils;
import com.prosc.fmkit.CodeToParent;
import com.prosc.fmkit.JackInputStream;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.QuadChar;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMBinaryInterface;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMType;
import com.prosc.fmkit.types.FileReference;
import com.prosc.fmkit.types.InputStreamInfo;
import com.prosc.fmkit.unicode.Compress;
import com.prosc.fmkit.unicode.EndOfInputException;
import com.prosc.fmkit.unicode.Expand;
import com.prosc.fmkit.unicode.IllegalInputException;
import com.prosc.io.IOUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FMBinary
extends FMType
implements FMBinaryInterface {
    private static final Logger log = Logger.getLogger(FMBinary.class.getName());
    protected long cToken;
    private List streamTypes;
    private FMData fmData;
    private static int DEFAULT_INPUT_BUFFER_SIZE = 65536;

    FMBinary(PluginContext context) {
        this.cToken = this._createBinary(context);
    }

    FMBinary(long cToken, FMData fmData) {
        this.cToken = cToken;
        this.fmData = fmData;
    }

    FMBinary(PluginContext pluginContext, File file, String filename) {
        this.cToken = pluginContext.callback(CodeToParent.createFmBinaryFromFile, out -> {
            out.writeUTF16String(file.getCanonicalPath());
            out.writeUTF16String(filename);
            out.writeLong(file.length());
        }, DataInputStream::readLong);
    }

    FMBinary(PluginContext pluginContext, byte[] bytes, String filename) {
        this.cToken = pluginContext.callback(CodeToParent.createFmBinaryFromBytes, out -> {
            out.writeUTF16String(filename);
            out.writeInt(bytes.length);
            out.write(bytes);
        }, DataInputStream::readLong);
    }

    private FMBinary(long cToken, long binaryContext) {
        this.cToken = cToken;
    }

    private FMBinary(long cToken) {
        this.cToken = cToken;
    }

    @Override
    public String getAsString(PluginContext context) {
        return super.toString();
    }

    public static FMBinary fmBinaryForFile(File file, PluginContext context) throws IOException {
        return FMBinary.fmBinaryForFile(file, file.getName(), context);
    }

    public static FMBinary fmBinaryForFile(File file, String filename, PluginContext context) throws IOException {
        if (filename == null) {
            filename = file.getName();
        }
        log.log(Level.INFO, "Creating container for file " + file);
        return FMBinary.fmBinaryForFile(file, filename, null, context);
    }

    public static FMBinary fmBinaryForFile(File file, String filename, String optionalContentType, PluginContext context) throws IOException {
        if (filename == null) {
            filename = file.getName();
        }
        log.log(Level.INFO, "Creating container for file " + file);
        try (FileInputStream in = new FileInputStream(file);){
            FMBinary result;
            if (context.getFileMakerAPIVersion() <= 53) {
                result = FMBinary.fmBinaryForData(in, filename, optionalContentType, (int)file.length(), context);
            } else if (context.getFileMakerAPIVersion() <= 54) {
                result = new FMBinary(context, file, filename);
            } else {
                try (FMBinaryOutputStream outputStream = new FMBinaryOutputStream(context, filename, optionalContentType);){
                    IOUtils.writeInputToOutput((InputStream)in, (OutputStream)outputStream, 65536);
                    result = outputStream.getFmBinary();
                }
            }
            FMBinary fMBinary = result;
            return fMBinary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FMType fmBinaryForUrl(URL url, PluginContext context) throws IOException {
        InputStreamInfo info = PluginUtils.getInputStreamInfoForUrl(url);
        try (BufferedInputStream in = new BufferedInputStream(info.getStream());){
            FMBinary fMBinary = FMBinary.fmBinaryForData(in, info.getName(), info.getContentType(), (int)info.getLength(), context);
            return fMBinary;
        }
    }

    public static FMBinary fmBinaryForData(InputStream data, String filename, PluginContext context) throws IOException {
        return FMBinary.fmBinaryForData(data, filename, 0, context);
    }

    public static FMBinary fmBinaryForData(InputStream data, String filename, int size, PluginContext context) throws IOException {
        return FMBinary.fmBinaryForData(data, filename, null, size, context);
    }

    public static FMBinary fmBinaryForData(InputStream data, String filename, String optionalContentType, int size, PluginContext context) throws IOException {
        return FMBinary.fmBinaryForData(FMBinary.getInputStreamAsBytes(data, size), filename, optionalContentType, context);
    }

    public static FMBinary fmBinaryForData(byte[] bytes, String filename, @Nullable String optionalContentType, PluginContext context) throws IOException {
        FMBinary result;
        if (context.getFileMakerAPIVersion() <= 53) {
            result = new FMBinary(context);
            QuadChar quadChar = FMBinary.getQuadChar(filename, optionalContentType);
            Dimension dimension = null;
            if (quadChar.isImage()) {
                try {
                    dimension = FMBinary.getImageDimensions(bytes);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Could not calculate image dimensions for " + filename, e);
                }
            }
            if (dimension != null) {
                log.log(Level.FINE, "Returning " + quadChar + " image with dimensions " + dimension.getWidth() + "x" + dimension.getHeight());
                result.addImageData(null, bytes, (short)dimension.getWidth(), (short)dimension.getHeight(), quadChar, context);
            } else {
                result.addDataStream(bytes, quadChar, context);
            }
            result.setFileName(filename, context);
        } else if (context.getFileMakerAPIVersion() <= 54) {
            result = new FMBinary(context, bytes, filename);
        } else {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                 FMBinaryOutputStream outputStream = new FMBinaryOutputStream(context, filename, optionalContentType);){
                IOUtils.writeInputToOutput((InputStream)inputStream, (OutputStream)outputStream, 65536);
                result = outputStream.getFmBinary();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dimension getImageDimensions(byte[] bytes) throws IOException {
        log.log(Level.INFO, "Calculating dimensions for image with length " + bytes.length);
        ByteArrayInputStream baos = new ByteArrayInputStream(bytes);
        ImageInputStream in = ImageIO.createImageInputStream(baos);
        try {
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    reader.dispose();
                    return dimension;
                }
                catch (Throwable throwable) {
                    reader.dispose();
                    throw throwable;
                }
            }
        }
        finally {
            baos.close();
            if (in != null) {
                in.close();
            }
        }
        return null;
    }

    private static QuadChar getQuadChar(String filename, @Nullable String optionalContentType) {
        QuadChar quadChar = null;
        if (optionalContentType != null) {
            quadChar = QuadChar.forMimeType(optionalContentType);
        }
        if (quadChar == null) {
            quadChar = QuadChar.forFilename(filename);
        }
        return quadChar;
    }

    public static FMBinary fmBinaryForImage(BufferedImage image, String filename, PluginContext context) throws IOException {
        if (image == null) {
            return null;
        }
        if (image.getWidth() > Short.MAX_VALUE || image.getHeight() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Image dimension(s) exceed maximum of 32767 pixels");
        }
        if (filename == null || ((String)filename).length() == 0) {
            filename = "image";
        }
        if (((String)filename).indexOf(46) == -1) {
            filename = image.getType() == 2 ? (String)filename + ".png" : (String)filename + ".jpg";
        } else if ((((String)filename).toLowerCase().endsWith(".jpg") || ((String)filename).toLowerCase().endsWith(".jpeg")) && (image.getType() == 2 || image.getColorModel().getTransparency() != 1)) {
            log.log(Level.INFO, "Saving transparent image as " + (String)filename + ", converting to opaque image with white background");
            BufferedImage opaque = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), 1);
            Graphics2D graphics = opaque.createGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
            graphics.drawImage((Image)image, 0, 0, null);
            graphics.dispose();
            image = opaque;
        }
        FMBinary result = new FMBinary(context);
        result.setFileName((String)filename, context);
        QuadChar qc = QuadChar.forFilename((String)filename);
        if (!qc.isImage()) {
            throw new IllegalArgumentException("File " + (String)filename + " is not an image");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        ImageIO.write((RenderedImage)image, ((String)filename).substring(((String)filename).lastIndexOf(46) + 1), baos);
        result.addImageData(image, baos.toByteArray(), (short)image.getWidth(), (short)image.getHeight(), qc, context);
        return result;
    }

    @Override
    public List getStreamTypes(PluginContext context) {
        if (this.streamTypes == null) {
            this.streamTypes = new ArrayList(4);
            int streamCount = this._getStreamCount(this.cToken, context);
            for (int i = 0; i < streamCount; ++i) {
                String typeString = this._getTypeForIndex(this.cToken, i, context);
                if (typeString != null && typeString.length() == 4) {
                    this.streamTypes.add(new QuadChar(typeString));
                    continue;
                }
                log.info("Illegal quadChar type '" + typeString + "' when trying to read container streams");
                this.streamTypes.add(QuadChar.Unknown);
            }
        }
        return this.streamTypes;
    }

    @Override
    public QuadChar getBestQuadChar(PluginContext context) {
        QuadChar result = null;
        List streamTypes = this.getStreamTypes(context);
        if (streamTypes.size() == 0) {
            return null;
        }
        if (streamTypes.contains(QuadChar.ImageTIFF)) {
            result = QuadChar.ImageTIFF;
        } else if (streamTypes.contains(QuadChar.ImagePDF)) {
            result = QuadChar.ImagePDF;
        } else if (streamTypes.contains(QuadChar.ImagePICT)) {
            result = QuadChar.ImagePICT;
        } else if (streamTypes.contains(QuadChar.ImageGIF)) {
            result = QuadChar.ImageGIF;
        } else if (streamTypes.contains(QuadChar.ImagePng)) {
            result = QuadChar.ImagePng;
        } else if (streamTypes.contains(QuadChar.FileData)) {
            result = QuadChar.FileData;
        } else if (streamTypes.contains(QuadChar.ImageJPEG)) {
            result = QuadChar.ImageJPEG;
        } else {
            for (QuadChar eachQ : streamTypes) {
                if (eachQ == null || eachQ.equals(QuadChar.FileName) || eachQ.equals(QuadChar.ResourceFork)) continue;
                result = eachQ;
                break;
            }
        }
        return result;
    }

    @Override
    public InputStream getBestInputStream(PluginContext context) {
        if (this.fmData == null) {
            return null;
        }
        QuadChar bestQ = this.getBestQuadChar(context);
        if (bestQ != null) {
            return this.getStreamForType(bestQ, context);
        }
        return null;
    }

    @Override
    public String asString() {
        try {
            Converter converter = FMType.converterForClass(String.class);
            return converter.convertData(this.fmData, String.class, null);
        }
        catch (FMType.UnsupportedTypeConversionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getStreamForType(QuadChar type, PluginContext context) {
        if ("ZLIB".equals(type.toString())) {
            try {
                return new GZIPInputStream((InputStream)new FMBinaryInputStream(this.getStreamTypes(context).indexOf(type), true, context), 8192);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new FMBinaryInputStream(this.getStreamTypes(context).indexOf(type), false, context);
    }

    private int _getStreamCount(long cToken, PluginContext context) {
        return context.callback(CodeToParent.getStreamCount, out -> out.writeLong(cToken), DataInputStream::readInt);
    }

    private long _getTotalSize(long cToken, PluginContext context) {
        return context.callback(CodeToParent.getStreamTotalSize, out -> out.writeLong(cToken), DataInputStream::readInt).intValue();
    }

    private String _getTypeForIndex(long cToken, int whichStream, PluginContext context) {
        return context.callback(CodeToParent.getStreamType, out -> {
            out.writeLong(cToken);
            out.writeInt(whichStream);
        }, JackInputStream::readUTF16String);
    }

    private void _getData(long cToken, int streamIndex, int srcOffset, int destOffset, int length, byte[] bytes, PluginContext context) {
        context.callback(CodeToParent.getStreamData, out -> {
            out.writeLong(cToken);
            out.writeInt(streamIndex);
            out.writeInt(srcOffset);
            out.writeInt(length);
        }, in -> {
            int read;
            int total_bytes_to_read = length;
            int total_bytes_read = 0;
            int offset = destOffset;
            do {
                read = in.read(bytes, offset, total_bytes_to_read);
                log.fine("Read from FMBinary " + read + " bytes");
                offset += read;
                total_bytes_read += read;
            } while ((total_bytes_to_read -= read) > 0);
            return total_bytes_read;
        });
    }

    void _addStream(long cToken, String dataType, int dataSize, byte[] data, PluginContext context) {
        context.callback(CodeToParent.addStream, out -> {
            out.writeLong(cToken);
            out.writeUTF16String(dataType);
            out.writeInt(dataSize);
            out.write(data);
        }, null);
    }

    private void _removeStream(long cToken, String dataType, PluginContext context) {
        context.callback(CodeToParent.removeStream, out -> {
            out.writeLong(cToken);
            out.writeUTF16String(dataType);
        }, null);
    }

    private native void _removeAllStreams(long var1);

    private int _getSize(long cToken, int streamIndex, PluginContext context) {
        return context.callback(CodeToParent.getStreamSize, out -> {
            out.writeLong(cToken);
            out.writeInt(streamIndex);
        }, DataInputStream::readInt);
    }

    long cToken() {
        return this.cToken;
    }

    @Override
    public long getTotalSize(PluginContext context) {
        return this._getTotalSize(this.cToken, context);
    }

    public void addImageData(BufferedImage img, byte[] data, short width, short height, QuadChar imageType, PluginContext context) throws IOException {
        this.addDataStream(data, imageType, context);
        if (width > 0 && height > 0) {
            this._addSizeData(width, height, context);
        }
        if (imageType != QuadChar.ImageJPEG && imageType != QuadChar.ImageGIF) {
            if (img == null) {
                img = ImageIO.read(new ByteArrayInputStream(data));
            }
            if (img != null) {
                log.log(Level.FINE, "Adding additional image data by converting from " + imageType + " to JPEG");
                ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                try {
                    BufferedImage jpgVersion = new BufferedImage(img.getWidth(), img.getHeight(), 1);
                    Graphics graphics = jpgVersion.getGraphics();
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(0, 0, jpgVersion.getWidth(), jpgVersion.getHeight());
                    graphics.drawImage(img, 0, 0, null);
                    graphics.dispose();
                    ImageIO.write((RenderedImage)jpgVersion, "jpg", baos);
                }
                catch (OutOfMemoryError e) {
                    ImageIO.write((RenderedImage)img, "jpg", baos);
                }
                this.addImageData(img, baos.toByteArray(), (short)img.getWidth(), (short)img.getHeight(), QuadChar.ImageJPEG, context);
            } else {
                log.log(Level.WARNING, "Unable to generate JPEG representation of image " + imageType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getInputStreamAsBytes(InputStream in, int size) throws IOException {
        try {
            int bytesRead;
            if (size < 1) {
                int lastBytesRead;
                ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
                byte[] buffer = new byte[8192];
                while ((lastBytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, lastBytesRead);
                }
                out.flush();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            byte[] result = new byte[size];
            for (int offset = 0; offset != result.length && (bytesRead = in.read(result, offset, result.length - offset)) != -1; offset += bytesRead) {
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            in.close();
        }
    }

    private void _addSizeData(short width, short height, PluginContext context) {
        this.addSize(this.cToken, width, height, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getWidth(PluginContext context) {
        short s;
        InputStream stream = this.getStreamForType(QuadChar.ImageSize, context);
        if (stream == null) {
            return -1;
        }
        try {
            byte[] sizeData = new byte[4];
            stream.read(sizeData);
            int result = sizeData[0] << 8;
            s = (short)(result |= sizeData[1] & 0xFF);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getHeight(PluginContext context) {
        short s;
        InputStream stream = this.getStreamForType(QuadChar.ImageSize, context);
        if (stream == null) {
            return -1;
        }
        try {
            byte[] sizeData = new byte[4];
            stream.read(sizeData);
            int result = sizeData[2] << 8;
            s = (short)(result |= sizeData[3] & 0xFF);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return s;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public InputStreamInfo getInputStreamInfo(PluginContext context) {
        QuadChar qc = this.getBestQuadChar(context);
        InputStream bestInputStream = this.getStreamForType(qc, context);
        long streamSize = bestInputStream instanceof FMBinaryInputStream ? (long)((FMBinaryInputStream)bestInputStream).getSize() : -1L;
        Object fileName = this.getFileName(context);
        String mimeType = qc.getMimeType();
        if (fileName == null) {
            fileName = "Untitled.jpg";
            try {
                fileName = "Untitled." + mimeType.substring(mimeType.indexOf(47) + 1);
                log.log(Level.INFO, "Unknown filename, using " + (String)fileName);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Unable to assign name for file, using " + (String)fileName);
            }
        }
        InputStreamInfo inputStreamInfo = new InputStreamInfo(bestInputStream, (String)fileName, streamSize, mimeType);
        inputStreamInfo.setEmbeddedContainer(true);
        return inputStreamInfo;
    }

    @Override
    public void setSoundData(byte[] data, PluginContext context) {
        this.addDataStream(data, QuadChar.Sound, context);
    }

    @Override
    public void addDataStream(byte[] data, QuadChar type, PluginContext context) {
        if (this.getStreamTypes(context).contains(type)) {
            this._removeStream(this.cToken, type.toString(), context);
        }
        this._addStream(this.cToken, type.toString(), data.length, data, context);
        this.streamTypes = null;
    }

    public void addFnam(long cToken, String fileName, PluginContext context) {
        context.callback(CodeToParent.addStreamFnam, out -> {
            out.writeLong(cToken);
            String fnam = "file:" + fileName;
            log.info("FNAM: " + fnam);
            out.writeUTF16String(fnam);
        }, null);
    }

    public void addFnam(long cToken, File file, PluginContext context) {
        context.callback(CodeToParent.addStreamFnam, out -> {
            out.writeLong(cToken);
            String fnam = FMFileUtils.convertToFileMaker(file, true);
            log.info("FNAM: " + fnam);
            out.writeUTF16String(fnam);
        }, null);
    }

    public void addSize(long cToken, short width, short height, PluginContext context) {
        context.callback(CodeToParent.addStreamSize, out -> {
            out.writeLong(cToken);
            out.writeShort(width);
            out.writeShort(height);
        }, null);
    }

    private long _createBinary(PluginContext context) {
        return context.callback(CodeToParent.createFmBinary, null, DataInputStream::readLong);
    }

    public static boolean canConvertTo(Class targetClass) {
        return targetClass == FMBinary.class;
    }

    @Override
    public void writeToData(PluginContext context, FMData destination) {
        destination.setFMBinary(this, context);
    }

    protected static void registerConverters() {
        FMType.addConverter(new FMBinaryConverter());
    }

    @Override
    public String getFileName(PluginContext context) {
        return context.callback(CodeToParent.getStreamFnam, out -> out.writeLong(this.cToken), jackInputStream -> {
            String preprocessed = jackInputStream.readUTF16String();
            if (preprocessed == null) {
                return null;
            }
            int indexOfColon = preprocessed.lastIndexOf(58);
            return Paths.get(preprocessed.substring(indexOfColon + 1, preprocessed.length()), new String[0]).getFileName().toString();
        });
    }

    private String getFileNameFromBinary(InputStream in) throws IOException {
        byte[] rawBytes = new byte[in.available()];
        if (rawBytes.length == 0) {
            return null;
        }
        int readResult = in.read(rawBytes);
        byte[] xorBytes = new byte[rawBytes.length];
        for (int n = 0; n < rawBytes.length; ++n) {
            xorBytes[n] = (byte)(rawBytes[n] ^ 0x5A);
            if (xorBytes[n] != -128) continue;
            xorBytes[n] = 47;
        }
        int startMark = 4;
        byte protocolLength = rawBytes[startMark];
        startMark += protocolLength + 1;
        ++startMark;
        int lastSlash = xorBytes.length;
        while (lastSlash >= startMark && xorBytes[--lastSlash] != 47) {
        }
        try {
            ++lastSlash;
            byte[] fileBytes = new byte[xorBytes.length - ++lastSlash];
            System.arraycopy(xorBytes, lastSlash, fileBytes, 0, fileBytes.length);
            return new Expand().expand(fileBytes);
        }
        catch (IllegalInputException e) {
            throw new RuntimeException(e);
        }
        catch (EndOfInputException e) {
            throw new RuntimeException(e);
        }
    }

    public void setFileName(String name, PluginContext context) {
        this._addfnamdata(this.cToken, name, context);
    }

    public void setFileName(File file, PluginContext context) {
        this._addfnamdata(this.cToken, file, context);
    }

    private void _addfnamdata(long ctoken, String name, PluginContext context) {
        this.addFnam(this.cToken, name, context);
    }

    private void _addfnamdata(long ctoken, File file, PluginContext context) {
        this.addFnam(this.cToken, file, context);
    }

    private void setFileNameForBinary(String protocol, String folder, String file, PluginContext context) {
        Compress compressor = new Compress();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(new byte[]{0, 0, 0, 1});
            out.write(protocol.length());
            out.write(protocol.getBytes());
            out.write(folder.length());
            out.write(this.xor(compressor.compress(folder)));
            out.write(file.length());
            out.write(this.xor(compressor.compress(file)));
            byte[] filenameByteArray = out.toByteArray();
            this.addDataStream(filenameByteArray, QuadChar.FileName, context);
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] xor(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            byte aByte = bytes[i];
            if (aByte == 47) continue;
            int n = i;
            bytes[n] = (byte)(bytes[n] ^ 0x5A);
        }
        return bytes;
    }

    public static final class FMBinaryOutputStream
    extends OutputStream {
        private final PluginContext context;
        private final FMBinary fmBinary;
        private final QuadChar dataType;
        private byte[] buf = new byte[8192];
        private int count;

        public FMBinary getFmBinary() {
            return this.fmBinary;
        }

        public FMBinaryOutputStream(PluginContext context, String fileName, @Nullable String contentType) {
            this.context = context;
            this.dataType = FMBinary.getQuadChar(fileName, contentType);
            this.fmBinary = context.callback(CodeToParent.createFmBinaryWithContext, out -> {
                out.writeUTF16String(this.dataType.toString());
                out.writeUTF16String(fileName);
            }, in -> {
                long cToken = in.readLong();
                return new FMBinary(cToken);
            });
        }

        private void flushBuffer() throws IOException {
            if (this.count > 0) {
                this.writeBytesToContainer(this.buf, this.count);
            }
            this.count = 0;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.count >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)b;
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            if (b == null) {
                FMBinaryOutputStream.$$$reportNull$$$0(0);
            }
            super.write(b);
        }

        @Override
        public synchronized void write(@NotNull byte[] b, int off, int len) throws IOException {
            if (b == null) {
                FMBinaryOutputStream.$$$reportNull$$$0(1);
            }
            if (len >= this.buf.length) {
                this.flushBuffer();
                this.writeBytesToContainer(b, len);
                return;
            }
            if (len > this.buf.length - this.count) {
                this.flushBuffer();
            }
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        }

        private void writeBytesToContainer(@NotNull byte[] b, int len) throws IOException {
            if (b == null) {
                FMBinaryOutputStream.$$$reportNull$$$0(2);
            }
            this.context.callback(CodeToParent.appendFmBinaryWithContext, out -> {
                out.writeLong(this.fmBinary.cToken);
                out.writeInt(len);
                out.write(b, 0, len);
            }, null);
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.context.callback(CodeToParent.closeFmBinaryWithContext, out -> out.writeLong(this.fmBinary.cToken), null);
        }

        @Override
        public void flush() throws IOException {
            this.flushBuffer();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "b";
            objectArray2[1] = "com/prosc/fmkit/types/FMBinary$FMBinaryOutputStream";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeBytesToContainer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class FMBinaryInputStream
    extends BufferedInputStream {
        public FMBinaryInputStream(int streamIndex, boolean expandWithZlib, PluginContext context) {
            this(streamIndex, expandWithZlib, context, DEFAULT_INPUT_BUFFER_SIZE);
        }

        public FMBinaryInputStream(int streamIndex, boolean expandWithZlib, PluginContext context, int bufferSize) {
            super(new _FMBinaryInputStream(streamIndex, expandWithZlib, context), bufferSize);
        }

        public int getSize() {
            return ((_FMBinaryInputStream)this.in).getSize();
        }
    }

    private static class FMBinaryConverter
    implements Converter {
        private FMBinaryConverter() {
        }

        public boolean canConvertTo(Class targetClass) {
            return FMBinary.class == targetClass || FMBinaryInterface.class == targetClass || FileReference.class == targetClass;
        }

        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            if (param.isEmpty(context)) {
                return null;
            }
            FMBinaryInterface result = null;
            if (targetClass == FMBinary.class || targetClass == FMBinaryInterface.class) {
                result = param.getFMBinary(context);
            }
            try {
                String stringData;
                if (!(result != null && !result.getStreamTypes(context).isEmpty() || targetClass != FMBinaryInterface.class && targetClass != FileReference.class || (stringData = param.getStringData(context)) == null || stringData.length() <= 0)) {
                    result = new FileReference(stringData, context);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not extract FileReference", e);
            }
            return result;
        }
    }

    private final class _FMBinaryInputStream
    extends InputStream {
        private final int streamIndex;
        private final PluginContext context;
        private final int rawSize;
        private final byte[] oneByte = new byte[1];
        private final boolean expandWithZlib;
        private int streamPosition = 0;

        private int getSize() {
            if (this.expandWithZlib) {
                return -1;
            }
            return this.rawSize;
        }

        private _FMBinaryInputStream(int streamIndex, boolean expandWithZlib, PluginContext context) {
            this.streamIndex = streamIndex;
            this.context = context;
            this.expandWithZlib = expandWithZlib;
            this.rawSize = FMBinary.this._getSize(FMBinary.this.cToken, streamIndex, context);
        }

        @Override
        public int read() throws IOException {
            int readResult = this.read(this.oneByte, 0, 1);
            if (readResult != 1) {
                return readResult;
            }
            byte rawByte = this.oneByte[0];
            return rawByte & 0xFF;
        }

        @Override
        public int read(@NotNull byte[] b) throws IOException {
            if (b == null) {
                _FMBinaryInputStream.$$$reportNull$$$0(0);
            }
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            int read;
            if (b == null) {
                _FMBinaryInputStream.$$$reportNull$$$0(1);
            }
            if (this.available() == 0) {
                read = -1;
            } else {
                len = Math.min(len, this.available());
                FMBinary.this._getData(FMBinary.this.cToken, this.streamIndex, this.streamPosition, off, len, b, this.context);
                read = len;
                this.streamPosition += read;
            }
            return read;
        }

        @Override
        public synchronized void mark(int readlimit) {
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int available() throws IOException {
            return this.rawSize - this.streamPosition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/prosc/fmkit/types/FMBinary$_FMBinaryInputStream", "read"));
        }
    }
}

