/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.infrastructure.Platform;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;

public final class QuadChar {
    public static final QuadChar FileName = new QuadChar('F', 'N', 'A', 'M');
    public static final QuadChar ImageJPEG = new QuadChar('J', 'P', 'E', 'G', "image/jpg");
    public static final QuadChar ImageTIFF = new QuadChar('T', 'I', 'F', 'F');
    public static final QuadChar ImageGIF = new QuadChar('G', 'I', 'F', 'f', "image/gif");
    public static final QuadChar ImagePng = new QuadChar('P', 'N', 'G', 'f', "image/png");
    public static final QuadChar ImageEPS = new QuadChar('E', 'P', 'S', ' ', "image/eps");
    public static final QuadChar ImagePICT = new QuadChar('P', 'I', 'C', 'T', "image/pict");
    public static final QuadChar ImageMETA = new QuadChar('M', 'E', 'T', 'A', "image/meta");
    public static final QuadChar ImageBMP = new QuadChar('B', 'M', 'P', ' ', "image/bmp");
    public static final QuadChar ImagePDF = new QuadChar('P', 'D', 'F', ' ', "application/pdf");
    public static final QuadChar ImageSize = new QuadChar('S', 'I', 'Z', 'E');
    public static final QuadChar FileData = new QuadChar('F', 'I', 'L', 'E');
    public static final QuadChar Unknown = new QuadChar('?', '?', '?', '?');
    public static final QuadChar ResourceFork = new QuadChar('F', 'O', 'R', 'K');
    public static final QuadChar Sound = new QuadChar('s', 'n', 'd', ' ');
    private final String typeString;
    private final byte[] quadCharBytes;
    private String mimeType;

    public QuadChar(char one, char two, char three, char four) {
        this(one, two, three, four, null);
    }

    public QuadChar(char one, char two, char three, char four, String mimeType) {
        this.typeString = new String(new char[]{one, two, three, four});
        try {
            this.quadCharBytes = this.typeString.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (mimeType == null) {
            mimeType = "application/unknown";
        }
        this.mimeType = mimeType;
    }

    public QuadChar(String typeString) {
        if (typeString.length() != 4) {
            throw new IllegalArgumentException("You tried to create a QuadChar with a string of length: " + typeString.length());
        }
        this.typeString = typeString;
        try {
            this.quadCharBytes = typeString.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.typeString;
    }

    @NotNull
    public byte[] getQuadCharBytesUTF16LE() {
        if (this.quadCharBytes == null) {
            QuadChar.$$$reportNull$$$0(0);
        }
        return this.quadCharBytes;
    }

    public int hashCode() {
        return this.typeString.hashCode();
    }

    public boolean equals(Object obj) {
        return this.typeString.equals(((QuadChar)obj).typeString);
    }

    public boolean isImage() {
        return this == ImageJPEG || this == ImageGIF || this == ImagePng || this == ImagePICT || this == ImageEPS && Platform.isMac() || this == ImageBMP;
    }

    public static QuadChar forFilename(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename must not be null.");
        }
        String low = filename.toLowerCase();
        if (low.endsWith("jpg") || low.endsWith("jpeg")) {
            return ImageJPEG;
        }
        if (low.endsWith("gif")) {
            return ImageGIF;
        }
        if (low.endsWith("pdf")) {
            return ImagePDF;
        }
        if (low.endsWith("png")) {
            return ImagePng;
        }
        if (low.endsWith("bmp")) {
            return ImageBMP;
        }
        if (low.endsWith("pict")) {
            return ImagePICT;
        }
        if (low.endsWith("ps")) {
            return ImageEPS;
        }
        return FileData;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static QuadChar forMimeType(String mimeType) {
        if (mimeType == null || mimeType.indexOf(47) == -1) {
            return null;
        }
        return QuadChar.forFilename(mimeType.replace('/', '.'));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/fmkit/QuadChar", "getQuadCharBytesUTF16LE"));
    }
}

