/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.BadApiVersionException;
import com.prosc.fmkit.CodeToParent;
import com.prosc.fmkit.Configurable;
import com.prosc.fmkit.FMException;
import com.prosc.fmkit.FMFunction;
import com.prosc.fmkit.FileMakerOperation;
import com.prosc.fmkit.GuiMode;
import com.prosc.fmkit.IdleHandler;
import com.prosc.fmkit.InitializationFailedException;
import com.prosc.fmkit.JackOutputStream;
import com.prosc.fmkit.MethodScanner;
import com.prosc.fmkit.PipeChild;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginException;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.StaticFunction;
import com.prosc.fmkit.types.FMBinary;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMNumber;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMTime;
import com.prosc.fmkit.types.FMType;
import com.prosc.infrastructure.Platform;
import com.prosc.laf.WindowsFontPatch;
import com.prosc.license.client.ExpiredLicenseException;
import com.prosc.shared.StringUtils;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginBridge2 {
    private static final Logger log = Logger.getLogger(PluginBridge2.class.getName());
    private static final Level DEFAULT_LOG_LEVEL = Level.CONFIG;
    private File tempFile;
    public static final short FM_PRO = 0;
    public static final short FM_DEVELOPER = 1;
    public static final short FM_RUNTIME = 2;
    public static final short FM_SERVER = 3;
    public static final short FM_WEB = 4;
    public static final short FM_MOBILE = 5;
    public static final short FM_SERVER12 = 7;
    public static final short FM_WEB12 = 8;
    public static final short IDLESTATE_IDLE = 0;
    public static final short IDLESTATE_NOTIDLE = 1;
    public static final short IDLESTATE_SCRIPT_PAUSED = 2;
    public static final short IDLESTATE_SCRIPT_RUNNING = 3;
    public static final short IDLESTATE_UNSAFE = 4;
    public static final short SCRIPT_HALT = 0;
    public static final short SCRIPT_EXIT = 1;
    public static final short SCRIPT_RESUME = 2;
    public static final short SCRIPT_PAUSE = 3;
    public static final short VERSION_40 = 11;
    public static final short VERSION_41 = 12;
    public static final short VERSION_50 = 14;
    public static final short VERSION_60 = 17;
    public static final short VERSION_70 = 50;
    public static final short VERSION_80 = 51;
    public static final short VERSION_11 = 52;
    public static final short VERSION_12 = 53;
    public static final short VERSION_13 = 54;
    public static final short VERSION_14 = 55;
    public static final short VERSION_15 = 56;
    public static final short VERSION_16 = 57;
    public static final short BAD_VERSION = -1;
    public static final short DO_NOT_ENABLE = -2;
    private static final short VERSION_MIN = 4;
    private static final short VERSION_MAX = 255;
    private static final String CR;
    private static short applicationType;
    private final short apiVersion;
    private final String versionString;
    final short majorVersion;
    private final long instanceID;
    private final String pluginClassName;
    private final Class<? extends Plugin> pluginClass;
    private final String bundlePathString;
    private final File logFile;
    private final File pluginFile;
    private final File pluginJar;
    private final Float jreVersion = Float.valueOf(System.getProperty("java.specification.version"));
    private final PipeChild pipe;
    private JarFile pluginJarFile;
    private Thread mainThread = null;
    private final Plugin firstPlugin;
    private List<PluginFunction> functionsToRegister;
    private final Map<Short, PluginFunction> idToCalcFunctionMap;
    private final Map<Short, PluginFunction> idToScriptStepMap;
    private int callCounter = 0;
    private long launchTime = System.currentTimeMillis();
    private Map<Long, Plugin> threadIdToPlugin = new HashMap<Long, Plugin>();
    private Map<Long, Plugin> sessionIdToPlugin = new HashMap<Long, Plugin>(2);
    private volatile boolean inShutdownProcess = false;
    boolean fxEnabled = false;
    private static String lastActiveAppName;

    PipeChild getPipe() {
        return this.pipe;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    protected PluginBridge2(Class pluginClass) {
        this.apiVersion = 0;
        this.versionString = null;
        this.majorVersion = 0;
        this.instanceID = 0L;
        this.pluginClass = pluginClass;
        this.pluginClassName = pluginClass.getName();
        this.bundlePathString = null;
        this.logFile = null;
        this.pluginFile = null;
        this.pluginJar = null;
        this.pipe = null;
        this.firstPlugin = null;
        this.idToCalcFunctionMap = null;
        this.idToScriptStepMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PluginBridge2(PipeChild pipe, String pathInfo, String logFilePath, short applicationType, short apiVersion, String versionString, long instanceID, boolean unsafeCalls, long firstThreadId) throws BadApiVersionException, InitializationFailedException {
        log.info("Creating PluginBridge");
        this.logFile = new File(logFilePath);
        if (apiVersion < 4 || apiVersion > 255) {
            throw new BadApiVersionException("FileMaker API version is not supported: " + apiVersion);
        }
        this.functionsToRegister = new LinkedList<PluginFunction>();
        this.idToCalcFunctionMap = new HashMap<Short, PluginFunction>();
        this.idToScriptStepMap = new HashMap<Short, PluginFunction>();
        this.pipe = pipe;
        log.info("fmxInit(" + apiVersion + ", " + applicationType + ", " + versionString + ", " + instanceID + ", " + unsafeCalls + "). PluginBridge version 2.0");
        this.versionString = versionString;
        PluginBridge2.applicationType = applicationType;
        this.apiVersion = apiVersion;
        this.instanceID = instanceID;
        if (versionString == null) {
            this.majorVersion = (short)12;
        } else {
            String versionStringWithDecimals = versionString.replaceAll("[^0-9\\.]", "");
            this.majorVersion = Short.valueOf(versionStringWithDecimals.substring(0, versionStringWithDecimals.indexOf(".")));
        }
        String pathToJarFile = pathInfo;
        int semicolonIndex = pathInfo.indexOf(";");
        if (semicolonIndex > 0) {
            pathToJarFile = pathInfo.substring(semicolonIndex + 1);
            this.bundlePathString = pathInfo.substring(0, semicolonIndex);
        } else {
            this.bundlePathString = pathInfo;
        }
        File bundleFile = new File(this.bundlePathString);
        if (!bundleFile.exists()) {
            throw new InitializationFailedException("bundle path does not exist: " + bundleFile.getAbsolutePath());
        }
        try {
            if (bundleFile.isDirectory() && bundleFile.getName().equalsIgnoreCase("Resources")) {
                File pluginJarCandidate;
                Path libPath = Paths.get(bundleFile.getAbsolutePath(), "libJavaWindowMgr.dylib");
                if (libPath.toFile().exists()) {
                    log.log(Level.INFO, "Preparing to load window manager dynamic library at " + libPath.toString());
                    System.load(libPath.toString());
                }
                this.pluginFile = bundleFile.getParentFile().getParentFile();
                log.log(Level.FINE, "Initializing MAC plugin");
                this.pluginJar = pluginJarCandidate = new File(bundleFile, "Java/plugin.jar");
                log.log(Level.CONFIG, "Loading plugin jar at {0}", this.pluginJar.getAbsolutePath());
                this.pluginClassName = PluginBridge2.getPluginClassNameForPluginJar(this.pluginJar);
                this.pluginClass = Class.forName(this.pluginClassName);
            } else if (bundleFile.getName().endsWith(".fmx") || bundleFile.getName().endsWith(".fmx64")) {
                log.log(Level.FINE, "Initializing WIN/LIN plugin");
                this.pluginJar = new File(pathToJarFile);
                log.log(Level.CONFIG, "Loading plugin jar at {0}", this.pluginJar.getAbsolutePath());
                this.pluginClassName = PluginBridge2.getPluginClassNameForPluginJar(this.pluginJar);
                this.pluginClass = Class.forName(this.pluginClassName);
                this.pluginFile = bundleFile;
            } else {
                String msg = "Unknown bundlePath format '" + pathInfo + "' -- should end in '.fmx', '.fmx64' or 'Resources'.";
                log.log(Level.SEVERE, msg);
                throw new InitializationFailedException(msg);
            }
            log.log(Level.FINE, "PluginBridge2 loaded successfully");
        }
        catch (ClassNotFoundException e) {
            String msg = "Unable to locate current directory context, or could not load plugin class: " + e.getMessage();
            log.log(Level.SEVERE, msg, e);
            throw new InitializationFailedException(msg, e);
        }
        if (this.mainThread == null) {
            this.mainThread = Thread.currentThread();
        }
        if (!PluginBridge2.isHeadless() && Platform.isWin()) {
            new WindowsFontPatch().patch();
        }
        this.firstPlugin = this.createPlugin();
        log.info("Looking up SystemInfo");
        log.config("Initialize " + this.firstPlugin.getName());
        PluginContext pluginContext = new PluginContext(this, unsafeCalls, Thread.currentThread(), firstThreadId, -1L, -1L, null, false);
        this.firstPlugin.pushContext(pluginContext);
        try {
            this.firstPlugin.init(this, true);
            if (!this.firstPlugin.isVersionCompatible(apiVersion, applicationType)) {
                throw new BadApiVersionException("This FileMaker API is not compatible with JaCK: " + apiVersion);
            }
            this.scanFunctions(pluginContext, this.firstPlugin);
            this.registerAllFunctions(pluginContext);
        }
        finally {
            this.firstPlugin.popContext();
        }
    }

    private boolean isSingleInstance() {
        return this.isClient() || this.apiVersion < 56;
    }

    private boolean isClient() {
        return applicationType == 0 || applicationType == 1 || applicationType == 2 || applicationType == 5;
    }

    public long getInstanceID() {
        return this.instanceID;
    }

    private Plugin getPluginForSession(long sessionId, PluginContext pluginContext) {
        if (sessionId == 0L) {
            throw new IllegalArgumentException("Received a 0 sessionId. This should be looked up by the threadId instead of the sessionId.");
        }
        Plugin result = this.sessionIdToPlugin.get(sessionId);
        if (result == null) {
            if (this.sessionIdToPlugin.isEmpty() && this.isSingleInstance()) {
                result = this.firstPlugin;
                result.pushContext(pluginContext);
            } else {
                result = this.createPlugin();
                result.pushContext(pluginContext);
                result.init(this, false);
            }
            this.sessionIdToPlugin.put(sessionId, result);
        } else {
            result.pushContext(pluginContext);
        }
        return result;
    }

    private Plugin getPluginForThread(long threadId, PluginContext pluginContext) {
        if (this.isSingleInstance()) {
            this.firstPlugin.pushContext(pluginContext);
            return this.firstPlugin;
        }
        Plugin result = this.threadIdToPlugin.get(threadId);
        if (result == null) {
            result = this.createPlugin();
            result.pushContext(pluginContext);
            result.init(this, false);
            this.threadIdToPlugin.put(threadId, result);
        } else {
            result.pushContext(pluginContext);
        }
        return result;
    }

    @NotNull
    private Plugin createPlugin() {
        Plugin plugin;
        try {
            log.info("Creating new plug-in instance on thread " + Thread.currentThread().getName());
            Plugin result = this.pluginClass.newInstance();
            result.setApplicationType(applicationType);
            result.setPluginBridge(this);
            plugin = result;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.toString(), e);
            throw new RuntimeException("Could not instantiate plugin: " + e, e);
        }
        if (plugin == null) {
            PluginBridge2.$$$reportNull$$$0(0);
        }
        return plugin;
    }

    public File getPluginFile() {
        return this.pluginFile;
    }

    public File getPluginJar() {
        return this.pluginJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPluginClassNameForPluginJar(File pluginFile) {
        String result;
        try {
            log.log(Level.FINE, "Reading Manifest file to determine plugin className");
            try (JarFile pluginJarFile = new JarFile(pluginFile, true);){
                Manifest manifest = pluginJarFile.getManifest();
                result = manifest.getMainAttributes().getValue("pluginClassName");
                if (result == null) {
                    result = manifest.getMainAttributes().getValue("main-class");
                }
            }
        }
        catch (IOException e) {
            String message = "Unable to parse manifest data from " + pluginFile;
            log.severe(message);
            throw new RuntimeException(message, e);
        }
        log.log(Level.CONFIG, "Loading Plugin class named {0}", result);
        return result;
    }

    @NotNull
    File getLogFile() {
        File file = this.logFile;
        if (file == null) {
            PluginBridge2.$$$reportNull$$$0(1);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fmxIdle(short idleState, boolean unsafeCalls, long parentThreadId, long sessionId) {
        if (unsafeCalls) {
            return;
        }
        if (this.inShutdownProcess) {
            return;
        }
        try {
            if (Thread.currentThread() != this.mainThread) {
                return;
            }
            PluginContext context = new PluginContext(this, false, Thread.currentThread(), parentThreadId, sessionId, -1L, null, false);
            Plugin plugin = sessionId == 0L ? this.getPluginForThread(parentThreadId, context) : this.getPluginForSession(sessionId, context);
            try {
                ((IdleHandler)((Object)plugin)).doIdle(idleState);
            }
            finally {
                plugin.popContext();
            }
        }
        catch (Exception t) {
            log.log(Level.SEVERE, "Uncaught exception in idle handler", t);
        }
    }

    public void setPluginJarFile(JarFile pluginJarFile) {
        this.pluginJarFile = pluginJarFile;
    }

    void fmxShutdown(boolean unsafeCalls, long parentThreadId) {
        this.shutdownAWT();
        if (this.tempFile != null && !this.tempFile.delete()) {
            log.warning("Unable to delete file at " + this.tempFile.getAbsolutePath());
        }
        HashSet<Plugin> allPlugins = new HashSet<Plugin>(this.sessionIdToPlugin.values());
        allPlugins.addAll(this.threadIdToPlugin.values());
        allPlugins.add(this.firstPlugin);
        try {
            this.inShutdownProcess = true;
            log.log(Level.FINE, "java running in headless mode: " + (PluginBridge2.isHeadless() ? "true" : "false"));
            log.info("About to shut down allPlugins");
            PluginContext pluginContext = new PluginContext(this, unsafeCalls, Thread.currentThread(), parentThreadId, -1L, -1L, null, false);
            for (Plugin thePlugin : allPlugins) {
                thePlugin.pushContext(pluginContext);
                thePlugin.shutdown();
            }
            this.threadIdToPlugin.clear();
            if (this.pluginJarFile != null) {
                try {
                    this.pluginJarFile.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Could not close the pluginJarFile", e);
                }
            }
            if ((double)this.jreVersion.floatValue() >= 1.6) {
                // empty if block
            }
            System.setIn(null);
            Thread.currentThread().setContextClassLoader(null);
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Could not shut down plugin", e);
            this.inShutdownProcess = false;
        }
        log.info("Pop all plugin contexts");
        for (Plugin plugin : allPlugins) {
            plugin.popContext();
        }
        log.info("PluginBridge2 shutdown finished");
    }

    void shutdownAWT() {
        if (!PluginBridge2.isHeadless()) {
            Thread[] activeThreads = new Thread[Thread.activeCount()];
            int threadCount = Thread.enumerate(activeThreads);
            Stream.of(Window.getWindows()).forEach(Window::dispose);
            RepaintManager.setCurrentManager(null);
            long waitStartTime = System.currentTimeMillis();
            try {
                while (true) {
                    boolean eventDispatchIsRunning = false;
                    for (int n = 0; n < threadCount; ++n) {
                        if (!activeThreads[n].toString().contains("AWT-EventQueue")) continue;
                        eventDispatchIsRunning = true;
                        break;
                    }
                    long waitDuration = System.currentTimeMillis() - waitStartTime;
                    if (!eventDispatchIsRunning) {
                        log.info("Event Dispatch Thread took " + waitDuration + "ms to stop. Active threads: " + Arrays.asList(activeThreads));
                        break;
                    }
                    if (waitDuration > 3000L) {
                        log.warning("EventDispatch thread did not stop after " + waitDuration + "ms; exiting anyway. Active threads: " + Arrays.asList(activeThreads));
                        break;
                    }
                    Thread.sleep(100L);
                    activeThreads = new Thread[Thread.activeCount()];
                    threadCount = Thread.enumerate(activeThreads);
                }
            }
            catch (InterruptedException e) {
                log.log(Level.WARNING, "Thread was interrupted while waiting for EventDispatch thread to finish", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fmxDoAppPreferences(boolean unsafeCalls, long parentThreadId) {
        block7: {
            try {
                Plugin thePlugin = this.firstPlugin;
                if (!(thePlugin instanceof Configurable)) break block7;
                if (PluginBridge2.isHeadless()) {
                    log.warning("Cannot show preferences in headless mode");
                    return;
                }
                log.log(Level.CONFIG, "Configuring {0}", thePlugin);
                try {
                    thePlugin.pushContext(new PluginContext(this, unsafeCalls, Thread.currentThread(), parentThreadId, -1L, -1L, null, false));
                    SwingUtilities.invokeAndWait(() -> {
                        if (thePlugin.isWindowManagementEnabled()) {
                            thePlugin.initFrame();
                            ((Configurable)((Object)thePlugin)).configure();
                            thePlugin.disposeFrame();
                        } else {
                            ((Configurable)((Object)thePlugin)).configure();
                        }
                    });
                }
                finally {
                    thePlugin.popContext();
                }
                log.info("Finished doing app preferences");
            }
            catch (ThreadDeath d) {
                throw d;
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Unexpected exception while displaying preferences", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short doFunction(short functionID, long[] parameterTokens, long resultHolderCToken, boolean unsafeCalls, long parentThreadId, long sessionId, long fileId, boolean isGui) {
        int result;
        GuiMode guiMode;
        long startTime = System.currentTimeMillis();
        PluginFunction scriptStepPluginFunction = this.idToScriptStepMap.get(functionID);
        boolean isScriptStep = scriptStepPluginFunction != null;
        PluginFunction calculationPluginFunction = this.idToCalcFunctionMap.get(functionID);
        final PluginFunction theFunction = isScriptStep ? scriptStepPluginFunction : calculationPluginFunction;
        log.info("--> Invoking function " + theFunction.getName());
        if (isGui && theFunction.getJavaMethod() != null && !PluginBridge2.isHeadless()) {
            FMFunction annotation = theFunction.getJavaMethod().getAnnotation(FMFunction.class);
            guiMode = annotation.gui();
        } else {
            guiMode = GuiMode.None;
        }
        try {
            block38: {
                int n;
                if (theFunction == null) {
                    throw new FMException(-3, "No function registered for code " + functionID);
                }
                log.fine("=== doFunction " + theFunction.getName() + " called on thread: " + Thread.currentThread().getName() + " ===");
                log.log(Level.FINER, "{0} will invoke function {1} with {2} arguments", new Object[]{this, theFunction, parameterTokens.length});
                if (log.isLoggable(Level.FINEST)) {
                    StringBuilder tokens = new StringBuilder("Parameter tokens for call to " + theFunction.getName() + ": ");
                    for (n = 0; n < parameterTokens.length; ++n) {
                        if (n > 0) {
                            tokens.append("; ");
                        }
                        tokens.append("[").append(n).append("]=").append(parameterTokens[n]);
                    }
                    log.finest(tokens.toString());
                }
                FMData[] rawParameters = new FMData[parameterTokens.length];
                for (n = 0; n < parameterTokens.length; ++n) {
                    rawParameters[n] = new FMData(parameterTokens[n], Thread.currentThread());
                }
                Thread mainThread = Thread.currentThread();
                final PluginContext pluginContext = new PluginContext(this, unsafeCalls, mainThread, parentThreadId, sessionId, fileId, theFunction, isScriptStep);
                Object[] convertedParams = new Object[]{};
                log.log(Level.FINER, "Created new PluginContext {0}", pluginContext);
                final Plugin plugin = sessionId == 0L ? this.getPluginForThread(parentThreadId, pluginContext) : this.getPluginForSession(sessionId, pluginContext);
                try {
                    Exception paramConvertException = null;
                    try {
                        convertedParams = theFunction.convertParams(rawParameters, pluginContext);
                    }
                    catch (Exception e) {
                        paramConvertException = e;
                    }
                    final Object[] finalConvertedParams = convertedParams;
                    final Exception finalParamConvertException = paramConvertException;
                    Callable<Short> pluginTask = new Callable<Short>(){

                        @Override
                        public Short call() {
                            log.config("=== Executing plugin function " + theFunction.getName() + " on thread " + Thread.currentThread().getName() + " ===");
                            plugin.invokeFunctionNoErrors(theFunction, pluginContext, finalConvertedParams, finalParamConvertException, guiMode);
                            log.log(Level.FINE, "Invocation of {0} successful on thread {1}", new Object[]{theFunction, Thread.currentThread().getName()});
                            return (short)0;
                        }

                        public String toString() {
                            return "Run task for plugin function: " + theFunction;
                        }
                    };
                    result = ((Short)pluginTask.call()).shortValue();
                    FMData resultHolder = new FMData(resultHolderCToken, mainThread);
                    Throwable lastError = plugin.getLastError();
                    if (lastError == null || !pluginContext.isScriptStep() || this.apiVersion < 57) {
                        FMType functionResult = pluginContext.getFunctionResult();
                        if (functionResult == null) {
                            log.log(Level.FINE, "Function result was null in main thread " + Thread.currentThread().getName() + " for " + theFunction);
                            if (!(pluginContext.isScriptStep() || theFunction.getJavaMethod() != null && theFunction.getJavaMethod().getReturnType() != Void.TYPE)) {
                                new FMNumber(1).writeToData(pluginContext, resultHolder);
                            }
                        } else {
                            functionResult.writeToData(pluginContext, resultHolder);
                        }
                    } else {
                        String errorMessage;
                        result = 1552;
                        if (!(lastError instanceof IllegalArgumentException) && !(lastError instanceof IllegalStateException) && (lastError instanceof RuntimeException || lastError instanceof Error)) {
                            errorMessage = lastError.toString();
                        } else {
                            errorMessage = lastError.getLocalizedMessage();
                            if (lastError instanceof PluginException) {
                                result = ((PluginException)lastError).getErrorCode();
                            }
                        }
                        new FMText(pluginContext, errorMessage).writeToData(pluginContext, resultHolder);
                    }
                    Throwable lastErrorComplainedAbout = plugin.lastErrorComplainedAbout;
                    Boolean isErrorVisible = plugin.isErrorVisible;
                    if (isScriptStep || lastError == null || lastError == lastErrorComplainedAbout || PluginBridge2.isHeadless() || plugin.isErrorCapture() || isErrorVisible.booleanValue() || !plugin.isWindowManagementEnabled()) break block38;
                    try {
                        if (pluginContext.evaluateExpression("not isEmpty( Get( ScriptName ) )").getLongData(pluginContext) == 1L) {
                            plugin.lastErrorComplainedAbout = lastError;
                            String lastErrorString = plugin.getLastErrorString();
                            this.setIsErrorVisible(plugin, true);
                            pluginContext.callback(CodeToParent.onError, out -> {
                                out.writeUTF16String(lastErrorString);
                                out.writeInt(0);
                                out.writeBoolean(lastError instanceof ExpiredLicenseException);
                            }, null);
                        }
                        this.setIsErrorVisible(plugin, false);
                    }
                    catch (Throwable t) {
                        try {
                            log.log(Level.SEVERE, "Unable to show error dialog for " + lastError, t);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.setIsErrorVisible(plugin, false);
                        }
                    }
                }
                finally {
                    plugin.popContext();
                    if (plugin.currentContextStack.size() == 0) {
                        this.pipe.callback(CodeToParent.clearMemory, parentThreadId, null, null);
                    }
                }
            }
            if (++this.callCounter == 10000) {
                log.fine("Garbage collection");
                System.gc();
                this.callCounter = 0;
            }
        }
        catch (FMException e) {
            log.log(Level.SEVERE, "FMException: " + e.toString(), e);
            result = e.getErrorCode();
        }
        catch (ThreadDeath e) {
            log.log(Level.SEVERE, "Received ThreadDeath: " + e.toString(), e);
            throw e;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Throwable: " + t.toString(), t);
            result = -1;
        }
        finally {
            if (theFunction != null) {
                log.fine("finished doFunction: " + theFunction.getName());
            }
        }
        if (log.isLoggable(Level.FINE)) {
            int duration = (int)(System.currentTimeMillis() - startTime);
            log.fine("Plugin function completed in " + duration + " milliseconds");
        }
        return (short)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueFileMakerOperation(FileMakerOperation runnable, @NotNull Plugin plugin, boolean block) throws InterruptedException {
        PluginContext context;
        if (plugin == null) {
            PluginBridge2.$$$reportNull$$$0(2);
        }
        if ((context = plugin.currentContextStack.peek()).getFilemakerThread() == Thread.currentThread()) {
            runnable.run(context);
        } else {
            plugin.operationQueue.addLast(runnable);
            if (block) {
                LinkedList<FileMakerOperation> linkedList = plugin.operationQueue;
                synchronized (linkedList) {
                    while (plugin.operationQueue.contains(runnable)) {
                        plugin.operationQueue.wait();
                    }
                }
            }
        }
    }

    private void scanFunctions(PluginContext pluginContext, Plugin thePlugin) {
        log.log(Level.FINE, "{0} scanning functions", this);
        for (Method eachMethod : MethodScanner.findFMFunctions(thePlugin.getClass())) {
            if (eachMethod.getName().equals("invokeFunction") || Modifier.isStatic(eachMethod.getModifiers())) continue;
            try {
                StaticFunction eachFunction = new StaticFunction(eachMethod, this);
                String prototype = "";
                FMFunction annotation = eachFunction.getTargetMethod().getAnnotation(FMFunction.class);
                if (annotation == null) {
                    String prototypeMethodName = eachFunction.getName() + "Prototype";
                    try {
                        Method prototypeMethod = thePlugin.getClass().getMethod(prototypeMethodName, new Class[0]);
                        prototype = (String)prototypeMethod.invoke((Object)thePlugin, new Object[0]);
                        log.finer("Found prototype method named " + prototypeMethodName + " which returned " + prototype);
                    }
                    catch (NoSuchMethodException e) {
                        log.fine("Couldn't find prototype method: " + prototypeMethodName);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Error when trying to invoke the prototype method", e);
                    }
                } else {
                    if (!thePlugin.getVersion().isAtLeast(annotation.minimumVersion())) {
                        log.log(Level.FINE, "Plugin function " + eachMethod.getName() + " requires version " + annotation.minimumVersion() + ", but plugin is version " + thePlugin.getVersion().stringVersion);
                        continue;
                    }
                    prototype = annotation.prototype();
                    eachFunction.setTimeoutSeconds(annotation.timeoutSeconds());
                    eachFunction.setDescription(annotation.description());
                    eachFunction.setTypeAheadList(annotation.typeAheadText());
                }
                eachFunction.setPrototype(prototype);
                int firstBracketIndex = prototype.indexOf(91);
                if (firstBracketIndex == -1) {
                    firstBracketIndex = prototype.indexOf(123);
                }
                if (firstBracketIndex >= 0) {
                    int minArgs = prototype.startsWith("[") || prototype.startsWith("{") ? 0 : prototype.substring(0, firstBracketIndex).split(";").length;
                    eachFunction.setMinArgs(minArgs);
                }
                if (!thePlugin.customizeFunction(eachFunction)) continue;
                this.queueFunction(eachFunction);
            }
            catch (FMType.UnsupportedTypeConversionException e) {
                log.log(Level.WARNING, "Can't do conversions for at least one plugin function '" + eachMethod.getName() + "'", e);
            }
        }
    }

    private void queueFunction(PluginFunction theFunction) {
        this.functionsToRegister.add(theFunction);
    }

    private void registerAllFunctions(PluginContext pluginContext) {
        for (PluginFunction aFunctionsToRegister : this.functionsToRegister) {
            this.registerFunction(aFunctionsToRegister, pluginContext, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunction(PluginFunction theFunction, PluginContext pluginContext, boolean isFromScriptMaster) {
        boolean isDuplicateId;
        boolean registerAsScriptStep;
        MethodScanner.ParamInfo paramInfo;
        log.log(Level.INFO, "{0} registering {1}", new Object[]{this, theFunction});
        @Nullable Method javaMethod = theFunction.getJavaMethod();
        @Nullable FMFunction functionAnnotation = javaMethod == null ? null : javaMethod.getAnnotation(FMFunction.class);
        Object functionSignature = theFunction.getPrototype().trim().length() > 0 ? theFunction.getName() + "( " + theFunction.getPrototype() + " )" : theFunction.getName();
        boolean registerAsCalc = functionAnnotation == null || functionAnnotation.showInCalcs();
        try {
            paramInfo = MethodScanner.parsePrototype(javaMethod, theFunction.getPrototype());
            registerAsScriptStep = functionAnnotation != null && functionAnnotation.showInScriptSteps();
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, e.getMessage());
            paramInfo = null;
            registerAsScriptStep = false;
        }
        String description = theFunction.getDescription();
        Object[] typeAheadList = theFunction.getTypeAheadList();
        Object typeAheadDescription = typeAheadList != null && description != null ? StringUtils.join(typeAheadList, " ") + "|" + description : (typeAheadList != null ? StringUtils.join(typeAheadList, " ") + "|" : (description != null ? "|" + description : ""));
        if (registerAsCalc) {
            HashSet<Short> functionIds = new HashSet<Short>(1);
            if (isFromScriptMaster) {
                functionIds.add((short)theFunction.getName().hashCode());
            } else {
                functionIds.add((short)Math.abs(theFunction.getName().hashCode()));
            }
            for (Short calcFunctionId : functionIds) {
                do {
                    PluginFunction oldFunction;
                    if ((oldFunction = this.idToCalcFunctionMap.get(calcFunctionId)) == null) {
                        oldFunction = this.idToScriptStepMap.get(calcFunctionId);
                    }
                    if (oldFunction != null) {
                        if (oldFunction.getName().equals(theFunction.getName())) {
                            log.warning("Function " + theFunction.getName() + " with ID " + calcFunctionId + " has already been registered with the function ID for " + oldFunction.getName() + ". " + theFunction.getName() + " will replace it in the function list.");
                            short calcFunctionIdFinal = calcFunctionId;
                            this.pipe.callback(CodeToParent.unregisterFunction, pluginContext.getParentThreadId(), out -> out.writeShort(calcFunctionIdFinal), null);
                            isDuplicateId = false;
                            continue;
                        }
                        Short calcFunctionIdFinal = calcFunctionId;
                        calcFunctionId = (short)(calcFunctionId + 1);
                        log.warning("Function: " + theFunction.getName() + " assigned new ID to avoid overwriting function: " + oldFunction.getName());
                        isDuplicateId = true;
                        continue;
                    }
                    isDuplicateId = false;
                } while (isDuplicateId);
                try {
                    short calcFunctionIdFinal = calcFunctionId;
                    log.info("Registering the calc function in C++ with functionId " + calcFunctionId + ", " + theFunction.getName() + ", " + (String)functionSignature + ", " + theFunction.getMinArgs() + ", " + theFunction.getMaxArgs() + ", " + theFunction.getCalculationFunctionFlags(pluginContext));
                    int timeout = 30;
                    boolean isGui = false;
                    if (!(theFunction instanceof StaticFunction)) {
                        isGui = theFunction.isGuiFunction();
                    } else if (theFunction.getJavaMethod() != null) {
                        isGui = !GuiMode.None.equals((Object)theFunction.getJavaMethod().getAnnotation(FMFunction.class).gui());
                        timeout = isGui ? 0 : theFunction.getJavaMethod().getAnnotation(FMFunction.class).timeoutSeconds();
                    }
                    int finalTimeout = timeout;
                    boolean finalIsGui = isGui;
                    this.pipe.callback(CodeToParent.registerFunction, pluginContext.getParentThreadId(), arg_0 -> this.lambda$registerFunction$3(calcFunctionIdFinal, theFunction, (String)functionSignature, pluginContext, finalTimeout, finalIsGui, (String)typeAheadDescription, arg_0), null);
                }
                finally {
                    log.fine("_registerFunction returned");
                }
                this.idToCalcFunctionMap.put(calcFunctionId, theFunction);
            }
        }
        if (this.getApiVersion() >= 57 && registerAsScriptStep) {
            log.info("registerAsScriptStep for function " + theFunction.getName());
            StringBuilder xml = new StringBuilder();
            xml.append("<pluginstep>");
            if (javaMethod == null || javaMethod.getReturnType() != Void.TYPE) {
                String label = functionAnnotation == null ? "Result" : functionAnnotation.resultName();
                xml.append("<parameter type=\"target\" label=\"").append(label).append("\" showinline=\"").append(true).append("\"></parameter>");
            }
            int n = 0;
            Iterator javaParamIterator = javaMethod == null ? Collections.emptyIterator() : Arrays.asList(javaMethod.getParameterTypes()).iterator();
            Class javaParamType = null;
            int enumIndex = 0;
            for (MethodScanner.PrototypeParameter prototypeParam : paramInfo.params) {
                List<String> enumerationTypes;
                if (javaParamIterator.hasNext() && (javaParamType == null || !javaParamType.isArray())) {
                    javaParamType = (Class)javaParamIterator.next();
                }
                xml.append("<parameter");
                boolean showInline = true;
                Object label = prototypeParam.name;
                label = StringUtils.beautifyAttributeName((String)label);
                if (prototypeParam.optional) {
                    label = (String)label + " (optional)";
                }
                xml.append(" label=\"").append((String)label).append("\"");
                xml.append(" id=\"").append(String.valueOf(n)).append("\"");
                if (javaParamType != null && javaParamType.isEnum()) {
                    log.info("Parameter " + prototypeParam.name + " is an enum type");
                    T[] enumValues = javaParamType.getEnumConstants();
                    enumerationTypes = new ArrayList<String>(enumValues.length + 1);
                    for (Object value : enumValues) {
                        enumerationTypes.add(String.valueOf(value));
                    }
                    log.info("Enumeration values: " + enumerationTypes);
                } else {
                    enumerationTypes = Collections.emptyList();
                }
                if (enumerationTypes.size() > 0) {
                    xml.append(" type=\"list\" ");
                } else if (javaParamType == Boolean.TYPE || javaParamType != null && Boolean.class.isAssignableFrom(javaParamType)) {
                    xml.append(" type=\"bool\"");
                } else {
                    xml.append(" type=\"calc\"");
                }
                if (javaParamType == null || FMText.class.isAssignableFrom(javaParamType) || String.class.isAssignableFrom(javaParamType) || javaParamType.isEnum()) {
                    xml.append(" datatype=\"text\"");
                } else if (FMBinary.class.isAssignableFrom(javaParamType)) {
                    xml.append(" datatype=\"container\"");
                } else if (Number.class.isAssignableFrom(javaParamType) || javaParamType == Boolean.TYPE) {
                    xml.append(" datatype=\"number\"");
                } else if (Date.class.isAssignableFrom(javaParamType)) {
                    xml.append(" datatype=\"date\"");
                } else if (FMTime.class.isAssignableFrom(javaParamType)) {
                    xml.append(" datatype=\"time\"");
                } else if (Timestamp.class.isAssignableFrom(javaParamType)) {
                    xml.append(" datatype=\"timestamp\"");
                } else if (!FMData.class.isAssignableFrom(javaParamType)) {
                    log.warning("Unknown datatype, will assume text: " + javaParamType);
                    xml.append(" datatype=\"text\"");
                }
                xml.append(" showinline=\"").append(showInline).append("\"");
                if (enumerationTypes.size() > 0) {
                    int rangeStart = ++enumIndex * 100;
                    log.info("Setting enum starting index for param " + n + " to " + rangeStart);
                    theFunction.setEnumStartingIndex(n, rangeStart);
                    int choiceIndex = 0;
                    xml.append(">");
                    for (String enumValue : enumerationTypes) {
                        xml.append("<value ");
                        int optionId = rangeStart + choiceIndex;
                        xml.append("id=\"").append(String.valueOf(optionId)).append("\"");
                        xml.append(">").append(enumValue).append("</value>");
                        ++choiceIndex;
                    }
                } else {
                    xml.append(">");
                }
                xml.append("</parameter>");
                ++n;
            }
            xml.append("</pluginstep>");
            log.fine("Script Step XML: " + xml);
            Short scriptStepFunctionId = (short)Math.abs((theFunction.getName() + "ScriptStep").hashCode());
            do {
                PluginFunction oldFunction;
                if ((oldFunction = this.idToScriptStepMap.get(scriptStepFunctionId)) == null) {
                    oldFunction = this.idToCalcFunctionMap.get(scriptStepFunctionId);
                }
                if (oldFunction != null) {
                    if (oldFunction.getName().equals(theFunction.getName())) {
                        log.warning("*** WARNING: function " + theFunction.getName() + " with ID " + scriptStepFunctionId + " has already been registered with the function ID for " + oldFunction.getName() + ". " + theFunction.getName() + " will replace it in the function list.");
                        short scriptStepFunctionIdFinal = scriptStepFunctionId;
                        this.pipe.callback(CodeToParent.unregisterFunction, pluginContext.getParentThreadId(), out -> out.writeShort(scriptStepFunctionIdFinal), null);
                        isDuplicateId = false;
                        continue;
                    }
                    Short scriptStepFunctionIdFinal = scriptStepFunctionId;
                    scriptStepFunctionId = (short)(scriptStepFunctionId + 1);
                    log.warning("*** WARNING: function: " + theFunction.getName() + " assigned new ID to avoid overwriting function: " + oldFunction.getName());
                    isDuplicateId = true;
                    continue;
                }
                isDuplicateId = false;
            } while (isDuplicateId);
            log.fine("Registering the script step function in C++ with functionId " + scriptStepFunctionId + ", " + theFunction.getName() + ", " + (String)functionSignature + ", " + theFunction.getMinArgs() + ", " + theFunction.getMaxArgs() + ", " + theFunction.getCalculationFunctionFlags(pluginContext));
            int timeout = 30;
            boolean isGui = false;
            if (theFunction.getJavaMethod() != null) {
                isGui = !GuiMode.None.equals((Object)theFunction.getJavaMethod().getAnnotation(FMFunction.class).gui());
                timeout = isGui ? 0 : theFunction.getJavaMethod().getAnnotation(FMFunction.class).timeoutSeconds();
            }
            int finalTimeout = timeout;
            boolean finalIsGui = isGui;
            short scriptStepFunctionIdFinal = scriptStepFunctionId;
            this.pipe.callback(CodeToParent.registerScriptStep, pluginContext.getParentThreadId(), arg_0 -> PluginBridge2.lambda$registerFunction$5(scriptStepFunctionIdFinal, theFunction, xml, pluginContext, finalTimeout, finalIsGui, (String)typeAheadDescription, arg_0), null);
            this.idToScriptStepMap.put(scriptStepFunctionIdFinal, theFunction);
        }
    }

    private void unregisterAllFunctions(PluginContext pluginContext) {
        ArrayList<Short> allFunctionIds = new ArrayList<Short>(this.idToCalcFunctionMap.keySet());
        allFunctionIds.addAll(this.idToScriptStepMap.keySet());
        for (Short functionId : allFunctionIds) {
            this.unregisterFunction(functionId, pluginContext);
        }
    }

    public void unregisterFunction(String functionName, PluginContext pluginContext) {
        for (Map.Entry<Short, PluginFunction> entry : this.idToScriptStepMap.entrySet()) {
            if (!functionName.equals(entry.getValue().getName())) continue;
            this.unregisterFunction(entry.getKey(), pluginContext);
            break;
        }
        for (Map.Entry<Short, PluginFunction> entry : this.idToCalcFunctionMap.entrySet()) {
            if (!functionName.equals(entry.getValue().getName())) continue;
            this.unregisterFunction(entry.getKey(), pluginContext);
            break;
        }
    }

    private void unregisterFunction(short functionId, PluginContext pluginContext) {
        log.log(Level.INFO, "{0} unregistering function with ID {1}", new Object[]{this, functionId});
        this.pipe.callback(CodeToParent.unregisterFunction, pluginContext.getParentThreadId(), out -> out.writeShort(functionId), null);
        if (this.getApiVersion() >= 57) {
            this.pipe.callback(CodeToParent.unregisterScriptStep, pluginContext.getParentThreadId(), out -> out.writeShort(functionId), null);
        }
        this.idToCalcFunctionMap.remove(functionId);
        this.idToScriptStepMap.remove(functionId);
    }

    void onSessionEnd(long sessionId, long threadId) {
        Plugin pluginForSession = this.sessionIdToPlugin.remove(sessionId);
        if (pluginForSession != null) {
            try {
                pluginForSession.shutdown();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error occurred while shutting down plugin: " + pluginForSession, t);
            }
        } else {
            log.info("No plugin instance existed for sessionId " + sessionId);
        }
        Plugin pluginForThread = this.threadIdToPlugin.remove(threadId);
        if (pluginForThread != null && pluginForThread != pluginForSession) {
            try {
                pluginForThread.shutdown();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error occurred while shutting down plugin: " + pluginForSession, t);
            }
        }
    }

    void onFileClose(long sessionId, long fileId) {
        Plugin pluginToRemove = this.sessionIdToPlugin.get(sessionId);
        if (pluginToRemove != null) {
            try {
                pluginToRemove.onFileClose(fileId);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error occurred while calling onFileClose() for plugin: " + pluginToRemove, t);
            }
        } else {
            log.info("No plugin instance existed for sessionId " + sessionId);
        }
    }

    void onThreadEnd(long threadId) {
        Plugin pluginToRemove = this.threadIdToPlugin.remove(threadId);
        if (pluginToRemove != null) {
            try {
                pluginToRemove.shutdown();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error occurred while shutting down plugin: " + pluginToRemove, t);
            }
        }
    }

    short getApiVersion() {
        return this.apiVersion;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public static boolean isHeadless() {
        return applicationType != 0 && applicationType != 1 && applicationType != 2 || GraphicsEnvironment.isHeadless();
    }

    private void setIsErrorVisible(Plugin plugin, boolean errorVisible) {
        plugin.isErrorVisible = errorVisible;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    public String toString() {
        return "PluginBridge2{instanceID=" + this.instanceID + "}";
    }

    public static native FileDescriptor createFileDescriptor(int var0);

    public void showErrorDialog(String pluginName, String lastErrorString, int errorLevel, boolean isExpired, long sessionId, long threadId) {
        PluginContext pluginContext = new PluginContext(this, true, Thread.currentThread(), threadId, -1L, -1L, null, false);
        this.firstPlugin.pushContext(pluginContext);
        this.firstPlugin.initFrame();
        Window frame = this.firstPlugin.getFrame();
        try {
            SwingUtilities.invokeAndWait(() -> new JOptionPane(lastErrorString, 0, -1).createDialog(frame, pluginName + " Error").setVisible(true));
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.firstPlugin.disposeFrame();
            this.firstPlugin.popContext();
        }
    }

    private static /* synthetic */ void lambda$registerFunction$5(short scriptStepFunctionIdFinal, PluginFunction theFunction, StringBuilder xml, PluginContext pluginContext, int finalTimeout, boolean finalIsGui, String typeAheadDescription, JackOutputStream out) throws IOException {
        out.writeShort(scriptStepFunctionIdFinal);
        out.writeUTF16String(theFunction.getName());
        out.writeUTF16String(xml.toString());
        out.writeInt(theFunction.getScriptStepFlags(pluginContext));
        out.writeInt(finalTimeout);
        out.writeBoolean(finalIsGui);
        out.writeUTF16String(typeAheadDescription);
    }

    private /* synthetic */ void lambda$registerFunction$3(short calcFunctionIdFinal, PluginFunction theFunction, String functionSignature, PluginContext pluginContext, int finalTimeout, boolean finalIsGui, String typeAheadDescription, JackOutputStream out) throws IOException {
        out.writeShort(calcFunctionIdFinal);
        out.writeUTF16String(theFunction.getName());
        out.writeUTF16String(functionSignature);
        out.writeInt(theFunction.getMinArgs());
        out.writeInt(theFunction.getMaxArgs());
        out.writeInt(theFunction.getCalculationFunctionFlags(pluginContext));
        out.writeInt(finalTimeout);
        out.writeBoolean(finalIsGui);
        if (this.getApiVersion() >= 56) {
            out.writeUTF16String(typeAheadDescription);
        }
    }

    static {
        if (!PluginBridge2.isHeadless()) {
            System.gc();
        }
        CR = System.getProperty("line.separator");
        lastActiveAppName = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/prosc/fmkit/PluginBridge2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlugin";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/prosc/fmkit/PluginBridge2";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "queueFileMakerOperation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

