/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.FMFunction;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.types.FMType;
import com.prosc.shared.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class MethodScanner {
    private static final Logger log = Logger.getLogger(MethodScanner.class.getName());

    public static List<Method> findFMFunctions(Class theClass) {
        Method[] methods;
        LinkedList<Method> result = new LinkedList<Method>();
        try {
            methods = theClass.getMethods();
        }
        catch (NoClassDefFoundError e) {
            log.log(Level.SEVERE, "An error occurred getting methods for class " + theClass.getCanonicalName(), e);
            throw e;
        }
        Arrays.sort(methods, Comparator.comparing(Method::getName));
        for (Method eachMethod : methods) {
            if (eachMethod.getDeclaringClass() == Plugin.class) continue;
            if (eachMethod.getAnnotation(FMFunction.class) != null) {
                result.add(eachMethod);
                continue;
            }
            if ("invokeFunction".equals(eachMethod.getName())) continue;
            if (FMType.class.isAssignableFrom(eachMethod.getReturnType())) {
                log.warning("Method " + eachMethod + " has an FMType return value, but no FMFunction annotation. It will not be registered as a function.");
                continue;
            }
            log.finer("Skipping method: " + eachMethod);
        }
        log.fine("Methods found: " + ((Object)result).toString());
        return result;
    }

    public static ParamInfo parsePrototype(@Nullable Method javaMethod, String functionPrototype) throws IllegalArgumentException {
        ParamInfo result = new ParamInfo();
        String[] paramNamesArray = StringUtils.isEmpty(functionPrototype) ? new String[]{} : functionPrototype.trim().split(";");
        result.params = new ArrayList<PrototypeParameter>(paramNamesArray.length);
        boolean optional = false;
        int requiredPrototypeCount = 0;
        int prototypeCount = paramNamesArray.length;
        for (String paramName : paramNamesArray) {
            String trim = paramName.trim();
            if (trim.length() <= 0) continue;
            if (trim.startsWith("{")) {
                optional = true;
                trim = trim.substring(1).trim();
            }
            boolean optionalAfter = false;
            if (trim.endsWith("{") || trim.endsWith("}")) {
                trim = trim.substring(0, trim.length() - 1).trim();
                optionalAfter = true;
            }
            if (trim.contains("=")) continue;
            PrototypeParameter param = new PrototypeParameter(trim, optional);
            if (!optional) {
                ++requiredPrototypeCount;
            }
            if (optionalAfter) {
                optional = true;
            }
            if (trim.contains("...")) {
                if (!param.optional) {
                    String functionName = javaMethod == null ? "<unknown>" : javaMethod.getName();
                    throw new IllegalArgumentException("for function " + functionName + ",... variable arguments must be enclosed in {} to indicate that they are optional");
                }
                result.varargs = true;
                continue;
            }
            result.params.add(param);
        }
        if (javaMethod != null) {
            boolean javaArray = false;
            for (Parameter javaParam : javaMethod.getParameters()) {
                if (!javaParam.getType().isArray()) continue;
                javaArray = true;
            }
            if (result.varargs ? !javaArray && javaMethod.getParameters().length < prototypeCount : (javaArray ? javaMethod.getParameters().length > prototypeCount : javaMethod.getParameters().length != prototypeCount)) {
                throw new IllegalArgumentException("For method '" + javaMethod.getName() + "', there are " + prototypeCount + " parameters in the prototype but " + javaMethod.getParameters().length + " parameters in the Java method signature. Will not register this function as a script step because the prototype is incorrect and unparseable.");
            }
        }
        return result;
    }

    static class ParamInfo {
        List<PrototypeParameter> params;
        boolean varargs = false;

        ParamInfo() {
        }
    }

    static class PrototypeParameter {
        String name;
        boolean optional;

        PrototypeParameter(String name, boolean optional) {
            this.name = name;
            this.optional = optional;
        }
    }
}

