/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.shared.StringUtils;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class FMPXMLExport {
    private static final Format dateFormatter = new SimpleDateFormat("MM/dd/yyyy");
    private static final Format timeFormatter = DateFormat.getTimeInstance(2);
    private List rows;
    private Number errorCode = new Integer(0);
    private Collection fieldNames;

    public void setRows(List newRows) {
        this.rows = newRows;
    }

    public String getXMLString() {
        StringBuffer out = new StringBuffer(1024);
        out.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        out.append("<FMPXMLRESULT xmlns=\"http://www.filemaker.com/fmpxmlresult\"><ERRORCODE>").append(this.getErrorCode()).append("</ERRORCODE>\n\t<PRODUCT BUILD=\"11/22/2002\" NAME=\"com.prosc.fm.FMPXMLExport\" VERSION=\"1.0\" />\n\t<DATABASE DATEFORMAT=\"MM/dd/yyyy\" LAYOUT=\"\" NAME=\"\" RECORDS=\"\" TIMEFORMAT=\"HH:mm:ss\" />\n");
        this.appendResultSetToBuffer(out);
        out.append("</FMPXMLRESULT>");
        return out.toString();
    }

    public Number getErrorCode() {
        if (this.rows == null || this.rows.size() == 0) {
            return new Integer(401);
        }
        return this.errorCode;
    }

    public void setErrorCode(Number errorCode) {
        this.errorCode = errorCode;
    }

    private void appendResultSetToBuffer(StringBuffer out) {
        if (this.rows == null || this.rows.size() == 0) {
            out.append("\t<METADATA/>\n");
            out.append("\t<RESULTSET FOUND=\"0\"/>");
            return;
        }
        out.append("\t<METADATA>\n");
        Collection fieldNames = this.getFieldNames();
        for (String keyName : fieldNames) {
            keyName = StringUtils.escapeXMLString(keyName);
            out.append("\t\t<FIELD EMPTYOK=\"YES\" MAXREPEAT=\"1\" TYPE=\"TEXT\" NAME=\"").append(keyName).append("\" />\n");
        }
        out.append("\t</METADATA>\n");
        out.append("\t<RESULTSET FOUND=\"").append(this.rows.size()).append("\">\n");
        for (Map aRow : this.rows) {
            out.append("\t\t<ROW MODID=\"0\" RECORDID=\"0\">");
            for (Object eachFieldName : fieldNames) {
                String aValue = this.stringForColumnValue(aRow.get(eachFieldName));
                out.append("<COL><DATA>");
                StringUtils.escapeXMLString(aValue, out);
                out.append("</DATA></COL>");
            }
            out.append("</ROW>\n");
        }
        out.append("\t</RESULTSET>\n");
    }

    private Collection getFieldNames() {
        if (this.fieldNames == null) {
            if (this.rows != null && this.rows.size() > 0) {
                this.fieldNames = ((Map)this.rows.get(0)).keySet();
            } else {
                this.fieldNames = new ArrayList(1);
                this.fieldNames.add("empty");
            }
        }
        return this.fieldNames;
    }

    public void setFieldNames(Collection fieldNames) {
        this.fieldNames = fieldNames;
    }

    private String stringForColumnValue(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            if (((Date)o).getTime() < 172800000L) {
                return timeFormatter.format(o);
            }
            return dateFormatter.format(o);
        }
        return String.valueOf(o);
    }
}

