/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell;

import com._360works.x_360store.AuthenticatedUser;
import com._360works.x_360store.CreateScriptMasterPlugin;
import com._360works.x_360store.CreateScriptMasterPluginResponse;
import com._360works.x_360store.CreateScriptMasterPluginService;
import com._360works.x_360store.CreateScriptMasterPluginService_Service;
import com.prosc.beanshell.BeanShellPlugin;
import com.prosc.beanshell.EvaluateException;
import com.prosc.beanshell.FMPro;
import com.prosc.beanshell.FunctionDefinition;
import com.prosc.beanshell.compilation.CompiledClass;
import com.prosc.beanshell.compilation.FunctionCompiler;
import com.prosc.core.FeedbackException;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.SearchAndReplace;
import com.prosc.io.IOUtils;
import com.prosc.misc.security.JarUtils;
import com.prosc.shared.DebugTimer;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.ws.BindingProvider;
import org.codehaus.groovy.control.CompilationFailedException;
import org.jetbrains.annotations.NotNull;

public class BeanShellModel {
    private static final Logger log = Logger.getLogger(BeanShellModel.class.getName());
    public static final String GROOVY = "groovy";
    public static final String JAVASCRIPT = "javascript";
    private static final String CREATE_PLUGIN_ENDPOINT = "https://plugincreator.360works.com/create_plugin/";
    private static final XMLEventFactory xmlEventFactory = XMLEventFactory.newFactory();
    private static CreateScriptMasterPluginService createPluginPort;
    private Binding binding;
    private ClassLoader customClassLoader;
    private URL[] urls;
    private Map threadMap = Collections.synchronizedMap(new HashMap());
    private FMPro fmpro;

    public BeanShellModel(FMPro fmpro) {
        this.fmpro = fmpro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String evaluateRuntimeCommand(String command, boolean runInBackground) throws IOException, InterruptedException, EvaluateException {
        log.log(Level.INFO, command);
        BufferedReader input = null;
        BufferedReader error = null;
        try {
            Process process = Runtime.getRuntime().exec(command);
            if (runInBackground) {
                String string = null;
                return string;
            }
            input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new EvaluateException(this._readerContents(error), exitCode);
            }
            String string = this._readerContents(input);
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (error != null) {
                    error.close();
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed closing output stream", e);
            }
        }
    }

    private String _readerContents(BufferedReader reader) throws IOException {
        String eachLine;
        StringBuffer result = new StringBuffer();
        while ((eachLine = reader.readLine()) != null) {
            result.append(eachLine).append("\r");
        }
        return result.toString();
    }

    public Object evaluateGroovy(String script, Map vars, PluginContext pluginContext) throws CompilationFailedException {
        this.binding = new Binding(new HashMap(vars));
        if (this.fmpro != null) {
            this.fmpro.setPluginContext(pluginContext);
        }
        this.binding.setVariable("fmpro", this.fmpro);
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        GroovyShell shell = new GroovyShell(this.getClassLoader(), this.binding);
        return shell.evaluate(script);
    }

    ClassLoader getClassLoader() {
        if (this.urls == null) {
            return this.getClass().getClassLoader();
        }
        if (this.customClassLoader == null) {
            this.customClassLoader = new URLClassLoader(this.urls, this.getClass().getClassLoader());
        }
        return this.customClassLoader;
    }

    public void setAdditionalClasspathUrls(URL[] urls) {
        this.urls = urls;
        this.customClassLoader = null;
    }

    public Object getScriptMasterVariable(String variableName) {
        if (variableName == null) {
            return null;
        }
        if (this.binding == null) {
            throw new IllegalStateException("You can only get ScriptMaster variables after evaluating a script, and before setting any new variables.");
        }
        return this.binding.getVariable(variableName);
    }

    public void clearOldVariables() {
        this.binding = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        BeanShellModel shellModel = new BeanShellModel(null);
        LinkedList<FunctionDefinition> functions = new LinkedList<FunctionDefinition>();
        functions.add(new FunctionDefinition("helloWorld", "println('Hello world')", true));
        try (JarOutputStream jarStream = new JarOutputStream(new FileOutputStream("/tmp/new.jar"));){
            shellModel.generateModulesJar(functions, jarStream);
        }
        URL[] testUrls = new URL[]{new URL("file:/tmp/new.jar")};
        URLClassLoader pluginClassLoader = new URLClassLoader(new URL[]{new URL("file:/Applications/FileMaker%20Pro%2011%20Advanced/Extensions/MyPluginName.fmplugin/Contents/Resources/Java/plugin.jar")});
        URLClassLoader classLoader = new URLClassLoader(testUrls, (ClassLoader)pluginClassLoader);
        Class<?> aClass = classLoader.loadClass("scriptmaster.Module_LTE1NTQxMzU1ODQX");
        Script s = (Script)aClass.newInstance();
        s.run();
    }

    public boolean isRunning(Object id) {
        if (id != null) {
            Thread t = (Thread)this.threadMap.get(id);
            return t != null && t.isAlive();
        }
        return !this.threadMap.isEmpty();
    }

    public void cancel(Object id) {
        if (id != null) {
            Thread t = (Thread)this.threadMap.get(id);
            if (t != null) {
                t.interrupt();
            }
        } else {
            Thread[] allThreads = this.threadMap.values().toArray(new Thread[0]);
            this.threadMap.clear();
            for (int i = 0; i < allThreads.length; ++i) {
                Thread eachThread = allThreads[i];
                try {
                    eachThread.interrupt();
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Failed interrupting thread " + eachThread, e);
                }
            }
        }
    }

    public FMPro getFmpro() {
        return this.fmpro;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String generatePlugin(String pluginName, String quadChar, String pluginPrefix, String helpText, String versionString, String licenseKey, File macSourcePluginDir, File windowsSourcePluginFile, File folderToWriteTo, String registeredTo, Collection<FunctionDefinition> functionsToInclude, File pluginJarFile, Map<String, String> pluginJarAttributes) throws IOException, FeedbackException {
        if (pluginName.indexOf(46) != -1) {
            throw new IllegalArgumentException("pluginName cannot contain dot characters");
        }
        if (quadChar.length() != 4) {
            throw new IllegalArgumentException("quadChar must consist of exactly 4 alphanumeric characters");
        }
        if (helpText == null) {
            helpText = "";
        }
        helpText = helpText.replaceAll("[\\x0A\\x0D]", " ");
        try {
            new BigDecimal(versionString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("versionString must be a strictly numeric value");
        }
        if (!folderToWriteTo.exists()) {
            throw new IllegalArgumentException("No folder exists at " + folderToWriteTo.getAbsolutePath());
        }
        String generatedLicenseKey = this.callWebService(pluginName, helpText, versionString, quadChar, licenseKey, functionsToInclude);
        DebugTimer dt = new DebugTimer("Customizing plugin from jar file");
        folderToWriteTo = new File(folderToWriteTo, pluginName);
        if (macSourcePluginDir != null) {
            dt.markTime("Generating mac plugin");
            File macDir = new File(folderToWriteTo, "MAC");
            File macDestPluginDir = new File(macDir, pluginName + ".fmplugin");
            if (macDestPluginDir.exists()) {
                IOUtils.deleteRecursive(macDestPluginDir);
            }
            if (!macDestPluginDir.exists() && !macDestPluginDir.mkdirs()) {
                throw new IOException("Could not create Mac plugin directory: " + macDestPluginDir);
            }
            BeanShellModel.copyRecursive(macSourcePluginDir, macDestPluginDir);
            File pListFile = new File(macDestPluginDir, "Contents/Info.plist");
            BeanShellModel.setPluginVersionPrefs(pluginName, versionString, pListFile);
            File newJarFile = new File(macDestPluginDir, "Contents/Resources/Java/plugin.jar");
            JarOutputStream jarOutput = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(newJarFile)));
            JarInputStream jarInput = new JarInputStream(new BufferedInputStream(BeanShellModel.getPluginJarStream(pluginJarFile)));
            try {
                this.writeModifiedJar(pluginName, quadChar, pluginPrefix, helpText, versionString, jarInput, pluginJarAttributes, jarOutput);
            }
            finally {
                jarInput.close();
                jarOutput.close();
            }
            File scriptMasterModulesFile = new File(newJarFile.getParentFile(), "scriptmaster_modules.jar");
            try (JarOutputStream modulesOut = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(scriptMasterModulesFile)));){
                this.generateModulesJar(functionsToInclude, modulesOut);
            }
        }
        if (windowsSourcePluginFile != null) {
            dt.markTime("Generating Windows plugin");
            if (windowsSourcePluginFile.isDirectory()) {
                throw new FeedbackException("You selected a directory when you should have selected the ScriptMaster plugin file.");
            }
            int fileExtensionIndex = windowsSourcePluginFile.toString().lastIndexOf(".");
            if (fileExtensionIndex == -1) {
                throw new FeedbackException("The file you selected is not a .fmx or .fmx64: " + windowsSourcePluginFile.getName());
            }
            String fileExtension = windowsSourcePluginFile.toString().substring(fileExtensionIndex);
            if (!".fmx".equals(fileExtension) && !".fmx64".equals(fileExtension)) {
                throw new FeedbackException("The file you selected is not a .fmx or .fmx64: " + windowsSourcePluginFile.getName());
            }
            File winDir = new File(folderToWriteTo, "WIN");
            File winDestPlugin = new File(winDir, pluginName + fileExtension);
            if (!winDir.exists() && !winDir.mkdirs()) {
                throw new IOException("Could not create Windows plugin directory: " + winDir);
            }
            try (FileOutputStream winDestStream = new FileOutputStream(winDestPlugin);){
                int jarSize = JarUtils.getJarSize(windowsSourcePluginFile);
                int fmxSize = (int)(windowsSourcePluginFile.length() - (long)jarSize);
                try (FileInputStream winSourceStream = new FileInputStream(windowsSourcePluginFile);){
                    this.writeBytes(winSourceStream, winDestStream, fmxSize);
                }
                try (JarOutputStream jarOutput = new JarOutputStream(new BufferedOutputStream(winDestStream));){
                    JarInputStream jarInput = new JarInputStream(new BufferedInputStream(BeanShellModel.getPluginJarStream(pluginJarFile)));
                    try {
                        this.writeModifiedJar(pluginName, quadChar, pluginPrefix, helpText, versionString, jarInput, pluginJarAttributes, jarOutput);
                    }
                    finally {
                        jarInput.close();
                        dt.markTime("Wrote modified plugin jar");
                    }
                    this.generateModulesJar(functionsToInclude, jarOutput);
                }
            }
            SearchAndReplace.addWindowsVersionInfo(winDestPlugin, versionString);
        }
        dt.stop();
        String registerFunction = pluginPrefix + "Register( \"" + generatedLicenseKey + "\"; \"" + registeredTo + "\" )";
        File registrationInfo = new File(folderToWriteTo, "Registration.txt");
        try (FileWriter writer = new FileWriter(registrationInfo, false);){
            writer.write("To register your generated plugin in FileMaker, add this script step to your startup script:\n\nSet Variable[$register; " + registerFunction + "]");
        }
        return registerFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPluginVersionPrefs(String pluginName, String versionString, File pListFile) throws IOException, FeedbackException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
        StringWriter stringWriter = new StringWriter();
        FileInputStream fileInputStream = new FileInputStream(pListFile);
        try {
            XMLEventReader eventReader = xmlInputFactory.createXMLEventReader("Info.plist", fileInputStream);
            XMLEventWriter eventWriter = xmlOutputFactory.createXMLEventWriter(stringWriter);
            try {
                boolean readVersionKeyElement = false;
                boolean readVersionTextKeyElement = false;
                boolean readVersionStringElementStart = false;
                boolean readVersionTextStringElementStart = false;
                boolean readVersion = false;
                boolean readVersionText = false;
                while (eventReader.hasNext() && !readVersion || !readVersionText) {
                    XMLEvent event = (XMLEvent)eventReader.next();
                    boolean addExisting = true;
                    if (event.isCharacters() && !readVersionKeyElement && "CFBundleVersion".equals(event.asCharacters().getData())) {
                        readVersionKeyElement = true;
                    } else if (event.isStartElement() && readVersionKeyElement && !readVersionStringElementStart) {
                        readVersionStringElementStart = true;
                    } else if (event.isCharacters() && readVersionKeyElement && readVersionStringElementStart && !readVersion) {
                        addExisting = false;
                        eventWriter.add(xmlEventFactory.createCharacters(versionString));
                        readVersion = true;
                    }
                    if (event.isCharacters() && !readVersionTextKeyElement && "CFBundleShortVersionString".equals(event.asCharacters().getData())) {
                        readVersionTextKeyElement = true;
                    } else if (event.isStartElement() && readVersionTextKeyElement && !readVersionTextStringElementStart) {
                        readVersionTextStringElementStart = true;
                    } else if (event.isCharacters() && readVersionTextKeyElement && readVersionTextStringElementStart && !readVersionText) {
                        addExisting = false;
                        eventWriter.add(xmlEventFactory.createCharacters(pluginName + " version " + versionString));
                        readVersionText = true;
                    }
                    if (!addExisting) continue;
                    eventWriter.add(event);
                }
                eventWriter.add(eventReader);
            }
            finally {
                eventWriter.close();
                eventReader.close();
            }
            ByteArrayInputStream srcInputStream = new ByteArrayInputStream(stringWriter.toString().getBytes());
            FileOutputStream destOutputStream = new FileOutputStream(pListFile);
            try {
                IOUtils.writeInputToOutput((InputStream)srcInputStream, (OutputStream)destOutputStream, 8192);
            }
            finally {
                destOutputStream.close();
                srcInputStream.close();
            }
        }
        catch (XMLStreamException e) {
            throw new FeedbackException(e);
        }
        finally {
            fileInputStream.close();
            stringWriter.close();
        }
    }

    public static InputStream getPluginJarStream(File pluginJarFile) throws IOException {
        if (BeanShellPlugin.masqueradeAsRuntime) {
            pluginJarFile = new File("/Users/jesse/Desktop/plugin.jar");
        }
        FileInputStream result = new FileInputStream(pluginJarFile);
        for (long skipAmount = BeanShellModel.pluginJarSkipAmount(pluginJarFile); skipAmount > 0L; skipAmount -= ((InputStream)result).skip(skipAmount)) {
        }
        return result;
    }

    static long pluginJarSkipAmount(@NotNull File pluginJarFile) throws IOException {
        if (pluginJarFile == null) {
            BeanShellModel.$$$reportNull$$$0(0);
        }
        long skipAmount = 0L;
        if (!pluginJarFile.getName().endsWith(".jar")) {
            int jarSize = JarUtils.getJarSize(pluginJarFile);
            skipAmount = pluginJarFile.length() - (long)jarSize;
        }
        return skipAmount;
    }

    private String callWebService(String pluginName, String helpText, String version, String quadChar, String licenseKey, Collection<FunctionDefinition> functionsList) throws FeedbackException {
        StringBuffer functionString = new StringBuffer();
        for (FunctionDefinition definition : functionsList) {
            if (functionString.length() > 0) {
                functionString.append("\n");
            }
            functionString.append(definition.getSignature());
        }
        try {
            CreateScriptMasterPlugin parameters = new CreateScriptMasterPlugin();
            parameters.setPluginName(pluginName);
            parameters.setHelpText(helpText);
            parameters.setVersion(new BigDecimal(version).shortValue());
            parameters.setQuadChar(quadChar);
            parameters.setInputLicenseKey(Integer.parseInt(licenseKey));
            parameters.setFunctionsList(functionString.toString());
            AuthenticatedUser authenticatedUser = new AuthenticatedUser();
            authenticatedUser.setUsername("smcreate");
            authenticatedUser.setPassword("9createsm9");
            if (createPluginPort == null) {
                createPluginPort = new CreateScriptMasterPluginService_Service().getCreateScriptMasterPluginServicePort();
                ((BindingProvider)((Object)createPluginPort)).getRequestContext().put("javax.xml.ws.service.endpoint.address", CREATE_PLUGIN_ENDPOINT);
            }
            CreateScriptMasterPluginResponse createScriptMasterPluginResponse = createPluginPort.createScriptMasterPlugin(parameters, authenticatedUser);
            return createScriptMasterPluginResponse.getResultLicenseKey();
        }
        catch (Exception e) {
            throw new FeedbackException(e);
        }
    }

    private void writeBytes(InputStream in, OutputStream out, long size) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        for (long bytesWritten = 0L; bytesWritten < size; bytesWritten += (long)bytesRead) {
            bytesRead = in.read(buffer);
            out.write(buffer, 0, bytesRead);
        }
    }

    private void writeModifiedJar(String pluginName, String quadChar, String pluginPrefix, String helpText, String versionString, JarInputStream jarInput, Map<String, String> jarInputAttributes, JarOutputStream jarOutput) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        for (String key : jarInputAttributes.keySet()) {
            attributes.putValue(key, jarInputAttributes.get(key));
        }
        attributes.putValue("plugin-name", pluginName);
        Object value = attributes.getValue("plugin-options");
        value = quadChar + ((String)value).substring(4);
        attributes.putValue("plugin-options", (String)value);
        attributes.putValue("is-scriptmaster-runtime", "true");
        attributes.putValue("plugin-help", helpText + " (" + versionString + ")");
        attributes.putValue("plugin-version", versionString);
        attributes.putValue("plugin-prefix", pluginPrefix);
        JarEntry jarEntry = new JarEntry("META-INF/MANIFEST.MF");
        jarOutput.putNextEntry(jarEntry);
        manifest.write(jarOutput);
        jarOutput.closeEntry();
        this.copyJarInputToOutput(jarInput, jarOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateModulesJar(Collection<FunctionDefinition> functionsToInclude, JarOutputStream modulesOut) throws IOException {
        block6: {
            JarEntry modules = new JarEntry("META-INF/modules.dat");
            modulesOut.putNextEntry(modules);
            ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(modulesOut));
            objectOut.writeInt(functionsToInclude.size());
            log.info("Wrote functions size: " + functionsToInclude.size());
            for (FunctionDefinition definition : functionsToInclude) {
                objectOut.writeObject(definition.getScript());
                objectOut.writeObject(definition.getSignature());
                objectOut.writeBoolean(definition.isGuiFunction());
                objectOut.writeShort(0);
            }
            objectOut.flush();
            modulesOut.closeEntry();
            FunctionCompiler compiler = new FunctionCompiler();
            for (FunctionDefinition eachDef : functionsToInclude) {
                String script = eachDef.getScript();
                ClassLoader cl = this.getClassLoader();
                List<CompiledClass> compiledClasses = compiler.compile(eachDef.getClassName(), script, cl);
                for (CompiledClass eachCompiledClass : compiledClasses) {
                    log.log(Level.INFO, "Adding " + eachDef.getSignature() + " / " + eachCompiledClass.getName());
                    JarEntry eachEntry = new JarEntry(eachCompiledClass.getName().replace('.', '/') + ".class");
                    modulesOut.putNextEntry(eachEntry);
                    modulesOut.write(eachCompiledClass.getBytes());
                    modulesOut.closeEntry();
                }
            }
            if (this.urls == null) break block6;
            for (URL eachModuleJar : this.urls) {
                JarInputStream stream = null;
                try {
                    stream = new JarInputStream(eachModuleJar.openStream());
                    this.copyJarInputToOutput(stream, modulesOut);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
                IOUtils.closeQuietly(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyJarInputToOutput(JarInputStream jarInput, JarOutputStream jarOutput) throws IOException {
        JarEntry inputEntry;
        while ((inputEntry = jarInput.getNextJarEntry()) != null) {
            String path = inputEntry.getName();
            try {
                if (path.startsWith("META-INF/") && path.indexOf(47) == path.lastIndexOf(47) && ("META-INF/".equals(path) || path.endsWith(".RSA") || path.endsWith(".DSA") || path.endsWith(".SF"))) continue;
                JarEntry newEntry = new JarEntry(inputEntry);
                newEntry.setCompressedSize(-1L);
                jarOutput.putNextEntry(newEntry);
                try {
                    IOUtils.writeInputToOutput((InputStream)jarInput, (OutputStream)jarOutput, 8192);
                }
                finally {
                    jarOutput.closeEntry();
                }
            }
            catch (ZipException e) {
                if (e.getMessage().startsWith("duplicate entry")) {
                    log.fine("Duplicate entry, ignored: " + e.getMessage());
                    continue;
                }
                log.log(Level.WARNING, "Exception while adding " + inputEntry, e);
            }
            finally {
                jarInput.closeEntry();
            }
        }
    }

    public static void copyRecursive(File srcFile, File dstDir) throws IOException {
        if (srcFile.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcFile.list();
            for (int i = 0; i < children.length; ++i) {
                BeanShellModel.copyRecursive(new File(srcFile, children[i]), new File(dstDir, children[i]));
            }
        } else if (!"plugin.jar".equals(srcFile.getName())) {
            IOUtils.copyFile(srcFile, dstDir);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginJarFile", "com/prosc/beanshell/BeanShellModel", "pluginJarSkipAmount"));
    }
}

