/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.util;

import com.prosc.util.Sequencer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TimedMap<K, V>
implements Map<K, V> {
    private final Map<K, V> delegate;
    private final int triggerTime;
    private final Sequencer sequencer = new Sequencer();

    public TimedMap(final int sizeLimit, int timeoutMilliseconds) {
        this.triggerTime = timeoutMilliseconds;
        this.delegate = new LinkedHashMap<K, V>(sizeLimit, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                if (this.size() > sizeLimit) {
                    TimedMap.this._onTrigger(eldest.getKey(), eldest.getValue());
                    return false;
                }
                return false;
            }
        };
    }

    public TimedMap(Map<K, V> delegate, int timeoutMilliseconds) {
        this.triggerTime = timeoutMilliseconds;
        this.delegate = delegate;
    }

    @Override
    public V get(Object key) {
        V v = this.delegate.get(key);
        if (v == null) {
            return null;
        }
        this.sequencer.appendExisting(key, System.currentTimeMillis() + (long)this.triggerTime);
        return v;
    }

    @Override
    public V put(final K key, final V value) {
        this.sequencer.appendNew(key, System.currentTimeMillis() + (long)this.triggerTime, new Runnable(){

            @Override
            public void run() {
                TimedMap.this._onTrigger(key, value);
            }
        });
        return this.delegate.put(key, value);
    }

    private void _onTrigger(K key, V value) {
        if (this.delegate.containsKey(key)) {
            this.onTrigger(key, value);
            this.delegate.remove(key);
        }
    }

    protected void onTrigger(K key, V value) {
    }

    @Override
    public V remove(Object key) {
        this.sequencer.remove(key);
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (final Map.Entry<K, V> entry : m.entrySet()) {
            this.sequencer.appendNew(entry.getKey(), System.currentTimeMillis() + (long)this.triggerTime, new Runnable(){

                @Override
                public void run() {
                    TimedMap.this._onTrigger(entry.getKey(), entry.getValue());
                }
            });
        }
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.sequencer.clear();
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }
}

