/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.util;

import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateUtils {
    public static boolean isTimeBetween(long startTime, long endTime, Date dateToCheck) {
        Calendar calendarDateToCheck = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendarDateToCheck.setTime(dateToCheck);
        GregorianCalendar onlyDate = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        onlyDate.setTimeInMillis(0L);
        onlyDate.set(1, calendarDateToCheck.get(1));
        onlyDate.set(2, calendarDateToCheck.get(2));
        onlyDate.set(5, calendarDateToCheck.get(5));
        long timeToCheck = dateToCheck.getTime() - onlyDate.getTimeInMillis();
        if (startTime > endTime) {
            endTime += 86400000L;
        }
        if (timeToCheck < startTime) {
            timeToCheck += 86400000L;
        }
        return timeToCheck >= startTime && timeToCheck <= endTime;
    }

    public static boolean isTimeBetween(LocalTime startTime, LocalTime endTime, Date dateToCheck) {
        boolean isCheckBeforeEnd;
        LocalTime timeToCheck = dateToCheck.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
        boolean isStartTimeBeforeEnd = startTime.compareTo(endTime) < 0;
        boolean isCheckAfterStart = timeToCheck.compareTo(startTime) >= 0;
        boolean bl = isCheckBeforeEnd = timeToCheck.compareTo(endTime) <= 0;
        if (isStartTimeBeforeEnd) {
            return isCheckAfterStart && isCheckBeforeEnd;
        }
        return isCheckAfterStart || isCheckBeforeEnd;
    }
}

