/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing.editors;

import com.prosc.format.FlexibleDateFormat;
import com.prosc.swing.editors.GenericEditor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class DateEditor
extends GenericEditor {
    private Date value;
    private DateFormat format = new FlexibleDateFormat();

    @Override
    public void setValue(Object value) {
        this.value = (Date)value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getAsText() {
        return this.value == null ? null : this.format.format(this.value);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null || text.length() == 0) {
            this.value = null;
        } else {
            try {
                this.value = this.format.parse(text);
            }
            catch (ParseException e) {
                IllegalArgumentException exception = new IllegalArgumentException("Cannot parse " + text + " as a date");
                exception.initCause(e);
                throw exception;
            }
        }
    }
}

