/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class ProscDialogBuilder {
    private Component owner;
    private String title;
    private Object mainContent;
    private ArrayList<Component> buttons = new ArrayList(2);
    private int defaultCloseOperation = 2;
    private Dimension dialogSize;
    private JDialog dialog;

    public ProscDialogBuilder(Component owner, String title, Object mainContent) {
        this.owner = owner;
        this.title = title;
        this.mainContent = mainContent;
    }

    public ProscDialogBuilder addButton(Component button) {
        button.setFocusable(false);
        this.buttons.add(button);
        return this;
    }

    public ProscDialogBuilder addButtonOK(JButton okButton) {
        okButton.setText(UIManager.getString("OptionPane.okButtonText"));
        return this.addButton(okButton);
    }

    public ProscDialogBuilder addButtonCancel() {
        return this.addButton(new JButton(new AbstractAction(UIManager.getString((Object)"OptionPane.cancelButtonText", Locale.getDefault())){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProscDialogBuilder.this.dialog != null) {
                    ProscDialogBuilder.this.dialog.dispose();
                }
            }
        }));
    }

    public JDialog build() {
        JOptionPane jOptionPane = new JOptionPane(this.mainContent, -1, 2, null, this.buttons.toArray());
        this.dialog = jOptionPane.createDialog(this.owner, this.title);
        this.dialog.setDefaultCloseOperation(this.defaultCloseOperation);
        return this.configure(this.dialog);
    }

    public ProscDialogBuilder defaultCloseOperation(int defaultCloseOperation) {
        this.defaultCloseOperation = defaultCloseOperation;
        return this;
    }

    protected JDialog configure(JDialog dialog) {
        for (Component eachButton : this.buttons) {
            if (!(eachButton instanceof JButton)) continue;
            dialog.getRootPane().setDefaultButton((JButton)eachButton);
            break;
        }
        dialog.setResizable(true);
        if (this.dialogSize != null) {
            dialog.setSize(this.dialogSize);
        }
        SwingUtils.installCloseKeys(dialog);
        return dialog;
    }

    public ProscDialogBuilder setDialogSize(Dimension dialogSize) {
        this.dialogSize = dialogSize;
        return this;
    }
}

