/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontPicker
extends JPanel {
    private static final Logger log = Logger.getLogger(FontPicker.class.getName());
    private JList family;
    private JList style;
    private JList size;
    private JLabel sampleText;
    private Map<String, List<Font>> fontFamilies;
    private Font selectedFont;

    public FontPicker() {
        this.generateFontLists();
        this.initComponents();
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public Font showDialog() {
        return this.showDialog(null);
    }

    public Font showDialog(Frame owner) {
        JOptionPane jp = new JOptionPane(this, -1, 2);
        JDialog dialog = jp.createDialog(owner, "Choose Font");
        dialog.setSize(400, 300);
        dialog.setModal(true);
        dialog.setResizable(true);
        dialog.setVisible(true);
        if (jp.getValue() != null && new Integer(0).equals(jp.getValue())) {
            return this.getSelectedFont();
        }
        return null;
    }

    public void setStartingFont(Font font) {
        if (font != null) {
            this.family.setSelectedValue(font.getFamily(), true);
            this.style.setSelectedValue(font.deriveFont(1.0f), true);
            this.size.setSelectedValue(font.getSize(), true);
            this.setSelectedFont(font);
        }
    }

    public void setSampleText(String sampleText) {
        this.sampleText.setText(sampleText);
    }

    private void setSelectedFont(Font input) {
        if (input != null) {
            Font actualFont;
            this.selectedFont = actualFont = input.deriveFont(((Number)this.size.getSelectedValue()).floatValue());
            Dimension dimension = this.sampleText.getSize();
            if (dimension.width != 0 && dimension.height != 0) {
                this.sampleText.setPreferredSize(dimension);
            }
            this.sampleText.setFont(actualFont);
            this.sampleText.revalidate();
        }
    }

    private void initComponents() {
        Box selectionLists = Box.createHorizontalBox();
        this.family = new JList<Object>(this.fontFamilies.keySet().toArray());
        this.style = new JList();
        Integer defaultSize = 12;
        this.size = new JList<Integer>(new Integer[]{6, 8, 10, defaultSize, 14, 16, 18, 24, 36, 72});
        this.size.setPrototypeCellValue(99999);
        this.size.setSelectedValue(defaultSize, true);
        JScrollPane familyScrollPane = new JScrollPane(this.family);
        familyScrollPane.setMaximumSize(new Dimension(120, Integer.MAX_VALUE));
        selectionLists.add(familyScrollPane);
        selectionLists.add(Box.createHorizontalStrut(5));
        selectionLists.add(new JScrollPane(this.style));
        selectionLists.add(Box.createHorizontalStrut(5));
        JScrollPane sizeScrollPane = new JScrollPane(this.size);
        sizeScrollPane.setMaximumSize(new Dimension(50, Integer.MAX_VALUE));
        selectionLists.add(sizeScrollPane);
        this.sampleText = new JLabel("The quick brown fox jumped over the lazy dogs.");
        this.sampleText.setHorizontalAlignment(0);
        this.setLayout(new BorderLayout());
        this.add((Component)selectionLists, "North");
        this.add((Component)this.sampleText, "Center");
        this.style.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int i, boolean b, boolean b1) {
                return super.getListCellRendererComponent((JList<?>)jList, ((Font)object).getName(), i, b, b1);
            }
        });
        this.family.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    String selectedFontName = (String)FontPicker.this.family.getSelectedValue();
                    List styleList = (List)FontPicker.this.fontFamilies.get(selectedFontName);
                    FontPicker.this.style.setListData(styleList.toArray());
                    FontPicker.this.style.setSelectedIndex(0);
                }
            }
        });
        this.style.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting() && FontPicker.this.style.getSelectedValue() != null) {
                    FontPicker.this.setSelectedFont((Font)FontPicker.this.style.getSelectedValue());
                }
            }
        });
        this.size.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontPicker.this.setSelectedFont(FontPicker.this.selectedFont);
            }
        });
    }

    private void generateFontLists() {
        Font[] allFonts;
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.fontFamilies = new LinkedHashMap<String, List<Font>>(gEnv.getAvailableFontFamilyNames().length);
        LinkedList<Font> faces = null;
        String currentFamily = null;
        for (Font eachFont : allFonts = gEnv.getAllFonts()) {
            if (!this.includeFont(eachFont)) continue;
            if (!eachFont.getFamily().equals(currentFamily)) {
                currentFamily = eachFont.getFamily();
                faces = new LinkedList<Font>();
                this.fontFamilies.put(currentFamily, faces);
            }
            if (faces == null) continue;
            faces.add(eachFont);
        }
    }

    protected boolean includeFont(Font font) {
        boolean result = true;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Include font {0}? " + result, font);
        }
        return result;
    }

    public static void main(String[] args) {
        FontPicker fontPicker = new FontPicker();
        Font startingFont = new Font("Gill Sans", 0, 18);
        fontPicker.setStartingFont(startingFont);
        Font selectedFont = fontPicker.showDialog(null);
        log.info("Selected font: " + selectedFont);
    }
}

