/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.shared.CallableWithRetry;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class Retry3 {
    private static final Logger log = Logger.getLogger(Retry3.class.getName());

    public final <T, E1 extends Exception, E2 extends Exception> T doTask(int maxTries, int startingDelayMilliseconds, CallableWithRetry<T> callable, Class<E1> expectedExceptionType1, Class<E2> expectedExceptionType2) throws E1, E2 {
        int delay = 0;
        int attempt = 1;
        while (true) {
            try {
                T result = callable.call(attempt, maxTries);
                if (attempt > 1) {
                    String attemptName = attempt == 2 ? "2nd" : (attempt == 3 ? "3rd" : String.valueOf(attempt) + "th");
                    log.info("Task succeeded on the " + attemptName + " attempt");
                }
                return result;
            }
            catch (Exception e) {
                try {
                    if (attempt < maxTries && (expectedExceptionType1.isAssignableFrom(e.getClass()) || expectedExceptionType2.isAssignableFrom(e.getClass())) && this.shouldRetry(e)) {
                        delay = delay == 0 ? startingDelayMilliseconds : (delay *= 2);
                        log.info("Task failed; retry #" + ++attempt + " in " + delay + " milliseconds. Exception: " + e.toString());
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                            throw e;
                        }
                        continue;
                    }
                    throw e;
                }
                catch (Exception e2) {
                    if (expectedExceptionType1.isAssignableFrom(e2.getClass())) {
                        throw e2;
                    }
                    if (expectedExceptionType2.isAssignableFrom(e2.getClass())) {
                        throw e2;
                    }
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    throw new RuntimeException(e2);
                }
            }
            break;
        }
    }

    protected <E1 extends Exception> boolean shouldRetry(@NotNull E1 e) {
        if (e == null) {
            Retry3.$$$reportNull$$$0(0);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/prosc/shared/Retry3", "shouldRetry"));
    }
}

