/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.shared.CallableWithRetry;
import com.prosc.shared.NoSuchException;
import com.prosc.shared.Retry3;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class Retry {
    private static Level loggingLevel = Level.INFO;
    private static final Logger log = Logger.getLogger(Retry3.class.getName());

    public final <T, E1 extends Exception> T doTask(int maxTries, int startingDelayMilliseconds, Class<E1> expectedExceptionType1, CallableWithRetry<T> callable) throws E1 {
        return this.doTask(maxTries, startingDelayMilliseconds, expectedExceptionType1, NoSuchException.class, NoSuchException.class, NoSuchException.class, callable);
    }

    public final <T, E1 extends Exception, E2 extends Exception> T doTask(int maxTries, int startingDelayMilliseconds, Class<E1> expectedExceptionType1, Class<E2> expectedExceptionType2, CallableWithRetry<T> callable) throws E1, E2 {
        return this.doTask(maxTries, startingDelayMilliseconds, expectedExceptionType1, expectedExceptionType2, NoSuchException.class, NoSuchException.class, callable);
    }

    public final <T, E1 extends Exception, E2 extends Exception, E3 extends Exception> T doTask(int maxTries, int startingDelayMilliseconds, Class<E1> expectedExceptionType1, Class<E2> expectedExceptionType2, Class<E3> expectedExceptionType3, CallableWithRetry<T> callable) throws E1, E2, E3 {
        return this.doTask(maxTries, startingDelayMilliseconds, expectedExceptionType1, expectedExceptionType2, expectedExceptionType3, NoSuchException.class, callable);
    }

    public final <T, E1 extends Exception, E2 extends Exception, E3 extends Exception, E4 extends Exception> T doTask(int maxTries, int startingDelayMilliseconds, Class<E1> expectedExceptionType1, Class<E2> expectedExceptionType2, Class<E3> expectedExceptionType3, Class<E4> expectedExceptionType4, CallableWithRetry<T> callable) throws E1, E2, E3, E4 {
        int delay = 0;
        int attempt = 1;
        while (true) {
            try {
                T result = callable.call(attempt, maxTries);
                if (attempt > 1) {
                    String attemptName = attempt == 2 ? "2nd" : (attempt == 3 ? "3rd" : attempt + "th");
                    log.log(loggingLevel, "Task succeeded on the " + attemptName + " attempt");
                }
                return result;
            }
            catch (Exception e) {
                try {
                    if (attempt < maxTries && (expectedExceptionType1.isAssignableFrom(e.getClass()) || expectedExceptionType2.isAssignableFrom(e.getClass()) || expectedExceptionType3.isAssignableFrom(e.getClass()) || expectedExceptionType4.isAssignableFrom(e.getClass()))) {
                        this.shouldRetry(e);
                        delay = delay == 0 ? startingDelayMilliseconds : (delay *= 2);
                        log.log(loggingLevel, "Task failed; attempt #" + ++attempt + " will run in " + delay + " milliseconds. Exception: " + e.toString());
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                            throw e;
                        }
                        continue;
                    }
                    throw e;
                }
                catch (Exception e2) {
                    if (expectedExceptionType1.isAssignableFrom(e2.getClass())) {
                        throw e2;
                    }
                    if (expectedExceptionType2.isAssignableFrom(e2.getClass())) {
                        throw e2;
                    }
                    if (expectedExceptionType3.isAssignableFrom(e2.getClass())) {
                        throw e2;
                    }
                    if (expectedExceptionType4.isAssignableFrom(e2.getClass())) {
                        throw e2;
                    }
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    throw new RuntimeException(e2);
                }
            }
            break;
        }
    }

    protected void shouldRetry(@NotNull Exception e) throws Exception {
        if (e == null) {
            Retry.$$$reportNull$$$0(0);
        }
    }

    public static void setLoggingLevel(Level loggingLevel) {
        Retry.loggingLevel = loggingLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/prosc/shared/Retry", "shouldRetry"));
    }
}

