/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class PerformanceInfo
implements Serializable {
    public static final ConcurrentHashMap<String, PerformanceInfo> performanceInfoMap = new ConcurrentHashMap();
    private static final long serialVersionUID = 5601189073215391459L;
    transient ArrayBlockingQueue<Long> bounded = new ArrayBlockingQueue(30);
    final Date runningSince = new Date();
    Date lastActivity = new Date();
    transient long movingSum = 0L;
    transient long overallSum = 0L;
    double exponentialMovingAvg = 0.0;
    long totalCount;
    private transient long previousValue;

    public synchronized double getExponentialMovingAvg() {
        return this.exponentialMovingAvg;
    }

    public synchronized Date getLastActivity() {
        return this.lastActivity;
    }

    public synchronized long getTotalCount() {
        return this.totalCount;
    }

    public synchronized long getOverallSum() {
        return this.overallSum;
    }

    public synchronized Date getRunningSince() {
        return this.runningSince;
    }

    public static void addSample(String action, long value) {
        PerformanceInfo performanceInfo = performanceInfoMap.get(action);
        if (performanceInfo == null) {
            performanceInfoMap.putIfAbsent(action, new PerformanceInfo());
            performanceInfo = performanceInfoMap.get(action);
        }
        performanceInfo._log(value);
    }

    public static <E> E addSample(String action, Callable<E> task) {
        E call;
        long start = System.currentTimeMillis();
        try {
            call = task.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        PerformanceInfo.addSample(action, System.currentTimeMillis() - start);
        return call;
    }

    private synchronized void _log(long value) {
        while (!this.bounded.offer(value)) {
            Long removed = this.bounded.poll();
            if (removed == null) continue;
            this.movingSum -= removed.longValue();
        }
        this.movingSum += value;
        this.overallSum += value;
        if (this.exponentialMovingAvg == 0.0) {
            this.exponentialMovingAvg = value;
        } else {
            double smoothing = 0.75;
            this.exponentialMovingAvg += smoothing * ((double)this.previousValue - this.exponentialMovingAvg);
            this.previousValue = value;
        }
        ++this.totalCount;
        this.lastActivity = new Date();
    }

    public String toString() {
        return "PerformanceInfo{exponentialMovingAvg=" + this.exponentialMovingAvg + '}';
    }

    public static Map<String, Object> getExtraFixedAttributes() {
        HashMap<String, Object> result = new HashMap<String, Object>(performanceInfoMap.size() + 12);
        for (Map.Entry<String, PerformanceInfo> e : performanceInfoMap.entrySet()) {
            PerformanceInfo value = e.getValue();
            result.put(e.getKey(), String.format("%d: %dms avg overall, %dms moving avg", value.totalCount, Math.round(value.overallSum / value.totalCount), Math.round(value.exponentialMovingAvg)));
        }
        return result;
    }

    public static Map<String, Object> getExtraRelativeAttributes() {
        HashMap<String, Object> result = new HashMap<String, Object>(performanceInfoMap.size());
        for (Map.Entry<String, PerformanceInfo> e : performanceInfoMap.entrySet()) {
            PerformanceInfo value = e.getValue();
            result.put(e.getKey(), String.format("%,d ms avg", Math.round(value.exponentialMovingAvg)));
        }
        return result;
    }

    public static PerformanceInfo getAction(String s) {
        return performanceInfoMap.get(s);
    }
}

