/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.data.BasicTypeConverter;
import com.prosc.shared.Arg;
import com.prosc.shared.ArgParsingException;
import com.prosc.shared.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ArgsParser {
    public void parse(Class<?> whichClass, String[] args) throws ArgParsingException {
        this.parse(whichClass, null, args);
    }

    public void parse(Class<?> whichClass, Object targetObject, String[] args) throws ArgParsingException {
        Field[] fields;
        HashMap<String, Field> flagToField = new HashMap<String, Field>();
        HashMap<String, String> flagToFieldLowercase = new HashMap<String, String>();
        LinkedList<Field> requiredParams = new LinkedList<Field>();
        ArrayList<String> flaggedParams = new ArrayList<String>();
        LinkedList<Field> varParams = new LinkedList<Field>();
        for (Field field : fields = whichClass.getDeclaredFields()) {
            Arg arg = field.getAnnotation(Arg.class);
            if (arg == null) continue;
            if (!StringUtils.isEmpty(arg.shortFlag()) || !StringUtils.isEmpty(arg.longFlag())) {
                boolean isBoolean = field.getType() == Boolean.class || field.getType() == Boolean.TYPE;
                flaggedParams.add("[" + (StringUtils.isEmpty(arg.longFlag()) ? arg.shortFlag() : arg.longFlag()) + (isBoolean ? "" : " " + field.getName()) + "]");
                if (!StringUtils.isEmpty(arg.shortFlag())) {
                    flagToField.put(arg.shortFlag(), field);
                    flagToFieldLowercase.put(arg.shortFlag().toLowerCase(), arg.shortFlag());
                }
                if (StringUtils.isEmpty(arg.longFlag())) continue;
                flagToField.put(arg.longFlag(), field);
                flagToFieldLowercase.put(arg.longFlag().toLowerCase(), arg.longFlag());
                continue;
            }
            if (arg.required()) {
                requiredParams.add(field);
                continue;
            }
            varParams.add(field);
        }
        Field currentFlagField = null;
        try {
            ArrayList requiredParamsCopy = new ArrayList(requiredParams);
            ArrayList varParamsCopy = new ArrayList(varParams);
            Field currentOptionalParam = null;
            ArrayList<String> varArgValues = new ArrayList<String>();
            for (int n = 0; n < args.length; ++n) {
                String arg = args[n];
                if (flagToField.containsKey(arg)) {
                    currentFlagField = (Field)flagToField.get(arg);
                    Class<?> targetType = currentFlagField.getType();
                    if (targetType == Boolean.class || targetType == Boolean.TYPE) {
                        this.setConvertedValue(currentFlagField, targetObject, true);
                        continue;
                    }
                    this.setRawValue(currentFlagField, targetObject, args[++n]);
                    continue;
                }
                if (flagToFieldLowercase.containsKey(arg.toLowerCase())) {
                    this.fail("Argument flag '" + arg + "' is invalid. Argument flags are case-sensitive, did you mean '" + (String)flagToFieldLowercase.get(arg.toLowerCase()) + "'?", flaggedParams, requiredParams, varParams);
                    continue;
                }
                if (requiredParamsCopy.isEmpty()) {
                    if (varParamsCopy.isEmpty()) {
                        if (currentOptionalParam == null) {
                            this.fail("Too many parameters were supplied", flaggedParams, requiredParams, varParams);
                        }
                    } else {
                        currentOptionalParam = (Field)varParamsCopy.remove(0);
                    }
                    if (varParamsCopy.isEmpty()) {
                        varArgValues.add(args[n]);
                        continue;
                    }
                    this.setRawValue(currentOptionalParam, targetObject, args[n]);
                    continue;
                }
                Field field = (Field)requiredParamsCopy.remove(0);
                this.setRawValue(field, targetObject, arg);
            }
            if (!requiredParamsCopy.isEmpty()) {
                this.fail("Missing required parameters", flaggedParams, requiredParams, varParams);
            }
            if (currentOptionalParam != null) {
                this.setRawValue(currentOptionalParam, targetObject, varArgValues);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (currentFlagField == null) {
                this.fail("Mismatch between expected and actual parameters", flaggedParams, requiredParams, varParams);
            }
            this.fail("No value specified for " + currentFlagField.getName(), flaggedParams, requiredParams, varParams);
        }
    }

    private void setRawValue(Field field, Object targetObject, String argValue) {
        this.setConvertedValue(field, targetObject, BasicTypeConverter.convertObjectToClass(argValue, true, field.getType()));
    }

    private void setRawValue(Field field, Object targetObject, List<String> argValues) {
        if (field.getType().isArray()) {
            Class<?> arrayType = field.getType().getComponentType();
            Object[] convertedArray = (Object[])Array.newInstance(arrayType, argValues.size());
            for (int i = 0; i < argValues.size(); ++i) {
                convertedArray[i] = BasicTypeConverter.convertObjectToClass(argValues.get(i), true, arrayType);
            }
            this.setConvertedValue(field, targetObject, convertedArray);
        } else if (Collection.class.isAssignableFrom(field.getType())) {
            List convertedList = argValues.stream().map(argValue -> BasicTypeConverter.convertObjectToClass(argValue, true, field.getType())).collect(Collectors.toList());
            this.setConvertedValue(field, targetObject, convertedList);
        } else if (argValues.size() == 1) {
            this.setRawValue(field, targetObject, argValues.get(0));
        } else {
            throw new IllegalStateException("No values supplied for field: " + field);
        }
    }

    private void setConvertedValue(Field field, Object targetObject, Object convertedValue) {
        try {
            field.set(targetObject, convertedValue);
        }
        catch (IllegalAccessException e) {
            field.setAccessible(true);
            try {
                field.set(targetObject, convertedValue);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("The args could not be set for " + targetObject + " because the field " + field + " is not accessible / writeable");
            }
        }
    }

    private void fail(String message, List<String> flaggedParams, List<Field> requiredParams, List<Field> varParams) throws ArgParsingException {
        Object[] usageSections = new String[3];
        usageSections[0] = StringUtils.join(flaggedParams, " ");
        usageSections[1] = StringUtils.join(requiredParams.stream().map(Field::getName), " ");
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (int n = 0; n < varParams.size(); ++n) {
            Field field = varParams.get(n);
            sb.append(delim).append("[").append(field.getName());
            delim = " ";
            if (n + 1 == varParams.size() && (field.getType().isArray() || Collection.class.isAssignableFrom(field.getType()))) {
                sb.append("...]");
                continue;
            }
            sb.append("]");
        }
        usageSections[2] = sb.toString();
        String usageMessage = "Usage: " + StringUtils.join(usageSections, " ");
        throw new ArgParsingException(message, usageMessage);
    }
}

